/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.ConfigurationPluginLoader;
import com.espertech.esper.client.EPAdministrator;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPRuntime;
import com.espertech.esper.client.EPServiceDestroyedException;
import com.espertech.esper.client.EPServiceNotAllowedException;
import com.espertech.esper.client.EPServiceProviderIsolated;
import com.espertech.esper.client.EPServiceStateListener;
import com.espertech.esper.client.EPStatementStateListener;
import com.espertech.esper.core.context.mgr.ContextManagementService;
import com.espertech.esper.core.deploy.DeploymentStateService;
import com.espertech.esper.core.service.ConfigurationOperationsImpl;
import com.espertech.esper.core.service.EPAdministratorContext;
import com.espertech.esper.core.service.EPAdministratorImpl;
import com.espertech.esper.core.service.EPAdministratorSPI;
import com.espertech.esper.core.service.EPRuntimeImpl;
import com.espertech.esper.core.service.EPRuntimeSPI;
import com.espertech.esper.core.service.EPServiceProviderSPI;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPServicesContextFactory;
import com.espertech.esper.core.service.EPServicesContextFactoryDefault;
import com.espertech.esper.core.service.EngineEnvContext;
import com.espertech.esper.core.service.EngineLevelExtensionServicesContext;
import com.espertech.esper.core.service.InternalEventRouteDest;
import com.espertech.esper.core.service.StatementContextFactory;
import com.espertech.esper.core.service.StatementEventDispatcherUnthreaded;
import com.espertech.esper.core.service.StatementEventTypeRef;
import com.espertech.esper.core.service.StatementIsolationService;
import com.espertech.esper.core.service.StatementLifecycleSvc;
import com.espertech.esper.core.thread.ThreadingOption;
import com.espertech.esper.core.thread.ThreadingService;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.metric.MetricReportingPath;
import com.espertech.esper.epl.metric.MetricReportingService;
import com.espertech.esper.epl.named.NamedWindowService;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.vaevent.ValueAddEventService;
import com.espertech.esper.filter.FilterService;
import com.espertech.esper.metrics.codahale_metrics.metrics.MetricNameFactory;
import com.espertech.esper.metrics.codahale_metrics.metrics.core.MetricName;
import com.espertech.esper.metrics.jmx.CommonJMXUtil;
import com.espertech.esper.plugin.PluginLoader;
import com.espertech.esper.plugin.PluginLoaderInitContext;
import com.espertech.esper.schedule.SchedulingMgmtService;
import com.espertech.esper.schedule.SchedulingService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.timer.TimerCallback;
import com.espertech.esper.timer.TimerService;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.util.SerializableObjectCopier;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReadWriteLock;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPServiceProviderImpl
implements EPServiceProviderSPI {
    private static final Log log = LogFactory.getLog(EPServiceProviderImpl.class);
    private volatile EPServiceEngine engine;
    private ConfigurationInformation configSnapshot;
    private String engineURI;
    private Set<EPServiceStateListener> serviceListeners;
    private Set<EPStatementStateListener> statementListeners;
    private StatementEventDispatcherUnthreaded stmtEventDispatcher;
    private Map<String, EPServiceProviderSPI> runtimes;

    public EPServiceProviderImpl(Configuration configuration, String engineURI, Map<String, EPServiceProviderSPI> runtimes) throws ConfigurationException {
        if (configuration == null) {
            throw new NullPointerException("Unexpected null value received for configuration");
        }
        if (engineURI == null) {
            throw new NullPointerException("Engine URI should not be null at this stage");
        }
        this.runtimes = runtimes;
        this.engineURI = engineURI;
        this.verifyConfiguration(configuration);
        this.serviceListeners = new CopyOnWriteArraySet<EPServiceStateListener>();
        this.configSnapshot = this.takeSnapshot(configuration);
        this.statementListeners = new CopyOnWriteArraySet<EPStatementStateListener>();
        this.doInitialize(null);
    }

    @Override
    public synchronized EPServiceProviderIsolated getEPServiceIsolated(String name) {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        if (!this.engine.getServices().getConfigSnapshot().getEngineDefaults().getExecution().isAllowIsolatedService()) {
            throw new EPServiceNotAllowedException("Isolated runtime requires execution setting to allow isolated services, please change execution settings under engine defaults");
        }
        if (this.engine.getServices().getConfigSnapshot().getEngineDefaults().getViewResources().isShareViews()) {
            throw new EPServiceNotAllowedException("Isolated runtime requires view sharing disabled, set engine defaults under view resources and share views to false");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name parameter does not have a value provided");
        }
        return this.engine.getServices().getStatementIsolationService().getIsolationUnit(name, null);
    }

    @Override
    public void postInitialize() {
        List<ConfigurationPluginLoader> pluginLoaders = this.engine.getServices().getConfigSnapshot().getPluginLoaders();
        for (ConfigurationPluginLoader config : pluginLoaders) {
            try {
                PluginLoader plugin = (PluginLoader)this.engine.getServices().getEngineEnvContext().lookup("plugin-loader/" + config.getLoaderName());
                plugin.postInitialize();
            }
            catch (Throwable t) {
                String message = "Error post-initializing plugin class " + config.getClassName() + ": " + t.getMessage();
                log.error((Object)message, t);
                throw new EPException(message, t);
            }
        }
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.verifyConfiguration(configuration);
        this.configSnapshot = this.takeSnapshot(configuration);
    }

    private void verifyConfiguration(Configuration configuration) {
        if (configuration.getEngineDefaults().getExecution().isPrioritized()) {
            if (!configuration.getEngineDefaults().getViewResources().isShareViews()) {
                log.info((Object)"Setting engine setting for share-views to false as execution is prioritized");
            }
            configuration.getEngineDefaults().getViewResources().setShareViews(false);
        }
    }

    @Override
    public String getURI() {
        return this.engineURI;
    }

    @Override
    public EPRuntime getEPRuntime() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getRuntime();
    }

    @Override
    public EPAdministrator getEPAdministrator() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getAdmin();
    }

    @Override
    public EPServicesContext getServicesContext() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices();
    }

    @Override
    public ThreadingService getThreadingService() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getThreadingService();
    }

    @Override
    public EventAdapterService getEventAdapterService() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getEventAdapterService();
    }

    @Override
    public SchedulingService getSchedulingService() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getSchedulingService();
    }

    @Override
    public FilterService getFilterService() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getFilterService();
    }

    @Override
    public TimerService getTimerService() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getTimerService();
    }

    @Override
    public ConfigurationInformation getConfigurationInformation() {
        return this.configSnapshot;
    }

    @Override
    public NamedWindowService getNamedWindowService() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getNamedWindowService();
    }

    @Override
    public TableService getTableService() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getTableService();
    }

    @Override
    public EngineLevelExtensionServicesContext getExtensionServicesContext() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getEngineLevelExtensionServicesContext();
    }

    @Override
    public StatementLifecycleSvc getStatementLifecycleSvc() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getStatementLifecycleSvc();
    }

    @Override
    public MetricReportingService getMetricReportingService() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getMetricsReportingService();
    }

    @Override
    public ValueAddEventService getValueAddEventService() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getValueAddEventService();
    }

    @Override
    public StatementEventTypeRef getStatementEventTypeRef() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getStatementEventTypeRefService();
    }

    @Override
    public EngineEnvContext getEngineEnvContext() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getEngineEnvContext();
    }

    @Override
    public Context getContext() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getEngineEnvContext();
    }

    @Override
    public StatementContextFactory getStatementContextFactory() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getStatementContextFactory();
    }

    @Override
    public StatementIsolationService getStatementIsolationService() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getStatementIsolationService();
    }

    @Override
    public DeploymentStateService getDeploymentStateService() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getDeploymentStateService();
    }

    @Override
    public synchronized void destroy() {
        if (this.engine != null) {
            log.info((Object)("Destroying engine URI '" + this.engineURI + "'"));
            for (EPServiceStateListener listener : this.serviceListeners) {
                try {
                    listener.onEPServiceDestroyRequested(this);
                }
                catch (RuntimeException ex) {
                    log.error((Object)("Runtime exception caught during an onEPServiceDestroyRequested callback:" + ex.getMessage()), (Throwable)ex);
                }
            }
            if (this.configSnapshot.getEngineDefaults().getMetricsReporting().isJmxEngineMetrics()) {
                this.destroyEngineMetrics(this.engine.getServices().getEngineURI());
            }
            EPServiceEngine engineToDestroy = this.engine;
            engineToDestroy.getServices().getTimerService().stopInternalClock(false);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            List<ConfigurationPluginLoader> pluginLoaders = engineToDestroy.getServices().getConfigSnapshot().getPluginLoaders();
            if (!pluginLoaders.isEmpty()) {
                ArrayList<ConfigurationPluginLoader> reversed = new ArrayList<ConfigurationPluginLoader>(pluginLoaders);
                Collections.reverse(reversed);
                for (ConfigurationPluginLoader config : reversed) {
                    try {
                        PluginLoader plugin = (PluginLoader)engineToDestroy.getServices().getEngineEnvContext().lookup("plugin-loader/" + config.getLoaderName());
                        plugin.destroy();
                    }
                    catch (NamingException e) {
                    }
                    catch (RuntimeException e) {
                        log.error((Object)("Error destroying plug-in loader: " + config.getLoaderName()), (Throwable)e);
                    }
                }
            }
            engineToDestroy.getServices().getThreadingService().destroy();
            this.engine = null;
            engineToDestroy.getRuntime().destroy();
            engineToDestroy.getAdmin().destroy();
            engineToDestroy.getServices().destroy();
            this.runtimes.remove(this.engineURI);
            engineToDestroy.getServices().initialize();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.engine == null;
    }

    @Override
    public void initialize() {
        this.initializeInternal(null);
    }

    @Override
    public void initialize(Long currentTime) {
        this.initializeInternal(currentTime);
    }

    private void initializeInternal(Long currentTime) {
        this.doInitialize(currentTime);
        this.postInitialize();
    }

    protected void doInitialize(Long startTime) {
        EPAdministratorSPI adminSPI;
        TimerCallback timerCallback;
        InternalEventRouteDest routeDest;
        EPRuntimeSPI runtimeSPI;
        EPServicesContextFactory epServicesContextFactory;
        String epServicesContextFactoryClassName;
        log.info((Object)("Initializing engine URI '" + this.engineURI + "' version " + "5.3.0"));
        ExecutionPathDebugLog.setDebugEnabled(this.configSnapshot.getEngineDefaults().getLogging().isEnableExecutionDebug());
        ExecutionPathDebugLog.setTimerDebugEnabled(this.configSnapshot.getEngineDefaults().getLogging().isEnableTimerDebug());
        MetricReportingPath.setMetricsEnabled(this.configSnapshot.getEngineDefaults().getMetricsReporting().isEnableMetricsReporting());
        AuditPath.setAuditPattern(this.configSnapshot.getEngineDefaults().getLogging().getAuditPattern());
        ThreadingOption.setThreadingEnabled(ThreadingOption.isThreadingEnabled() || this.configSnapshot.getEngineDefaults().getThreading().isThreadPoolTimerExec() || this.configSnapshot.getEngineDefaults().getThreading().isThreadPoolInbound() || this.configSnapshot.getEngineDefaults().getThreading().isThreadPoolRouteExec() || this.configSnapshot.getEngineDefaults().getThreading().isThreadPoolOutbound());
        if (this.engine != null) {
            this.engine.getServices().getTimerService().stopInternalClock(false);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            if (this.configSnapshot.getEngineDefaults().getMetricsReporting().isJmxEngineMetrics()) {
                this.destroyEngineMetrics(this.engine.getServices().getEngineURI());
            }
            this.engine.getRuntime().initialize();
            this.engine.getServices().destroy();
        }
        if ((epServicesContextFactoryClassName = this.configSnapshot.getEPServicesContextFactoryClassName()) == null) {
            epServicesContextFactoryClassName = System.getProperty("ESPER_EPSERVICE_CONTEXT_FACTORY_CLASS");
        }
        if (epServicesContextFactoryClassName == null) {
            epServicesContextFactory = new EPServicesContextFactoryDefault();
        } else {
            Object obj;
            Class<?> clazz;
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                clazz = Class.forName(epServicesContextFactoryClassName, true, cl);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Class '" + epServicesContextFactoryClassName + "' cannot be loaded");
            }
            try {
                obj = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new ConfigurationException("Class '" + clazz + "' cannot be instantiated");
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Illegal access instantiating class '" + clazz + "'");
            }
            epServicesContextFactory = (EPServicesContextFactory)obj;
        }
        EPServicesContext services = epServicesContextFactory.createServicesContext(this, this.configSnapshot);
        String runtimeClassName = this.configSnapshot.getEngineDefaults().getAlternativeContext().getRuntime();
        if (runtimeClassName == null) {
            runtimeClassName = System.getProperty("ESPER_EPRUNTIME_CLASS");
        }
        if (runtimeClassName == null) {
            EPRuntimeImpl runtimeImpl;
            runtimeSPI = runtimeImpl = new EPRuntimeImpl(services);
            routeDest = runtimeImpl;
            timerCallback = runtimeImpl;
        } else {
            Object obj;
            Class<?> clazz;
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                clazz = Class.forName(runtimeClassName, true, cl);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Class '" + epServicesContextFactoryClassName + "' cannot be loaded");
            }
            try {
                Constructor<?> c = clazz.getConstructor(EPServicesContext.class);
                obj = c.newInstance(services);
            }
            catch (NoSuchMethodException e) {
                throw new ConfigurationException("Class '" + clazz + "' cannot be instantiated, constructor accepting services was not found");
            }
            catch (InstantiationException e) {
                throw new ConfigurationException("Class '" + clazz + "' cannot be instantiated");
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Illegal access instantiating class '" + clazz + "'");
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException("Exception invoking constructor of class '" + clazz + "'");
            }
            runtimeSPI = (EPRuntimeSPI)obj;
            routeDest = (InternalEventRouteDest)obj;
            timerCallback = (TimerCallback)obj;
        }
        routeDest.setInternalEventRouter(services.getInternalEventRouter());
        services.setInternalEventEngineRouteDest(routeDest);
        if (startTime != null) {
            services.getSchedulingService().setTime(startTime);
        }
        services.getTimerService().setCallback(timerCallback);
        services.getStatementLifecycleSvc().init();
        services.getFilterService().init();
        services.getSchedulingService().init();
        ConfigurationOperationsImpl configOps = new ConfigurationOperationsImpl(services.getEventAdapterService(), services.getEventTypeIdGenerator(), services.getEngineImportService(), services.getVariableService(), services.getEngineSettingsService(), services.getValueAddEventService(), services.getMetricsReportingService(), services.getStatementEventTypeRefService(), services.getStatementVariableRefService(), services.getPlugInViews(), services.getFilterService(), services.getPatternSubexpressionPoolSvc(), services.getMatchRecognizeStatePoolEngineSvc(), services.getTableService());
        SelectClauseStreamSelectorEnum defaultStreamSelector = SelectClauseStreamSelectorEnum.mapFromSODA(this.configSnapshot.getEngineDefaults().getStreamSelection().getDefaultStreamSelector());
        String adminClassName = this.configSnapshot.getEngineDefaults().getAlternativeContext().getAdmin();
        EPAdministratorContext adminContext = new EPAdministratorContext(runtimeSPI, services, configOps, defaultStreamSelector);
        if (adminClassName == null) {
            adminClassName = System.getProperty("ESPER_EPADMIN_CLASS");
        }
        if (adminClassName == null) {
            adminSPI = new EPAdministratorImpl(adminContext);
        } else {
            Object obj;
            Class<?> clazz;
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                clazz = Class.forName(adminClassName, true, cl);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Class '" + epServicesContextFactoryClassName + "' cannot be loaded");
            }
            try {
                Constructor<?> c = clazz.getConstructor(EPAdministratorContext.class);
                obj = c.newInstance(adminContext);
            }
            catch (NoSuchMethodException e) {
                throw new ConfigurationException("Class '" + clazz + "' cannot be instantiated, constructor accepting context was not found");
            }
            catch (InstantiationException e) {
                throw new ConfigurationException("Class '" + clazz + "' cannot be instantiated");
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Illegal access instantiating class '" + clazz + "'");
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException("Exception invoking constructor of class '" + clazz + "'");
            }
            adminSPI = (EPAdministratorSPI)obj;
        }
        if (this.configSnapshot.getEngineDefaults().getThreading().isInternalTimerEnabled()) {
            services.getTimerService().startInternalClock();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.engine = new EPServiceEngine(services, runtimeSPI, adminSPI);
        this.loadAdapters(services);
        if (services.getEngineLevelExtensionServicesContext() != null) {
            services.getEngineLevelExtensionServicesContext().init(services, runtimeSPI, adminSPI);
        }
        if (this.configSnapshot.getEngineDefaults().getMetricsReporting().isEnableMetricsReporting()) {
            services.getMetricsReportingService().setContext(runtimeSPI, services);
        }
        if (this.configSnapshot.getEngineDefaults().getMetricsReporting().isJmxEngineMetrics()) {
            this.startEngineMetrics(services, runtimeSPI);
        }
        for (EPServiceStateListener listener : this.serviceListeners) {
            try {
                listener.onEPServiceInitialized(this);
            }
            catch (RuntimeException ex) {
                log.error((Object)("Runtime exception caught during an onEPServiceInitialized callback:" + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private synchronized void startEngineMetrics(EPServicesContext services, EPRuntime runtime) {
        MetricName filterName = MetricNameFactory.name(services.getEngineURI(), "filter");
        CommonJMXUtil.registerMbean((Object)services.getFilterService(), filterName);
        MetricName scheduleName = MetricNameFactory.name(services.getEngineURI(), "schedule");
        CommonJMXUtil.registerMbean((Object)services.getSchedulingService(), scheduleName);
        MetricName runtimeName = MetricNameFactory.name(services.getEngineURI(), "runtime");
        CommonJMXUtil.registerMbean((Object)runtime, runtimeName);
    }

    private synchronized void destroyEngineMetrics(String engineURI) {
        CommonJMXUtil.unregisterMbean(MetricNameFactory.name(engineURI, "filter"));
        CommonJMXUtil.unregisterMbean(MetricNameFactory.name(engineURI, "schedule"));
        CommonJMXUtil.unregisterMbean(MetricNameFactory.name(engineURI, "runtime"));
    }

    private void loadAdapters(EPServicesContext services) {
        List<ConfigurationPluginLoader> pluginLoaders = this.configSnapshot.getPluginLoaders();
        if (pluginLoaders == null || pluginLoaders.size() == 0) {
            return;
        }
        for (ConfigurationPluginLoader config : pluginLoaders) {
            Object pluginLoaderObj;
            Class<?> pluginLoaderClass;
            String className = config.getClassName();
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                pluginLoaderClass = Class.forName(className, true, cl);
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException("Failed to load adapter loader class '" + className + "'", ex);
            }
            try {
                pluginLoaderObj = pluginLoaderClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw new ConfigurationException("Failed to instantiate adapter loader class '" + className + "' via default constructor", ex);
            }
            catch (IllegalAccessException ex) {
                throw new ConfigurationException("Illegal access to instantiate adapter loader class '" + className + "' via default constructor", ex);
            }
            if (!(pluginLoaderObj instanceof PluginLoader)) {
                throw new ConfigurationException("Failed to cast adapter loader class '" + className + "' to " + PluginLoader.class.getName());
            }
            PluginLoader pluginLoader = (PluginLoader)pluginLoaderObj;
            PluginLoaderInitContext context = new PluginLoaderInitContext(config.getLoaderName(), config.getConfigProperties(), config.getConfigurationXML(), this);
            pluginLoader.init(context);
            try {
                services.getEngineEnvContext().bind("plugin-loader/" + config.getLoaderName(), (Object)pluginLoader);
            }
            catch (NamingException e) {
                throw new EPException("Failed to use context to bind adapter loader", e);
            }
        }
    }

    private ConfigurationInformation takeSnapshot(Configuration configuration) {
        try {
            return (ConfigurationInformation)SerializableObjectCopier.copy(configuration);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to snapshot configuration instance through serialization : " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Failed to snapshot configuration instance through serialization : " + e.getMessage(), e);
        }
    }

    @Override
    public void addServiceStateListener(EPServiceStateListener listener) {
        this.serviceListeners.add(listener);
    }

    @Override
    public boolean removeServiceStateListener(EPServiceStateListener listener) {
        return this.serviceListeners.remove(listener);
    }

    @Override
    public void removeAllServiceStateListeners() {
        this.serviceListeners.clear();
    }

    @Override
    public synchronized void addStatementStateListener(EPStatementStateListener listener) {
        if (this.statementListeners.isEmpty()) {
            this.stmtEventDispatcher = new StatementEventDispatcherUnthreaded(this, this.statementListeners);
            this.getStatementLifecycleSvc().addObserver(this.stmtEventDispatcher);
        }
        this.statementListeners.add(listener);
    }

    @Override
    public synchronized boolean removeStatementStateListener(EPStatementStateListener listener) {
        boolean result = this.statementListeners.remove(listener);
        if (this.statementListeners.isEmpty()) {
            this.getStatementLifecycleSvc().removeObserver(this.stmtEventDispatcher);
            this.stmtEventDispatcher = null;
        }
        return result;
    }

    @Override
    public synchronized void removeAllStatementStateListeners() {
        this.statementListeners.clear();
        if (this.statementListeners.isEmpty()) {
            this.getStatementLifecycleSvc().removeObserver(this.stmtEventDispatcher);
            this.stmtEventDispatcher = null;
        }
    }

    @Override
    public String[] getEPServiceIsolatedNames() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getStatementIsolationService().getIsolationUnitNames();
    }

    @Override
    public SchedulingMgmtService getSchedulingMgmtService() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getSchedulingMgmtService();
    }

    @Override
    public EngineImportService getEngineImportService() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getEngineImportService();
    }

    @Override
    public TimeProvider getTimeProvider() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getSchedulingService();
    }

    @Override
    public VariableService getVariableService() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getVariableService();
    }

    @Override
    public ContextManagementService getContextManagementService() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getContextManagementService();
    }

    @Override
    public ReadWriteLock getEngineInstanceWideLock() {
        if (this.engine == null) {
            throw new EPServiceDestroyedException(this.engineURI);
        }
        return this.engine.getServices().getEventProcessingRWLock().getLock();
    }

    private static class EPServiceEngine {
        private EPServicesContext services;
        private EPRuntimeSPI runtimeSPI;
        private EPAdministratorSPI admin;

        public EPServiceEngine(EPServicesContext services, EPRuntimeSPI runtimeSPI, EPAdministratorSPI admin) {
            this.services = services;
            this.runtimeSPI = runtimeSPI;
            this.admin = admin;
        }

        public EPServicesContext getServices() {
            return this.services;
        }

        public EPRuntimeSPI getRuntime() {
            return this.runtimeSPI;
        }

        public EPAdministratorSPI getAdmin() {
            return this.admin;
        }
    }
}

