/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EPStatementState;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.SafeIterator;
import com.espertech.esper.client.StatementAwareUpdateListener;
import com.espertech.esper.client.UpdateListener;
import com.espertech.esper.client.context.ContextPartitionSelector;
import com.espertech.esper.collection.SafeIteratorImpl;
import com.espertech.esper.collection.SafeIteratorWTableImpl;
import com.espertech.esper.collection.UnsafeIteratorWTableImpl;
import com.espertech.esper.core.service.EPStatementListenerSet;
import com.espertech.esper.core.service.EPStatementSPI;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StatementLifecycleEvent;
import com.espertech.esper.core.service.StatementLifecycleSvc;
import com.espertech.esper.core.service.StatementMetadata;
import com.espertech.esper.core.service.UpdateDispatchViewBase;
import com.espertech.esper.core.service.UpdateDispatchViewBlockingSpin;
import com.espertech.esper.core.service.UpdateDispatchViewBlockingWait;
import com.espertech.esper.core.service.UpdateDispatchViewNonBlocking;
import com.espertech.esper.dispatch.DispatchService;
import com.espertech.esper.timer.TimeSourceService;
import com.espertech.esper.view.Viewable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPStatementImpl
implements EPStatementSPI {
    private static Log log = LogFactory.getLog(EPStatementImpl.class);
    private final EPStatementListenerSet statementListenerSet;
    private final String expressionNoAnnotations;
    private final boolean nameProvided;
    private boolean isPattern;
    private UpdateDispatchViewBase dispatchChildView;
    private StatementLifecycleSvc statementLifecycleSvc;
    private long timeLastStateChange;
    private Viewable parentView;
    private EPStatementState currentState;
    private EventType eventType;
    private StatementMetadata statementMetadata;
    private Object userObject;
    protected StatementContext statementContext;
    private String serviceIsolated;

    public EPStatementImpl(String expressionNoAnnotations, boolean isPattern, DispatchService dispatchService, StatementLifecycleSvc statementLifecycleSvc, long timeLastStateChange, boolean isBlockingDispatch, boolean isSpinBlockingDispatch, long msecBlockingTimeout, TimeSourceService timeSourceService, StatementMetadata statementMetadata, Object userObject, StatementContext statementContext, boolean isFailed, boolean nameProvided) {
        this.isPattern = isPattern;
        this.expressionNoAnnotations = expressionNoAnnotations;
        this.statementLifecycleSvc = statementLifecycleSvc;
        this.statementContext = statementContext;
        this.nameProvided = nameProvided;
        this.statementListenerSet = new EPStatementListenerSet();
        this.dispatchChildView = isBlockingDispatch ? (isSpinBlockingDispatch ? new UpdateDispatchViewBlockingSpin(statementContext.getStatementResultService(), dispatchService, msecBlockingTimeout, timeSourceService) : new UpdateDispatchViewBlockingWait(statementContext.getStatementResultService(), dispatchService, msecBlockingTimeout)) : new UpdateDispatchViewNonBlocking(statementContext.getStatementResultService(), dispatchService);
        this.currentState = !isFailed ? EPStatementState.STOPPED : EPStatementState.FAILED;
        this.timeLastStateChange = timeLastStateChange;
        this.statementMetadata = statementMetadata;
        this.userObject = userObject;
        statementContext.getStatementResultService().setUpdateListeners(this.statementListenerSet, false);
    }

    @Override
    public String getStatementId() {
        return this.statementContext.getStatementId();
    }

    @Override
    public void start() {
        if (this.statementLifecycleSvc == null) {
            throw new IllegalStateException("Cannot start statement, statement is in destroyed state");
        }
        this.statementLifecycleSvc.start(this.statementContext.getStatementId());
    }

    @Override
    public void stop() {
        if (this.statementLifecycleSvc == null) {
            throw new IllegalStateException("Cannot stop statement, statement is in destroyed state");
        }
        this.statementLifecycleSvc.stop(this.statementContext.getStatementId());
        this.statementContext.getStatementResultService().dispatchOnStop();
        this.dispatchChildView.clear();
    }

    @Override
    public void destroy() {
        if (this.currentState == EPStatementState.DESTROYED) {
            throw new IllegalStateException("Statement already destroyed");
        }
        this.statementLifecycleSvc.destroy(this.statementContext.getStatementId());
        this.parentView = null;
        this.eventType = null;
        this.dispatchChildView = null;
        this.statementLifecycleSvc = null;
    }

    @Override
    public EPStatementState getState() {
        return this.currentState;
    }

    @Override
    public void setCurrentState(EPStatementState currentState, long timeLastStateChange) {
        this.currentState = currentState;
        this.timeLastStateChange = timeLastStateChange;
    }

    @Override
    public Viewable getParentView() {
        return this.parentView;
    }

    @Override
    public void setParentView(Viewable viewable) {
        if (viewable == null) {
            if (this.parentView != null) {
                this.parentView.removeView(this.dispatchChildView);
            }
            this.parentView = null;
        } else {
            this.parentView = viewable;
            this.parentView.addView(this.dispatchChildView);
            this.eventType = this.parentView.getEventType();
        }
    }

    @Override
    public String getText() {
        return this.statementContext.getExpression();
    }

    @Override
    public String getName() {
        return this.statementContext.getStatementName();
    }

    @Override
    public Iterator<EventBean> iterator(ContextPartitionSelector selector) {
        if (this.statementContext.getContextDescriptor() == null) {
            throw this.getUnsupportedNonContextIterator();
        }
        if (selector == null) {
            throw new IllegalArgumentException("No selector provided");
        }
        this.statementContext.getVariableService().setLocalVersion();
        if (this.parentView == null) {
            return null;
        }
        return this.statementContext.getContextDescriptor().iterator(this.statementContext.getStatementId(), selector);
    }

    @Override
    public SafeIterator<EventBean> safeIterator(ContextPartitionSelector selector) {
        if (this.statementContext.getContextDescriptor() == null) {
            throw this.getUnsupportedNonContextIterator();
        }
        if (selector == null) {
            throw new IllegalArgumentException("No selector provided");
        }
        if (this.parentView == null) {
            return null;
        }
        this.statementContext.getVariableService().setLocalVersion();
        return this.statementContext.getContextDescriptor().safeIterator(this.statementContext.getStatementId(), selector);
    }

    @Override
    public Iterator<EventBean> iterator() {
        this.statementContext.getVariableService().setLocalVersion();
        if (this.parentView == null) {
            return null;
        }
        Iterator<EventBean> theIterator = this.statementContext.getContextDescriptor() != null ? this.statementContext.getContextDescriptor().iterator(this.statementContext.getStatementId()) : this.parentView.iterator();
        if (this.statementContext.getEpStatementHandle().isHasTableAccess()) {
            return new UnsafeIteratorWTableImpl<EventBean>(this.statementContext.getTableExprEvaluatorContext(), theIterator);
        }
        return theIterator;
    }

    @Override
    public SafeIterator<EventBean> safeIterator() {
        if (this.parentView == null) {
            return null;
        }
        if (this.statementContext.getContextDescriptor() != null) {
            this.statementContext.getVariableService().setLocalVersion();
            return this.statementContext.getContextDescriptor().safeIterator(this.statementContext.getStatementId());
        }
        this.statementContext.getDefaultAgentInstanceLock().acquireReadLock();
        try {
            this.statementContext.getVariableService().setLocalVersion();
            if (this.statementContext.getEpStatementHandle().isHasTableAccess()) {
                return new SafeIteratorWTableImpl<EventBean>(this.statementContext.getDefaultAgentInstanceLock(), this.parentView.iterator(), this.statementContext.getTableExprEvaluatorContext());
            }
            return new SafeIteratorImpl<EventBean>(this.statementContext.getDefaultAgentInstanceLock(), this.parentView.iterator());
        }
        catch (RuntimeException ex) {
            this.statementContext.getDefaultAgentInstanceLock().releaseReadLock();
            throw ex;
        }
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public EPStatementListenerSet getListenerSet() {
        return this.statementListenerSet;
    }

    @Override
    public void setListeners(EPStatementListenerSet listenerSet, boolean isRecovery) {
        this.statementListenerSet.setListeners(listenerSet);
        this.statementContext.getStatementResultService().setUpdateListeners(listenerSet, isRecovery);
    }

    @Override
    public void addListener(UpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        if (this.isDestroyed()) {
            throw new IllegalStateException("Statement is in destroyed state");
        }
        this.statementListenerSet.addListener(listener);
        this.statementContext.getStatementResultService().setUpdateListeners(this.statementListenerSet, false);
        this.statementLifecycleSvc.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(this, StatementLifecycleEvent.LifecycleEventType.LISTENER_ADD, listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListenerWithReplay(UpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        if (this.isDestroyed()) {
            throw new IllegalStateException("Statement is in destroyed state");
        }
        this.statementContext.getDefaultAgentInstanceLock().acquireReadLock();
        try {
            this.statementListenerSet.addListener(listener);
            this.statementContext.getStatementResultService().setUpdateListeners(this.statementListenerSet, false);
            this.statementLifecycleSvc.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(this, StatementLifecycleEvent.LifecycleEventType.LISTENER_ADD, listener));
            Iterator<EventBean> it = this.iterator();
            if (it == null) {
                try {
                    listener.update(null, null);
                }
                catch (Throwable t) {
                    String message = "Unexpected exception invoking listener update method for replay on listener class '" + listener.getClass().getSimpleName() + "' : " + t.getClass().getSimpleName() + " : " + t.getMessage();
                    log.error((Object)message, t);
                }
                return;
            }
            ArrayList<EventBean> events = new ArrayList<EventBean>();
            while (it.hasNext()) {
                events.add(it.next());
            }
            if (events.isEmpty()) {
                try {
                    listener.update(null, null);
                }
                catch (Throwable t) {
                    String message = "Unexpected exception invoking listener update method for replay on listener class '" + listener.getClass().getSimpleName() + "' : " + t.getClass().getSimpleName() + " : " + t.getMessage();
                    log.error((Object)message, t);
                }
            } else {
                EventBean[] iteratorResult = events.toArray(new EventBean[events.size()]);
                try {
                    listener.update(iteratorResult, null);
                }
                catch (Throwable t) {
                    String message = "Unexpected exception invoking listener update method for replay on listener class '" + listener.getClass().getSimpleName() + "' : " + t.getClass().getSimpleName() + " : " + t.getMessage();
                    log.error((Object)message, t);
                }
            }
        }
        finally {
            if (this.statementContext.getEpStatementHandle().isHasTableAccess()) {
                this.statementContext.getTableExprEvaluatorContext().releaseAcquiredLocks();
            }
            this.statementContext.getDefaultAgentInstanceLock().releaseReadLock();
        }
    }

    @Override
    public void removeListener(UpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        this.statementListenerSet.removeListener(listener);
        this.statementContext.getStatementResultService().setUpdateListeners(this.statementListenerSet, false);
        if (this.statementLifecycleSvc != null) {
            this.statementLifecycleSvc.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(this, StatementLifecycleEvent.LifecycleEventType.LISTENER_REMOVE, listener));
        }
    }

    @Override
    public void removeAllListeners() {
        this.statementListenerSet.removeAllListeners();
        this.statementContext.getStatementResultService().setUpdateListeners(this.statementListenerSet, false);
        if (this.statementLifecycleSvc != null) {
            this.statementLifecycleSvc.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(this, StatementLifecycleEvent.LifecycleEventType.LISTENER_REMOVE_ALL, new Object[0]));
        }
    }

    @Override
    public void addListener(StatementAwareUpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        if (this.isDestroyed()) {
            throw new IllegalStateException("Statement is in destroyed state");
        }
        this.statementListenerSet.addListener(listener);
        this.statementContext.getStatementResultService().setUpdateListeners(this.statementListenerSet, false);
        this.statementLifecycleSvc.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(this, StatementLifecycleEvent.LifecycleEventType.LISTENER_ADD, listener));
    }

    @Override
    public void removeListener(StatementAwareUpdateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener reference supplied");
        }
        this.statementListenerSet.removeListener(listener);
        this.statementContext.getStatementResultService().setUpdateListeners(this.statementListenerSet, false);
        if (this.statementLifecycleSvc != null) {
            this.statementLifecycleSvc.dispatchStatementLifecycleEvent(new StatementLifecycleEvent(this, StatementLifecycleEvent.LifecycleEventType.LISTENER_REMOVE, listener));
        }
    }

    @Override
    public Iterator<StatementAwareUpdateListener> getStatementAwareListeners() {
        return Arrays.asList(this.statementListenerSet.getStmtAwareListeners()).iterator();
    }

    @Override
    public Iterator<UpdateListener> getUpdateListeners() {
        return Arrays.asList(this.statementListenerSet.getListeners()).iterator();
    }

    @Override
    public long getTimeLastStateChange() {
        return this.timeLastStateChange;
    }

    @Override
    public boolean isStarted() {
        return this.currentState == EPStatementState.STARTED;
    }

    @Override
    public boolean isStopped() {
        return this.currentState == EPStatementState.STOPPED;
    }

    @Override
    public boolean isDestroyed() {
        return this.currentState == EPStatementState.DESTROYED;
    }

    @Override
    public void setSubscriber(Object subscriber) {
        this.setSubscriber(subscriber, null);
    }

    @Override
    public void setSubscriber(Object subscriber, String methodName) {
        this.statementListenerSet.setSubscriber(subscriber, methodName);
        this.statementContext.getStatementResultService().setUpdateListeners(this.statementListenerSet, false);
    }

    @Override
    public Object getSubscriber() {
        return this.statementListenerSet.getSubscriber();
    }

    @Override
    public boolean isPattern() {
        return this.isPattern;
    }

    @Override
    public StatementMetadata getStatementMetadata() {
        return this.statementMetadata;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.statementContext.getAnnotations();
    }

    @Override
    public StatementContext getStatementContext() {
        return this.statementContext;
    }

    @Override
    public String getExpressionNoAnnotations() {
        return this.expressionNoAnnotations;
    }

    @Override
    public String getServiceIsolated() {
        return this.serviceIsolated;
    }

    @Override
    public void setServiceIsolated(String serviceIsolated) {
        this.serviceIsolated = serviceIsolated;
    }

    @Override
    public boolean isNameProvided() {
        return this.nameProvided;
    }

    public UpdateDispatchViewBase getDispatchChildView() {
        return this.dispatchChildView;
    }

    private UnsupportedOperationException getUnsupportedNonContextIterator() {
        return new UnsupportedOperationException("Iterator with context selector is only supported for statements under context");
    }
}

