/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPSubscriberException;
import com.espertech.esper.core.service.DeliveryConvertor;
import com.espertech.esper.core.service.DeliveryConvertorMap;
import com.espertech.esper.core.service.DeliveryConvertorNull;
import com.espertech.esper.core.service.DeliveryConvertorObjectArr;
import com.espertech.esper.core.service.DeliveryConvertorWidener;
import com.espertech.esper.core.service.ResultDeliveryStrategy;
import com.espertech.esper.core.service.ResultDeliveryStrategyImpl;
import com.espertech.esper.core.service.ResultDeliveryStrategyMap;
import com.espertech.esper.core.service.ResultDeliveryStrategyObjectArr;
import com.espertech.esper.core.service.ResultDeliveryStrategyTypeArr;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.TypeWidener;
import com.espertech.esper.util.TypeWidenerFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;

public class ResultDeliveryStrategyFactory {
    public static ResultDeliveryStrategy create(String statementName, Object subscriber, String methodName, Class[] selectClauseTypes, String[] selectClauseColumns) throws EPSubscriberException {
        int i;
        boolean fits;
        Class<?>[] parameters;
        if (selectClauseTypes == null) {
            selectClauseTypes = new Class[]{};
            selectClauseColumns = new String[]{};
        }
        if (methodName == null) {
            methodName = "update";
        }
        Method subscriptionMethod = null;
        ArrayList<Method> updateMethods = new ArrayList<Method>();
        for (Method method : subscriber.getClass().getMethods()) {
            if (!method.getName().equals(methodName) || !Modifier.isPublic(method.getModifiers())) continue;
            updateMethods.add(method);
        }
        if (updateMethods.size() == 0) {
            String message = "Subscriber object does not provide a public method by name 'update'";
            throw new EPSubscriberException(message);
        }
        boolean isMapArrayDelivery = false;
        boolean isObjectArrayDelivery = false;
        boolean isSingleRowMap = false;
        boolean isSingleRowObjectArr = false;
        boolean isTypeArrayDelivery = false;
        for (Method method : updateMethods) {
            parameters = method.getParameterTypes();
            if (parameters.length != selectClauseTypes.length) continue;
            fits = true;
            for (i = 0; i < parameters.length; ++i) {
                if (selectClauseTypes[i] == null || selectClauseTypes[i] == parameters[i]) continue;
                fits = false;
                break;
            }
            if (!fits) continue;
            subscriptionMethod = method;
            break;
        }
        if (subscriptionMethod == null) {
            for (Method method : updateMethods) {
                parameters = method.getParameterTypes();
                if (parameters.length != selectClauseTypes.length) continue;
                fits = true;
                for (i = 0; i < parameters.length; ++i) {
                    Class boxedExpressionType = JavaClassHelper.getBoxedType(selectClauseTypes[i]);
                    Class boxedParameterType = JavaClassHelper.getBoxedType(parameters[i]);
                    if (boxedExpressionType == null || boxedExpressionType == boxedParameterType) continue;
                    fits = false;
                    break;
                }
                if (!fits) continue;
                subscriptionMethod = method;
                break;
            }
        }
        boolean checkWidening = false;
        if (subscriptionMethod == null) {
            for (Method method : updateMethods) {
                Class<?>[] parameters2 = method.getParameterTypes();
                if (parameters2.length != selectClauseTypes.length) continue;
                boolean fits2 = true;
                for (int i2 = 0; i2 < parameters2.length; ++i2) {
                    Class boxedExpressionType = JavaClassHelper.getBoxedType(selectClauseTypes[i2]);
                    Class boxedParameterType = JavaClassHelper.getBoxedType(parameters2[i2]);
                    if (boxedExpressionType == null || JavaClassHelper.isAssignmentCompatible(boxedExpressionType, boxedParameterType)) continue;
                    fits2 = false;
                    break;
                }
                if (!fits2) continue;
                subscriptionMethod = method;
                checkWidening = true;
                break;
            }
        }
        if (subscriptionMethod == null) {
            for (Method method : updateMethods) {
                Class<?> componentType;
                Class<?>[] parameters3 = method.getParameterTypes();
                if (parameters3.length == 1 && parameters3[0] == Map.class) {
                    isSingleRowMap = true;
                    subscriptionMethod = method;
                    break;
                }
                if (parameters3.length == 1 && parameters3[0] == Object[].class) {
                    isSingleRowObjectArr = true;
                    subscriptionMethod = method;
                    break;
                }
                if (parameters3.length == 2 && parameters3[0] == Map[].class && parameters3[1] == Map[].class) {
                    subscriptionMethod = method;
                    isMapArrayDelivery = true;
                    break;
                }
                if (parameters3.length == 2 && parameters3[0] == Object[][].class && parameters3[1] == Object[][].class) {
                    subscriptionMethod = method;
                    isObjectArrayDelivery = true;
                    break;
                }
                if (parameters3.length == 2 && parameters3[0].equals(parameters3[1]) && parameters3[0].isArray() && selectClauseTypes.length == 1 && JavaClassHelper.isAssignmentCompatible(selectClauseTypes[0], componentType = parameters3[0].getComponentType())) {
                    subscriptionMethod = method;
                    isTypeArrayDelivery = true;
                    break;
                }
                if (parameters3.length != 0 || selectClauseTypes.length != 1 || selectClauseTypes[0] != null) continue;
                subscriptionMethod = method;
            }
        }
        if (subscriptionMethod == null) {
            if (updateMethods.size() > 1) {
                String parametersDesc = JavaClassHelper.getParameterAsString(selectClauseTypes);
                String message = "No suitable subscriber method named 'update' found, expecting a method that takes " + selectClauseTypes.length + " parameter of type " + parametersDesc;
                throw new EPSubscriberException(message);
            }
            Class<?>[] parameters4 = ((Method)updateMethods.get(0)).getParameterTypes();
            String parametersDesc = JavaClassHelper.getParameterAsString(selectClauseTypes);
            if (parameters4.length != selectClauseTypes.length) {
                if (selectClauseTypes.length > 0) {
                    String message = "No suitable subscriber method named 'update' found, expecting a method that takes " + selectClauseTypes.length + " parameter of type " + parametersDesc;
                    throw new EPSubscriberException(message);
                }
                String message = "No suitable subscriber method named 'update' found, expecting a method that takes no parameters";
                throw new EPSubscriberException(message);
            }
            for (int i3 = 0; i3 < parameters4.length; ++i3) {
                Class boxedExpressionType = JavaClassHelper.getBoxedType(selectClauseTypes[i3]);
                Class boxedParameterType = JavaClassHelper.getBoxedType(parameters4[i3]);
                if (boxedExpressionType == null || JavaClassHelper.isAssignmentCompatible(boxedExpressionType, boxedParameterType)) continue;
                String message = "Subscriber method named 'update' for parameter number " + (i3 + 1) + " is not assignable, " + "expecting type '" + JavaClassHelper.getParameterAsString(selectClauseTypes[i3]) + "' but found type '" + JavaClassHelper.getParameterAsString(parameters4[i3]) + "'";
                throw new EPSubscriberException(message);
            }
        }
        if (isMapArrayDelivery) {
            return new ResultDeliveryStrategyMap(statementName, subscriber, subscriptionMethod, selectClauseColumns);
        }
        if (isObjectArrayDelivery) {
            return new ResultDeliveryStrategyObjectArr(statementName, subscriber, subscriptionMethod);
        }
        if (isTypeArrayDelivery) {
            return new ResultDeliveryStrategyTypeArr(statementName, subscriber, subscriptionMethod);
        }
        Method startMethod = null;
        Method endMethod = null;
        Method rStreamMethod = null;
        try {
            startMethod = subscriber.getClass().getMethod("updateStart", Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            endMethod = subscriber.getClass().getMethod("updateEnd", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            rStreamMethod = subscriber.getClass().getMethod("updateRStream", subscriptionMethod.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        DeliveryConvertor convertor = isSingleRowMap ? new DeliveryConvertorMap(selectClauseColumns) : (isSingleRowObjectArr ? new DeliveryConvertorObjectArr() : (checkWidening ? ResultDeliveryStrategyFactory.determineWideningDeliveryConvertor(selectClauseTypes, subscriptionMethod.getParameterTypes(), subscriptionMethod) : DeliveryConvertorNull.INSTANCE));
        return new ResultDeliveryStrategyImpl(statementName, subscriber, convertor, subscriptionMethod, startMethod, endMethod, rStreamMethod);
    }

    private static DeliveryConvertor determineWideningDeliveryConvertor(Class[] selectClauseTypes, Class[] parameterTypes, Method method) {
        boolean needWidener = false;
        for (int i = 0; i < selectClauseTypes.length; ++i) {
            TypeWidener optionalWidener = ResultDeliveryStrategyFactory.getWidener(i, selectClauseTypes[i], parameterTypes[i], method);
            if (optionalWidener == null) continue;
            needWidener = true;
            break;
        }
        if (!needWidener) {
            return DeliveryConvertorNull.INSTANCE;
        }
        TypeWidener[] wideners = new TypeWidener[selectClauseTypes.length];
        for (int i = 0; i < selectClauseTypes.length; ++i) {
            wideners[i] = ResultDeliveryStrategyFactory.getWidener(i, selectClauseTypes[i], parameterTypes[i], method);
        }
        return new DeliveryConvertorWidener(wideners);
    }

    private static TypeWidener getWidener(int columnNum, Class selectClauseType, Class parameterType, Method method) {
        if (selectClauseType == null || parameterType == null) {
            return null;
        }
        if (selectClauseType == parameterType) {
            return null;
        }
        try {
            return TypeWidenerFactory.getCheckPropertyAssignType("Select-Clause Column " + columnNum, selectClauseType, parameterType, "Method Parameter " + columnNum);
        }
        catch (ExprValidationException e) {
            throw new EPException("Unexpected exception assigning select clause columns to subscriber method " + method + ": " + e.getMessage(), e);
        }
    }
}

