/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.service.DeliveryConvertor;
import com.espertech.esper.core.service.ResultDeliveryStrategy;
import com.espertech.esper.event.NaturalEventBean;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultDeliveryStrategyImpl
implements ResultDeliveryStrategy {
    private static Log log = LogFactory.getLog(ResultDeliveryStrategyImpl.class);
    private final String statementName;
    private final Object subscriber;
    private final FastMethod updateFastMethod;
    private final FastMethod startFastMethod;
    private final FastMethod endFastMethod;
    private final FastMethod updateRStreamFastMethod;
    private final DeliveryConvertor deliveryConvertor;

    public ResultDeliveryStrategyImpl(String statementName, Object subscriber, DeliveryConvertor deliveryConvertor, Method method, Method startMethod, Method endMethod, Method rStreamMethod) {
        this.statementName = statementName;
        this.subscriber = subscriber;
        this.deliveryConvertor = deliveryConvertor;
        FastClass fastClass = FastClass.create((ClassLoader)Thread.currentThread().getContextClassLoader(), subscriber.getClass());
        this.updateFastMethod = fastClass.getMethod(method);
        this.startFastMethod = startMethod != null ? fastClass.getMethod(startMethod) : null;
        this.endFastMethod = endMethod != null ? fastClass.getMethod(endMethod) : null;
        this.updateRStreamFastMethod = rStreamMethod != null ? fastClass.getMethod(rStreamMethod) : null;
    }

    @Override
    public void execute(UniformPair<EventBean[]> result) {
        Object[] parameters;
        NaturalEventBean natural;
        EventBean theEvent;
        if (this.startFastMethod != null) {
            int countNew = 0;
            int countOld = 0;
            if (result != null) {
                countNew = this.count(result.getFirst());
                countOld = this.count(result.getSecond());
            }
            Object[] parameters2 = new Object[]{countNew, countOld};
            try {
                this.startFastMethod.invoke(this.subscriber, parameters2);
            }
            catch (InvocationTargetException e) {
                ResultDeliveryStrategyImpl.handle(this.statementName, log, e, parameters2, this.subscriber, this.startFastMethod);
            }
            catch (Throwable t) {
                ResultDeliveryStrategyImpl.handleThrowable(log, t, null, this.subscriber, this.startFastMethod);
            }
        }
        EventBean[] newData = null;
        EventBean[] oldData = null;
        if (result != null) {
            newData = result.getFirst();
            oldData = result.getSecond();
        }
        if (newData != null && newData.length > 0) {
            for (int i = 0; i < newData.length; ++i) {
                theEvent = newData[i];
                if (!(theEvent instanceof NaturalEventBean)) continue;
                natural = (NaturalEventBean)theEvent;
                parameters = this.deliveryConvertor.convertRow(natural.getNatural());
                try {
                    this.updateFastMethod.invoke(this.subscriber, parameters);
                    continue;
                }
                catch (InvocationTargetException e) {
                    ResultDeliveryStrategyImpl.handle(this.statementName, log, e, parameters, this.subscriber, this.updateFastMethod);
                    continue;
                }
                catch (Throwable t) {
                    ResultDeliveryStrategyImpl.handleThrowable(log, t, parameters, this.subscriber, this.updateFastMethod);
                }
            }
        }
        if (this.updateRStreamFastMethod != null && oldData != null && oldData.length > 0) {
            for (int i = 0; i < oldData.length; ++i) {
                theEvent = oldData[i];
                if (!(theEvent instanceof NaturalEventBean)) continue;
                natural = (NaturalEventBean)theEvent;
                parameters = this.deliveryConvertor.convertRow(natural.getNatural());
                try {
                    this.updateRStreamFastMethod.invoke(this.subscriber, parameters);
                    continue;
                }
                catch (InvocationTargetException e) {
                    ResultDeliveryStrategyImpl.handle(this.statementName, log, e, parameters, this.subscriber, this.updateRStreamFastMethod);
                    continue;
                }
                catch (Throwable t) {
                    ResultDeliveryStrategyImpl.handleThrowable(log, t, parameters, this.subscriber, this.updateRStreamFastMethod);
                }
            }
        }
        if (this.endFastMethod != null) {
            try {
                this.endFastMethod.invoke(this.subscriber, null);
            }
            catch (InvocationTargetException e) {
                ResultDeliveryStrategyImpl.handle(this.statementName, log, e, null, this.subscriber, this.endFastMethod);
            }
            catch (Throwable t) {
                ResultDeliveryStrategyImpl.handleThrowable(log, t, null, this.subscriber, this.endFastMethod);
            }
        }
    }

    protected static void handle(String statementName, Log logger, InvocationTargetException e, Object[] parameters, Object subscriber, FastMethod method) {
        String message = JavaClassHelper.getMessageInvocationTarget(statementName, method.getJavaMethod(), subscriber.getClass().getName(), parameters, e);
        logger.error((Object)message, e.getTargetException());
    }

    protected static void handleThrowable(Log logger, Throwable t, Object[] parameters, Object subscriber, FastMethod method) {
        String message = "Unexpected exception when invoking method '" + method.getName() + "' on subscriber class '" + subscriber.getClass().getSimpleName() + "' for parameters " + (parameters == null ? "null" : Arrays.toString(parameters)) + " : " + t.getClass().getSimpleName() + " : " + t.getMessage();
        logger.error((Object)message, t);
    }

    private int count(EventBean[] events) {
        if (events == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < events.length; ++i) {
            EventBean theEvent = events[i];
            if (!(theEvent instanceof NaturalEventBean)) continue;
            ++count;
        }
        return count;
    }
}

