/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryCreateIndex;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryCreateIndexResult;
import com.espertech.esper.core.context.mgr.ContextManagedStatementCreateIndexDesc;
import com.espertech.esper.core.context.mgr.ContextManagementService;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextMergeView;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementDestroyCallbackList;
import com.espertech.esper.core.start.EPStatementStartMethodBase;
import com.espertech.esper.core.start.EPStatementStartResult;
import com.espertech.esper.core.start.EPStatementStopMethod;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.lookup.EventTableCreateIndexDesc;
import com.espertech.esper.epl.lookup.EventTableIndexUtil;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.spec.CreateIndexDesc;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.util.EPLValidationUtil;
import com.espertech.esper.util.DestroyCallback;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.ViewableDefaultImpl;

public class EPStatementStartMethodCreateIndex
extends EPStatementStartMethodBase {
    public EPStatementStartMethodCreateIndex(StatementSpecCompiled statementSpec) {
        super(statementSpec);
    }

    @Override
    public EPStatementStartResult startInternal(EPServicesContext services, final StatementContext statementContext, boolean isNewStatement, boolean isRecoveringStatement, boolean isRecoveringResilient) throws ExprValidationException, ViewProcessingException {
        EPStatementStopMethod stopMethod;
        CreateIndexDesc spec = this.statementSpec.getCreateIndexDesc();
        final NamedWindowProcessor namedWindowProcessor = services.getNamedWindowService().getProcessor(spec.getWindowName());
        final TableMetadata tableMetadata = services.getTableService().getTableMetadata(spec.getWindowName());
        if (namedWindowProcessor == null && tableMetadata == null) {
            throw new ExprValidationException("A named window or table by name '" + spec.getWindowName() + "' does not exist");
        }
        EventType indexedEventType = namedWindowProcessor != null ? namedWindowProcessor.getNamedWindowType() : tableMetadata.getInternalEventType();
        String infraContextName = namedWindowProcessor != null ? namedWindowProcessor.getContextName() : tableMetadata.getContextName();
        EPLValidationUtil.validateContextName(namedWindowProcessor == null, spec.getWindowName(), infraContextName, this.statementSpec.getOptionalContextName(), true);
        EventTableCreateIndexDesc validated = EventTableIndexUtil.validateCompileExplicitIndex(spec.isUnique(), spec.getColumns(), indexedEventType);
        final IndexMultiKey imk = new IndexMultiKey(spec.isUnique(), validated.getHashProps(), validated.getBtreeProps());
        if (tableMetadata != null) {
            services.getTableService().validateAddIndex(statementContext.getStatementName(), tableMetadata, spec.getIndexName(), imk);
        } else {
            namedWindowProcessor.validateAddIndex(statementContext.getStatementName(), spec.getIndexName(), imk);
        }
        ViewableDefaultImpl viewable = new ViewableDefaultImpl(indexedEventType);
        StatementAgentInstanceFactoryCreateIndex contextFactory = new StatementAgentInstanceFactoryCreateIndex(services, spec, viewable, namedWindowProcessor, tableMetadata == null ? null : tableMetadata.getTableName());
        final TableService finalTableService = services.getTableService();
        final String finalStatementName = statementContext.getStatementName();
        EPStatementDestroyCallbackList destroyMethod = new EPStatementDestroyCallbackList();
        if (tableMetadata != null) {
            destroyMethod.addCallback(new DestroyCallback(){

                @Override
                public void destroy() {
                    finalTableService.removeIndexReferencesStmtMayRemoveIndex(finalStatementName, tableMetadata);
                }
            });
        } else {
            destroyMethod.addCallback(new DestroyCallback(){

                @Override
                public void destroy() {
                    namedWindowProcessor.removeIndexReferencesStmtMayRemoveIndex(imk, finalStatementName);
                }
            });
        }
        if (this.statementSpec.getOptionalContextName() != null) {
            ContextMergeView mergeView = new ContextMergeView(indexedEventType);
            ContextManagedStatementCreateIndexDesc statement = new ContextManagedStatementCreateIndexDesc(this.statementSpec, statementContext, mergeView, contextFactory);
            services.getContextManagementService().addStatement(this.statementSpec.getOptionalContextName(), statement, isRecoveringResilient);
            stopMethod = new EPStatementStopMethod(){

                @Override
                public void stop() {
                }
            };
            final ContextManagementService contextManagementService = services.getContextManagementService();
            destroyMethod.addCallback(new DestroyCallback(){

                @Override
                public void destroy() {
                    contextManagementService.destroyedStatement(EPStatementStartMethodCreateIndex.this.statementSpec.getOptionalContextName(), statementContext.getStatementName(), statementContext.getStatementId());
                }
            });
        } else {
            StatementAgentInstanceFactoryCreateIndexResult result;
            AgentInstanceContext defaultAgentInstanceContext = this.getDefaultAgentInstanceContext(statementContext);
            try {
                result = contextFactory.newContext(defaultAgentInstanceContext, false);
            }
            catch (EPException ex) {
                if (ex.getCause() instanceof ExprValidationException) {
                    throw (ExprValidationException)ex.getCause();
                }
                throw ex;
            }
            final StopCallback stopCallback = result.getStopCallback();
            stopMethod = new EPStatementStopMethod(){

                @Override
                public void stop() {
                    stopCallback.stop();
                }
            };
        }
        return new EPStatementStartResult(viewable, stopMethod, destroyMethod);
    }
}

