/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.core.context.factory.StatementAgentInstanceFactorySelectResult;
import com.espertech.esper.core.context.factory.StatementAgentInstancePreload;
import com.espertech.esper.core.context.mgr.ContextManagedStatementSelectDesc;
import com.espertech.esper.core.context.stmt.AIRegistryAggregation;
import com.espertech.esper.core.context.stmt.AIRegistryExpr;
import com.espertech.esper.core.context.stmt.AIRegistryPrevious;
import com.espertech.esper.core.context.stmt.AIRegistryPrior;
import com.espertech.esper.core.context.stmt.AIRegistryTableAccess;
import com.espertech.esper.core.context.subselect.SubSelectStrategyFactoryDesc;
import com.espertech.esper.core.context.subselect.SubSelectStrategyHolder;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextMergeView;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.resource.StatementResourceHolder;
import com.espertech.esper.core.start.EPStatementDestroyCallbackContext;
import com.espertech.esper.core.start.EPStatementStartMethodBase;
import com.espertech.esper.core.start.EPStatementStartMethodHelperAssignExpr;
import com.espertech.esper.core.start.EPStatementStartMethodSelectDesc;
import com.espertech.esper.core.start.EPStatementStartMethodSelectUtil;
import com.espertech.esper.core.start.EPStatementStartResult;
import com.espertech.esper.core.start.EPStatementStopMethod;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.prev.ExprPreviousEvalStrategy;
import com.espertech.esper.epl.expression.prev.ExprPreviousMatchRecognizeNode;
import com.espertech.esper.epl.expression.prev.ExprPreviousNode;
import com.espertech.esper.epl.expression.prior.ExprPriorEvalStrategy;
import com.espertech.esper.epl.expression.prior.ExprPriorNode;
import com.espertech.esper.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.epl.expression.subquery.ExprSubselectStrategy;
import com.espertech.esper.epl.expression.table.ExprTableAccessEvalStrategy;
import com.espertech.esper.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.epl.spec.IntoTableSpec;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.rowregex.EventRowRegexHelper;
import com.espertech.esper.rowregex.EventRowRegexNFAViewService;
import com.espertech.esper.rowregex.RegexExprPreviousEvalStrategy;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.Viewable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EPStatementStartMethodSelect
extends EPStatementStartMethodBase {
    public EPStatementStartMethodSelect(StatementSpecCompiled statementSpec) {
        super(statementSpec);
    }

    @Override
    public EPStatementStartResult startInternal(final EPServicesContext services, final StatementContext statementContext, boolean isNewStatement, boolean isRecoveringStatement, boolean isRecoveringResilient) throws ExprValidationException, ViewProcessingException {
        EPStatementStopMethod stopStatementMethod;
        Viewable finalViewable;
        Map<ExprTableAccessNode, ExprTableAccessEvalStrategy> tableAccessStrategyInstances;
        RegexExprPreviousEvalStrategy matchRecognizePrevEvalStrategy;
        Map<ExprPreviousNode, ExprPreviousEvalStrategy> previousStrategyInstances;
        Map<Object, Object> priorStrategyInstances;
        HashMap<ExprSubselectNode, SubSelectStrategyHolder> subselectStrategyInstances;
        AggregationService aggregationService;
        this.validateTableAccessUse(this.statementSpec.getIntoTableSpec(), this.statementSpec.getTableNodes());
        final String contextName = this.statementSpec.getOptionalContextName();
        AgentInstanceContext defaultAgentInstanceContext = this.getDefaultAgentInstanceContext(statementContext);
        EPStatementStartMethodSelectDesc selectDesc = EPStatementStartMethodSelectUtil.prepare(this.statementSpec, services, statementContext, isRecoveringResilient, defaultAgentInstanceContext, this.isQueryPlanLogging(services), null, null, null);
        statementContext.setStatementAgentInstanceFactory(selectDesc.getStatementAgentInstanceFactorySelect());
        statementContext.getStatementExtensionServicesContext().preStartWalk(selectDesc);
        List<Object> preloadList = Collections.emptyList();
        if (this.statementSpec.getOptionalContextName() != null) {
            Object specificService;
            aggregationService = statementContext.getStatementAgentInstanceRegistry().getAgentInstanceAggregationService();
            AIRegistryExpr aiRegistryExpr = statementContext.getStatementAgentInstanceRegistry().getAgentInstanceExprService();
            subselectStrategyInstances = new HashMap();
            for (Map.Entry<ExprSubselectNode, SubSelectStrategyFactoryDesc> entry : selectDesc.getSubSelectStrategyCollection().getSubqueries().entrySet()) {
                specificService = aiRegistryExpr.allocateSubselect(entry.getKey());
                entry.getKey().setStrategy((ExprSubselectStrategy)specificService);
                HashMap<ExprPriorNode, ExprPriorEvalStrategy> subselectPriorStrategies = new HashMap<ExprPriorNode, ExprPriorEvalStrategy>();
                for (ExprPriorNode subselectPrior : entry.getValue().getPriorNodesList()) {
                    AIRegistryPrior specificSubselectPriorService = aiRegistryExpr.allocatePrior(subselectPrior);
                    subselectPriorStrategies.put(subselectPrior, specificSubselectPriorService);
                }
                HashMap<ExprPreviousNode, ExprPreviousEvalStrategy> subselectPreviousStrategies = new HashMap<ExprPreviousNode, ExprPreviousEvalStrategy>();
                for (ExprPreviousNode subselectPrevious : entry.getValue().getPrevNodesList()) {
                    AIRegistryPrevious specificSubselectPreviousService = aiRegistryExpr.allocatePrevious(subselectPrevious);
                    subselectPreviousStrategies.put(subselectPrevious, specificSubselectPreviousService);
                }
                AIRegistryAggregation subselectAggregation = aiRegistryExpr.allocateSubselectAggregation(entry.getKey());
                SubSelectStrategyHolder strategyHolder = new SubSelectStrategyHolder((ExprSubselectStrategy)specificService, subselectAggregation, subselectPriorStrategies, subselectPreviousStrategies, null, null);
                subselectStrategyInstances.put(entry.getKey(), strategyHolder);
            }
            priorStrategyInstances = new HashMap();
            for (ExprPriorNode exprPriorNode : selectDesc.getViewResourceDelegateUnverified().getPriorRequests()) {
                specificService = aiRegistryExpr.allocatePrior(exprPriorNode);
                priorStrategyInstances.put(exprPriorNode, specificService);
            }
            previousStrategyInstances = new HashMap<ExprPreviousNode, ExprPreviousEvalStrategy>();
            for (ExprPreviousNode exprPreviousNode : selectDesc.getViewResourceDelegateUnverified().getPreviousRequests()) {
                specificService = aiRegistryExpr.allocatePrevious(exprPreviousNode);
                previousStrategyInstances.put(exprPreviousNode, (ExprPreviousEvalStrategy)specificService);
            }
            matchRecognizePrevEvalStrategy = aiRegistryExpr.allocateMatchRecognizePrevious();
            tableAccessStrategyInstances = new HashMap<ExprTableAccessNode, ExprTableAccessEvalStrategy>();
            if (this.statementSpec.getTableNodes() != null) {
                for (ExprTableAccessNode tableNode : this.statementSpec.getTableNodes()) {
                    AIRegistryTableAccess specificService2 = aiRegistryExpr.allocateTableAccess(tableNode);
                    tableAccessStrategyInstances.put(tableNode, specificService2);
                }
            }
            ContextMergeView mergeView = new ContextMergeView(selectDesc.getResultSetProcessorPrototypeDesc().getResultSetProcessorFactory().getResultEventType());
            finalViewable = mergeView;
            ContextManagedStatementSelectDesc contextManagedStatementSelectDesc = new ContextManagedStatementSelectDesc(this.statementSpec, statementContext, mergeView, selectDesc.getStatementAgentInstanceFactorySelect(), selectDesc.getResultSetProcessorPrototypeDesc().getAggregationServiceFactoryDesc().getExpressions(), selectDesc.getSubSelectStrategyCollection());
            services.getContextManagementService().addStatement(contextName, contextManagedStatementSelectDesc, isRecoveringResilient);
            final EPStatementStopMethod selectStop = selectDesc.getStopMethod();
            stopStatementMethod = new EPStatementStopMethod(){

                @Override
                public void stop() {
                    services.getContextManagementService().stoppedStatement(contextName, statementContext.getStatementName(), statementContext.getStatementId());
                    selectStop.stop();
                }
            };
            selectDesc.getDestroyCallbacks().addCallback(new EPStatementDestroyCallbackContext(services.getContextManagementService(), contextName, statementContext.getStatementName(), statementContext.getStatementId()));
        } else {
            EventRowRegexNFAViewService matchRecognize;
            StatementAgentInstanceFactorySelectResult resultOfStart = (StatementAgentInstanceFactorySelectResult)selectDesc.getStatementAgentInstanceFactorySelect().newContext(defaultAgentInstanceContext, isRecoveringResilient);
            finalViewable = resultOfStart.getFinalView();
            final EPStatementStopMethod selectStop = selectDesc.getStopMethod();
            final StopCallback stopCallback = resultOfStart.getStopCallback();
            stopStatementMethod = new EPStatementStopMethod(){

                @Override
                public void stop() {
                    StatementAgentInstanceUtil.stopSafe(stopCallback, statementContext);
                    selectStop.stop();
                }
            };
            aggregationService = resultOfStart.getOptionalAggegationService();
            subselectStrategyInstances = resultOfStart.getSubselectStrategies();
            priorStrategyInstances = resultOfStart.getPriorNodeStrategies();
            previousStrategyInstances = resultOfStart.getPreviousNodeStrategies();
            tableAccessStrategyInstances = resultOfStart.getTableAccessEvalStrategies();
            preloadList = resultOfStart.getPreloadList();
            matchRecognizePrevEvalStrategy = null;
            if (resultOfStart.getTopViews().length > 0 && (matchRecognize = EventRowRegexHelper.recursiveFindRegexService(resultOfStart.getTopViews()[0])) != null) {
                matchRecognizePrevEvalStrategy = matchRecognize.getPreviousEvaluationStrategy();
            }
            if (statementContext.getStatementExtensionServicesContext() != null && statementContext.getStatementExtensionServicesContext().getStmtResources() != null) {
                StatementResourceHolder holder = statementContext.getStatementExtensionServicesContext().extractStatementResourceHolder(resultOfStart);
                statementContext.getStatementExtensionServicesContext().getStmtResources().setUnpartitioned(holder);
                statementContext.getStatementExtensionServicesContext().postProcessStart(resultOfStart, isRecoveringResilient);
            }
        }
        Set<ExprPreviousMatchRecognizeNode> matchRecognizeNodes = selectDesc.getStatementAgentInstanceFactorySelect().getViewResourceDelegate().getPerStream()[0].getMatchRecognizePreviousRequests();
        EPStatementStartMethodHelperAssignExpr.assignExpressionStrategies(selectDesc, aggregationService, subselectStrategyInstances, priorStrategyInstances, previousStrategyInstances, matchRecognizeNodes, matchRecognizePrevEvalStrategy, tableAccessStrategyInstances);
        for (StatementAgentInstancePreload statementAgentInstancePreload : preloadList) {
            statementAgentInstancePreload.executePreload();
        }
        if (this.statementSpec.getIntoTableSpec() != null) {
            services.getStatementVariableRefService().addReferences(statementContext.getStatementName(), this.statementSpec.getIntoTableSpec().getName());
        }
        return new EPStatementStartResult(finalViewable, stopStatementMethod, selectDesc.getDestroyCallbacks());
    }

    private void validateTableAccessUse(IntoTableSpec bindingSpec, ExprTableAccessNode[] tableNodes) throws ExprValidationException {
        if (this.statementSpec.getIntoTableSpec() != null && this.statementSpec.getTableNodes() != null && this.statementSpec.getTableNodes().length > 0) {
            for (ExprTableAccessNode node : this.statementSpec.getTableNodes()) {
                if (!node.getTableName().equals(this.statementSpec.getIntoTableSpec().getName())) continue;
                throw new ExprValidationException("Invalid use of table '" + this.statementSpec.getIntoTableSpec().getName() + "', aggregate-into requires write-only, the expression '" + ExprNodeUtility.toExpressionStringMinPrecedenceSafe(this.statementSpec.getTableNodes()[0]) + "' is not allowed");
            }
        }
    }
}

