/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.aggregator;

import com.espertech.esper.collection.RefCountedSet;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import java.util.Iterator;
import java.util.Map;

public class AggregatorAvedev
implements AggregationMethod {
    private RefCountedSet<Double> valueSet = new RefCountedSet();
    private double sum;

    @Override
    public void clear() {
        this.sum = 0.0;
        this.valueSet.clear();
    }

    @Override
    public void enter(Object object) {
        if (object == null) {
            return;
        }
        double value = ((Number)object).doubleValue();
        this.valueSet.add(value);
        this.sum += value;
    }

    @Override
    public void leave(Object object) {
        if (object == null) {
            return;
        }
        double value = ((Number)object).doubleValue();
        this.valueSet.remove(value);
        this.sum -= value;
    }

    @Override
    public Object getValue() {
        int datapoints = this.valueSet.size();
        if (datapoints == 0) {
            return null;
        }
        double total = 0.0;
        double avg = this.sum / (double)datapoints;
        Iterator<Map.Entry<Double, Integer>> it = this.valueSet.entryIterator();
        while (it.hasNext()) {
            Map.Entry<Double, Integer> entry = it.next();
            total += (double)entry.getValue().intValue() * Math.abs(entry.getKey() - avg);
        }
        return total / (double)datapoints;
    }

    @Override
    public Class getValueType() {
        return Double.class;
    }

    public RefCountedSet<Double> getValueSet() {
        return this.valueSet;
    }

    public void setValueSet(RefCountedSet<Double> valueSet) {
        this.valueSet = valueSet;
    }

    public double getSum() {
        return this.sum;
    }

    public void setSum(double sum) {
        this.sum = sum;
    }
}

