/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.aggregator;

import com.espertech.esper.epl.agg.aggregator.AggregationMethod;

public class AggregatorNth
implements AggregationMethod {
    protected final Class returnType;
    protected final int sizeBuf;
    protected Object[] circularBuffer;
    protected int currentBufferElementPointer;
    protected long numDataPoints;

    public AggregatorNth(Class returnType, int sizeBuf) {
        this.returnType = returnType;
        this.sizeBuf = sizeBuf;
    }

    @Override
    public void enter(Object value) {
        Object[] arr = (Object[])value;
        ++this.numDataPoints;
        if (this.circularBuffer == null) {
            this.clear();
        }
        this.circularBuffer[this.currentBufferElementPointer] = arr[0];
        this.currentBufferElementPointer = (this.currentBufferElementPointer + 1) % this.sizeBuf;
    }

    @Override
    public void leave(Object value) {
        if ((long)this.sizeBuf > this.numDataPoints) {
            int diff = this.sizeBuf - (int)this.numDataPoints;
            this.circularBuffer[(this.currentBufferElementPointer + diff - 1) % this.sizeBuf] = null;
        }
        --this.numDataPoints;
    }

    @Override
    public Class getValueType() {
        return this.returnType;
    }

    @Override
    public Object getValue() {
        if (this.circularBuffer == null) {
            return null;
        }
        return this.circularBuffer[(this.currentBufferElementPointer + this.sizeBuf) % this.sizeBuf];
    }

    @Override
    public void clear() {
        this.circularBuffer = new Object[this.sizeBuf];
        this.numDataPoints = 0L;
        this.currentBufferElementPointer = 0;
    }
}

