/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.aggregator;

import com.espertech.esper.epl.agg.aggregator.AggregationMethod;

public class AggregatorRate
implements AggregationMethod {
    protected double accumulator;
    protected long latest;
    protected long oldest;
    protected boolean isSet = false;

    @Override
    public void enter(Object value) {
        if (value.getClass().isArray()) {
            Object[] parameters = (Object[])value;
            Number val = (Number)parameters[1];
            this.accumulator += val.doubleValue();
            this.latest = (Long)parameters[0];
        } else {
            this.accumulator += 1.0;
            this.latest = (Long)value;
        }
    }

    @Override
    public void leave(Object value) {
        if (value.getClass().isArray()) {
            Object[] parameters = (Object[])value;
            Number val = (Number)parameters[1];
            this.accumulator -= val.doubleValue();
            this.oldest = (Long)parameters[0];
        } else {
            this.accumulator -= 1.0;
            this.oldest = (Long)value;
        }
        if (!this.isSet) {
            this.isSet = true;
        }
    }

    @Override
    public Object getValue() {
        if (!this.isSet) {
            return null;
        }
        return this.accumulator * 1000.0 / (double)(this.latest - this.oldest);
    }

    @Override
    public void clear() {
        this.accumulator = 0.0;
        this.latest = 0L;
        this.oldest = 0L;
    }

    @Override
    public Class getValueType() {
        return Double.class;
    }
}

