/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.aggregator;

import com.espertech.esper.epl.agg.aggregator.AggregationMethod;

public class AggregatorStddev
implements AggregationMethod {
    protected double mean;
    protected double qn;
    protected long numDataPoints;

    @Override
    public void clear() {
        this.mean = 0.0;
        this.numDataPoints = 0L;
        this.qn = 0.0;
    }

    @Override
    public void enter(Object object) {
        if (object == null) {
            return;
        }
        double p = ((Number)object).doubleValue();
        if (this.numDataPoints == 0L) {
            this.mean = p;
            this.qn = 0.0;
            this.numDataPoints = 1L;
        } else {
            ++this.numDataPoints;
            double oldmean = this.mean;
            this.mean += (p - this.mean) / (double)this.numDataPoints;
            this.qn += (p - oldmean) * (p - this.mean);
        }
    }

    @Override
    public void leave(Object object) {
        if (object == null) {
            return;
        }
        double p = ((Number)object).doubleValue();
        if (this.numDataPoints <= 1L) {
            this.clear();
        } else {
            --this.numDataPoints;
            double oldmean = this.mean;
            this.mean -= (p - this.mean) / (double)this.numDataPoints;
            this.qn -= (p - oldmean) * (p - this.mean);
        }
    }

    @Override
    public Object getValue() {
        if (this.numDataPoints < 2L) {
            return null;
        }
        return Math.sqrt(this.qn / (double)(this.numDataPoints - 1L));
    }

    @Override
    public Class getValueType() {
        return Double.class;
    }
}

