/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationServiceBaseUngrouped;
import com.espertech.esper.epl.agg.service.AggregationServiceVisitor;
import com.espertech.esper.epl.agg.service.AggregationServiceVisitorWGroupDetail;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.util.Collection;

public class AggSvcGroupAllMixedAccessImpl
extends AggregationServiceBaseUngrouped {
    private final AggregationAccessorSlotPair[] accessors;
    protected AggregationState[] states;

    public AggSvcGroupAllMixedAccessImpl(ExprEvaluator[] evaluators, AggregationMethod[] aggregators, AggregationAccessorSlotPair[] accessors, AggregationState[] states, AggregationMethodFactory[] aggregatorFactories, AggregationStateFactory[] accessAggregations) {
        super(evaluators, aggregators, aggregatorFactories, accessAggregations);
        this.accessors = accessors;
        this.states = states;
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object optionalGroupKeyPerRow, ExprEvaluatorContext exprEvaluatorContext) {
        int i;
        for (i = 0; i < this.evaluators.length; ++i) {
            Object columnResult = this.evaluators[i].evaluate(eventsPerStream, true, exprEvaluatorContext);
            this.aggregators[i].enter(columnResult);
        }
        for (i = 0; i < this.states.length; ++i) {
            this.states[i].applyEnter(eventsPerStream, exprEvaluatorContext);
        }
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object optionalGroupKeyPerRow, ExprEvaluatorContext exprEvaluatorContext) {
        int i;
        for (i = 0; i < this.evaluators.length; ++i) {
            Object columnResult = this.evaluators[i].evaluate(eventsPerStream, false, exprEvaluatorContext);
            this.aggregators[i].leave(columnResult);
        }
        for (i = 0; i < this.states.length; ++i) {
            this.states[i].applyLeave(eventsPerStream, exprEvaluatorContext);
        }
    }

    @Override
    public void setCurrentAccess(Object groupKey, int agentInstanceId, AggregationGroupByRollupLevel rollupLevel) {
    }

    @Override
    public Object getValue(int column, int agentInstanceId, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (column < this.aggregators.length) {
            return this.aggregators[column].getValue();
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getValue(this.states[pair.getSlot()], eventsPerStream, isNewData, exprEvaluatorContext);
    }

    @Override
    public Collection<EventBean> getCollectionOfEvents(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableEvents(this.states[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public Collection<Object> getCollectionScalar(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableScalar(this.states[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public EventBean getEventBean(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableEvent(this.states[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        for (AggregationState state : this.states) {
            state.clear();
        }
        for (AggregationMethod aggregator : this.aggregators) {
            aggregator.clear();
        }
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }

    @Override
    public void accept(AggregationServiceVisitor visitor) {
        visitor.visitAggregations(1, this.states, this.aggregators);
    }

    @Override
    public void acceptGroupDetail(AggregationServiceVisitorWGroupDetail visitor) {
    }

    @Override
    public boolean isGrouped() {
        return false;
    }

    @Override
    public Object getGroupKey(int agentInstanceId) {
        return null;
    }

    @Override
    public Collection<Object> getGroupKeys(ExprEvaluatorContext exprEvaluatorContext) {
        return null;
    }
}

