/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.access.AggregationAgent;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.agg.service.AggregationRowPair;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.agg.service.AggregationServiceVisitor;
import com.espertech.esper.epl.agg.service.AggregationServiceVisitorWGroupDetail;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.table.mgmt.TableColumnMethodPair;
import com.espertech.esper.epl.table.mgmt.TableStateInstanceUngrouped;
import com.espertech.esper.epl.table.strategy.ExprTableEvalLockUtil;
import com.espertech.esper.epl.table.strategy.ExprTableEvalStrategyUtil;
import com.espertech.esper.event.ObjectArrayBackedEventBean;
import java.util.Collection;
import java.util.concurrent.locks.Lock;

public class AggSvcGroupAllMixedAccessWTableImpl
implements AggregationService {
    private final TableStateInstanceUngrouped tableStateInstance;
    private final TableColumnMethodPair[] methodPairs;
    private final AggregationAccessorSlotPair[] accessors;
    private final int[] targetStates;
    private final ExprNode[] accessStateExpr;
    private final AggregationAgent[] agents;

    public AggSvcGroupAllMixedAccessWTableImpl(TableStateInstanceUngrouped tableStateInstance, TableColumnMethodPair[] methodPairs, AggregationAccessorSlotPair[] accessors, int[] targetStates, ExprNode[] accessStateExpr, AggregationAgent[] agents) {
        this.tableStateInstance = tableStateInstance;
        this.methodPairs = methodPairs;
        this.accessors = accessors;
        this.targetStates = targetStates;
        this.accessStateExpr = accessStateExpr;
        this.agents = agents;
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object optionalGroupKeyPerRow, ExprEvaluatorContext exprEvaluatorContext) {
        int i;
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.tableStateInstance.getTableLevelRWLock().writeLock(), exprEvaluatorContext);
        ObjectArrayBackedEventBean event = this.tableStateInstance.getCreateRowIntoTable(null, exprEvaluatorContext);
        AggregationRowPair row = ExprTableEvalStrategyUtil.getRow(event);
        for (i = 0; i < this.methodPairs.length; ++i) {
            TableColumnMethodPair methodPair = this.methodPairs[i];
            AggregationMethod method = row.getMethods()[methodPair.getTargetIndex()];
            Object columnResult = methodPair.getEvaluator().evaluate(eventsPerStream, true, exprEvaluatorContext);
            method.enter(columnResult);
        }
        for (i = 0; i < this.targetStates.length; ++i) {
            AggregationState state = row.getStates()[this.targetStates[i]];
            this.agents[i].applyEnter(eventsPerStream, exprEvaluatorContext, state);
        }
        this.tableStateInstance.handleRowUpdated(event);
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object optionalGroupKeyPerRow, ExprEvaluatorContext exprEvaluatorContext) {
        int i;
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.tableStateInstance.getTableLevelRWLock().writeLock(), exprEvaluatorContext);
        ObjectArrayBackedEventBean event = this.tableStateInstance.getCreateRowIntoTable(null, exprEvaluatorContext);
        AggregationRowPair row = ExprTableEvalStrategyUtil.getRow(event);
        for (i = 0; i < this.methodPairs.length; ++i) {
            TableColumnMethodPair methodPair = this.methodPairs[i];
            AggregationMethod method = row.getMethods()[methodPair.getTargetIndex()];
            Object columnResult = methodPair.getEvaluator().evaluate(eventsPerStream, false, exprEvaluatorContext);
            method.leave(columnResult);
        }
        for (i = 0; i < this.targetStates.length; ++i) {
            AggregationState state = row.getStates()[this.targetStates[i]];
            this.agents[i].applyLeave(eventsPerStream, exprEvaluatorContext, state);
        }
        this.tableStateInstance.handleRowUpdated(event);
    }

    @Override
    public void setCurrentAccess(Object groupKey, int agentInstanceId, AggregationGroupByRollupLevel rollupLevel) {
    }

    @Override
    public Object getValue(int column, int agentInstanceId, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.tableStateInstance.getTableLevelRWLock().writeLock(), exprEvaluatorContext);
        ObjectArrayBackedEventBean event = this.tableStateInstance.getEventReference().get();
        if (event == null) {
            return null;
        }
        AggregationRowPair row = ExprTableEvalStrategyUtil.getRow(event);
        AggregationMethod[] aggregators = row.getMethods();
        if (column < aggregators.length) {
            return aggregators[column].getValue();
        }
        AggregationAccessorSlotPair pair = this.accessors[column - aggregators.length];
        return pair.getAccessor().getValue(row.getStates()[pair.getSlot()], eventsPerStream, isNewData, exprEvaluatorContext);
    }

    @Override
    public Collection<EventBean> getCollectionOfEvents(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.tableStateInstance.getTableLevelRWLock().writeLock(), context);
        ObjectArrayBackedEventBean event = this.tableStateInstance.getEventReference().get();
        if (event == null) {
            return null;
        }
        AggregationRowPair row = ExprTableEvalStrategyUtil.getRow(event);
        AggregationMethod[] aggregators = row.getMethods();
        if (column < aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - aggregators.length];
        return pair.getAccessor().getEnumerableEvents(row.getStates()[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public Collection<Object> getCollectionScalar(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.tableStateInstance.getTableLevelRWLock().writeLock(), context);
        ObjectArrayBackedEventBean event = this.tableStateInstance.getEventReference().get();
        if (event == null) {
            return null;
        }
        AggregationRowPair row = ExprTableEvalStrategyUtil.getRow(event);
        AggregationMethod[] aggregators = row.getMethods();
        if (column < aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - aggregators.length];
        return pair.getAccessor().getEnumerableScalar(row.getStates()[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public EventBean getEventBean(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.tableStateInstance.getTableLevelRWLock().writeLock(), context);
        ObjectArrayBackedEventBean event = this.tableStateInstance.getEventReference().get();
        if (event == null) {
            return null;
        }
        AggregationRowPair row = ExprTableEvalStrategyUtil.getRow(event);
        AggregationMethod[] aggregators = row.getMethods();
        if (column < aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - aggregators.length];
        return pair.getAccessor().getEnumerableEvent(row.getStates()[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.tableStateInstance.getTableLevelRWLock().writeLock(), exprEvaluatorContext);
        ObjectArrayBackedEventBean event = this.tableStateInstance.getEventReference().get();
        if (event == null) {
            return;
        }
        AggregationRowPair row = ExprTableEvalStrategyUtil.getRow(event);
        AggregationMethod[] aggregators = row.getMethods();
        for (AggregationState state : row.getStates()) {
            state.clear();
        }
        for (AggregationMethod aggregator : aggregators) {
            aggregator.clear();
        }
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }

    @Override
    public void accept(AggregationServiceVisitor visitor) {
    }

    @Override
    public void acceptGroupDetail(AggregationServiceVisitorWGroupDetail visitor) {
    }

    @Override
    public boolean isGrouped() {
        return false;
    }

    @Override
    public Object getGroupKey(int agentInstanceId) {
        return null;
    }

    @Override
    public Collection<Object> getGroupKeys(ExprEvaluatorContext exprEvaluatorContext) {
        return null;
    }
}

