/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.service.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.agg.service.AggregationResultFuture;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.agg.service.AggregationServiceVisitor;
import com.espertech.esper.epl.agg.service.AggregationServiceVisitorWGroupDetail;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AggSvcGroupByAccessOnlyImpl
implements AggregationService,
AggregationResultFuture {
    private final MethodResolutionService methodResolutionService;
    private final Object groupKeyBinding;
    private final Map<Object, AggregationState[]> accessMap;
    private final AggregationAccessorSlotPair[] accessors;
    private final AggregationStateFactory[] accessAggSpecs;
    private final boolean isJoin;
    private AggregationState[] currentAccesses;
    private Object currentGroupKey;

    public AggSvcGroupByAccessOnlyImpl(MethodResolutionService methodResolutionService, Object groupKeyBinding, AggregationAccessorSlotPair[] accessors, AggregationStateFactory[] accessAggSpecs, boolean isJoin) {
        this.methodResolutionService = methodResolutionService;
        this.groupKeyBinding = groupKeyBinding;
        this.accessMap = new HashMap<Object, AggregationState[]>();
        this.accessors = accessors;
        this.accessAggSpecs = accessAggSpecs;
        this.isJoin = isJoin;
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object groupKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationState[] row = this.getAssertRow(exprEvaluatorContext.getAgentInstanceId(), groupKey);
        for (int i = 0; i < row.length; ++i) {
            row[i].applyEnter(eventsPerStream, exprEvaluatorContext);
        }
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object groupKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationState[] row = this.getAssertRow(exprEvaluatorContext.getAgentInstanceId(), groupKey);
        for (int i = 0; i < row.length; ++i) {
            row[i].applyLeave(eventsPerStream, exprEvaluatorContext);
        }
    }

    @Override
    public void setCurrentAccess(Object groupKey, int agentInstanceId, AggregationGroupByRollupLevel rollupLevel) {
        this.currentAccesses = this.getAssertRow(agentInstanceId, groupKey);
        this.currentGroupKey = groupKey;
    }

    @Override
    public Object getValue(int column, int agentInstanceId, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationAccessorSlotPair pair = this.accessors[column];
        return pair.getAccessor().getValue(this.currentAccesses[pair.getSlot()], eventsPerStream, isNewData, exprEvaluatorContext);
    }

    @Override
    public Collection<EventBean> getCollectionOfEvents(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        AggregationAccessorSlotPair pair = this.accessors[column];
        return pair.getAccessor().getEnumerableEvents(this.currentAccesses[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public Collection<Object> getCollectionScalar(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        AggregationAccessorSlotPair pair = this.accessors[column];
        return pair.getAccessor().getEnumerableScalar(this.currentAccesses[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public EventBean getEventBean(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        AggregationAccessorSlotPair pair = this.accessors[column];
        return pair.getAccessor().getEnumerableEvent(this.currentAccesses[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        this.accessMap.clear();
    }

    private AggregationState[] getAssertRow(int agentInstanceId, Object groupKey) {
        AggregationState[] row = this.accessMap.get(groupKey);
        if (row != null) {
            return row;
        }
        row = this.methodResolutionService.newAccesses(agentInstanceId, this.isJoin, this.accessAggSpecs, groupKey, this.groupKeyBinding, null);
        this.accessMap.put(groupKey, row);
        return row;
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }

    @Override
    public void accept(AggregationServiceVisitor visitor) {
        visitor.visitAggregations(this.accessMap.size(), this.accessMap);
    }

    @Override
    public void acceptGroupDetail(AggregationServiceVisitorWGroupDetail visitor) {
        visitor.visitGrouped(this.accessMap.size());
        for (Map.Entry<Object, AggregationState[]> entry : this.accessMap.entrySet()) {
            visitor.visitGroup(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean isGrouped() {
        return true;
    }

    @Override
    public Object getGroupKey(int agentInstanceId) {
        return this.currentGroupKey;
    }

    @Override
    public Collection<Object> getGroupKeys(ExprEvaluatorContext exprEvaluatorContext) {
        return this.accessMap.keySet();
    }
}

