/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationRowPair;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationServiceBaseGrouped;
import com.espertech.esper.epl.agg.service.AggregationServiceVisitor;
import com.espertech.esper.epl.agg.service.AggregationServiceVisitorWGroupDetail;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AggSvcGroupByMixedAccessImpl
extends AggregationServiceBaseGrouped {
    private final AggregationAccessorSlotPair[] accessorsFactory;
    protected final AggregationStateFactory[] accessAggregations;
    protected final boolean isJoin;
    protected Map<Object, AggregationRowPair> aggregatorsPerGroup;
    private AggregationRowPair currentAggregatorRow;
    private Object currentGroupKey;
    private MethodResolutionService methodResolutionService;

    public AggSvcGroupByMixedAccessImpl(ExprEvaluator[] evaluators, AggregationMethodFactory[] prototypes, Object groupKeyBinding, MethodResolutionService methodResolutionService, AggregationAccessorSlotPair[] accessorsFactory, AggregationStateFactory[] accessAggregations, boolean isJoin) {
        super(evaluators, prototypes, groupKeyBinding);
        this.accessorsFactory = accessorsFactory;
        this.accessAggregations = accessAggregations;
        this.isJoin = isJoin;
        this.methodResolutionService = methodResolutionService;
        this.aggregatorsPerGroup = new HashMap<Object, AggregationRowPair>();
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        this.aggregatorsPerGroup.clear();
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationRowPair groupAggregators = this.aggregatorsPerGroup.get(groupByKey);
        if (groupAggregators == null) {
            AggregationMethod[] methods = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceId(), groupByKey, this.groupKeyBinding, null);
            AggregationState[] states = this.methodResolutionService.newAccesses(exprEvaluatorContext.getAgentInstanceId(), this.isJoin, this.accessAggregations, groupByKey, this.groupKeyBinding, null);
            groupAggregators = new AggregationRowPair(methods, states);
            this.aggregatorsPerGroup.put(groupByKey, groupAggregators);
        }
        this.currentAggregatorRow = groupAggregators;
        AggregationMethod[] groupAggMethods = groupAggregators.getMethods();
        for (int i = 0; i < this.evaluators.length; ++i) {
            Object columnResult = this.evaluators[i].evaluate(eventsPerStream, true, exprEvaluatorContext);
            groupAggMethods[i].enter(columnResult);
        }
        AggregationState[] states = this.currentAggregatorRow.getStates();
        for (int i = 0; i < states.length; ++i) {
            states[i].applyEnter(eventsPerStream, exprEvaluatorContext);
        }
        this.internalHandleUpdated(groupByKey, groupAggregators);
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationRowPair groupAggregators = this.aggregatorsPerGroup.get(groupByKey);
        if (groupAggregators == null) {
            AggregationMethod[] methods = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceId(), groupByKey, this.groupKeyBinding, null);
            AggregationState[] states = this.methodResolutionService.newAccesses(exprEvaluatorContext.getAgentInstanceId(), this.isJoin, this.accessAggregations, groupByKey, this.groupKeyBinding, null);
            groupAggregators = new AggregationRowPair(methods, states);
            this.aggregatorsPerGroup.put(groupByKey, groupAggregators);
        }
        this.currentAggregatorRow = groupAggregators;
        AggregationMethod[] groupAggMethods = groupAggregators.getMethods();
        for (int i = 0; i < this.evaluators.length; ++i) {
            Object columnResult = this.evaluators[i].evaluate(eventsPerStream, false, exprEvaluatorContext);
            groupAggMethods[i].leave(columnResult);
        }
        AggregationState[] states = this.currentAggregatorRow.getStates();
        for (int i = 0; i < states.length; ++i) {
            states[i].applyLeave(eventsPerStream, exprEvaluatorContext);
        }
        this.internalHandleUpdated(groupByKey, groupAggregators);
    }

    @Override
    public void setCurrentAccess(Object groupByKey, int agentInstanceId, AggregationGroupByRollupLevel rollupLevel) {
        this.currentAggregatorRow = this.aggregatorsPerGroup.get(groupByKey);
        this.currentGroupKey = groupByKey;
        if (this.currentAggregatorRow == null) {
            AggregationMethod[] methods = this.methodResolutionService.newAggregators(this.aggregators, agentInstanceId, groupByKey, this.groupKeyBinding, null);
            AggregationState[] states = this.methodResolutionService.newAccesses(agentInstanceId, this.isJoin, this.accessAggregations, groupByKey, this.groupKeyBinding, null);
            this.currentAggregatorRow = new AggregationRowPair(methods, states);
            this.aggregatorsPerGroup.put(groupByKey, this.currentAggregatorRow);
        }
    }

    @Override
    public Object getValue(int column, int agentInstanceId, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (column < this.aggregators.length) {
            return this.currentAggregatorRow.getMethods()[column].getValue();
        }
        AggregationAccessorSlotPair pair = this.accessorsFactory[column - this.aggregators.length];
        return pair.getAccessor().getValue(this.currentAggregatorRow.getStates()[pair.getSlot()], eventsPerStream, isNewData, exprEvaluatorContext);
    }

    @Override
    public Collection<EventBean> getCollectionOfEvents(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessorsFactory[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableEvents(this.currentAggregatorRow.getStates()[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public Collection<Object> getCollectionScalar(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessorsFactory[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableScalar(this.currentAggregatorRow.getStates()[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public EventBean getEventBean(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessorsFactory[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableEvent(this.currentAggregatorRow.getStates()[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }

    public void internalHandleUpdated(Object groupByKey, AggregationRowPair groupAggregators) {
    }

    @Override
    public void accept(AggregationServiceVisitor visitor) {
        visitor.visitAggregations(this.aggregatorsPerGroup.size(), this.aggregatorsPerGroup);
    }

    @Override
    public void acceptGroupDetail(AggregationServiceVisitorWGroupDetail visitor) {
        visitor.visitGrouped(this.aggregatorsPerGroup.size());
        for (Map.Entry<Object, AggregationRowPair> entry : this.aggregatorsPerGroup.entrySet()) {
            visitor.visitGroup(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean isGrouped() {
        return true;
    }

    @Override
    public Object getGroupKey(int agentInstanceId) {
        return this.currentGroupKey;
    }

    @Override
    public Collection<Object> getGroupKeys(ExprEvaluatorContext exprEvaluatorContext) {
        return this.aggregatorsPerGroup.keySet();
    }
}

