/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggSvcGroupByReclaimAgedEvalFunc;
import com.espertech.esper.epl.agg.service.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationMethodRowAged;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationServiceBaseGrouped;
import com.espertech.esper.epl.agg.service.AggregationServiceVisitor;
import com.espertech.esper.epl.agg.service.AggregationServiceVisitorWGroupDetail;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AggSvcGroupByReclaimAgedImpl
extends AggregationServiceBaseGrouped {
    private static final Log log = LogFactory.getLog(AggSvcGroupByReclaimAgedImpl.class);
    private static final long DEFAULT_MAX_AGE_MSEC = 60000L;
    private final AggregationAccessorSlotPair[] accessors;
    protected final AggregationStateFactory[] accessAggregations;
    protected final boolean isJoin;
    private final AggSvcGroupByReclaimAgedEvalFunc evaluationFunctionMaxAge;
    private final AggSvcGroupByReclaimAgedEvalFunc evaluationFunctionFrequency;
    private final MethodResolutionService methodResolutionService;
    protected Map<Object, AggregationMethodRowAged> aggregatorsPerGroup;
    private AggregationMethod[] currentAggregatorMethods;
    private AggregationState[] currentAggregatorStates;
    private Object currentGroupKey;
    private List<Object> removedKeys;
    private Long nextSweepTime = null;
    private AggregationRowRemovedCallback removedCallback;
    private volatile long currentMaxAge = 60000L;
    private volatile long currentReclaimFrequency = 60000L;

    public AggSvcGroupByReclaimAgedImpl(ExprEvaluator[] evaluators, AggregationMethodFactory[] aggregators, Object groupKeyBinding, AggregationAccessorSlotPair[] accessors, AggregationStateFactory[] accessAggregations, boolean join, AggSvcGroupByReclaimAgedEvalFunc evaluationFunctionMaxAge, AggSvcGroupByReclaimAgedEvalFunc evaluationFunctionFrequency, MethodResolutionService methodResolutionService) {
        super(evaluators, aggregators, groupKeyBinding);
        this.accessors = accessors;
        this.accessAggregations = accessAggregations;
        this.isJoin = join;
        this.evaluationFunctionMaxAge = evaluationFunctionMaxAge;
        this.evaluationFunctionFrequency = evaluationFunctionFrequency;
        this.methodResolutionService = methodResolutionService;
        this.aggregatorsPerGroup = new HashMap<Object, AggregationMethodRowAged>();
        this.removedKeys = new ArrayList<Object>();
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        this.aggregatorsPerGroup.clear();
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        int i;
        AggregationState[] groupStates;
        AggregationMethod[] groupAggregators;
        long currentTime = exprEvaluatorContext.getTimeProvider().getTime();
        if (this.nextSweepTime == null || this.nextSweepTime <= currentTime) {
            this.currentMaxAge = this.getMaxAge(this.currentMaxAge);
            this.currentReclaimFrequency = this.getReclaimFrequency(this.currentReclaimFrequency);
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug((Object)("Reclaiming groups older then " + this.currentMaxAge + " msec and every " + this.currentReclaimFrequency + "msec in frequency"));
            }
            this.nextSweepTime = currentTime + this.currentReclaimFrequency;
            this.sweep(currentTime, this.currentMaxAge);
        }
        this.handleRemovedKeys();
        AggregationMethodRowAged row = this.aggregatorsPerGroup.get(groupByKey);
        if (row == null) {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceId(), groupByKey, this.groupKeyBinding, null);
            groupStates = this.methodResolutionService.newAccesses(exprEvaluatorContext.getAgentInstanceId(), this.isJoin, this.accessAggregations, groupByKey, this.groupKeyBinding, null);
            row = new AggregationMethodRowAged(this.methodResolutionService.getCurrentRowCount(groupAggregators, groupStates) + 1L, currentTime, groupAggregators, groupStates);
            this.aggregatorsPerGroup.put(groupByKey, row);
        } else {
            groupAggregators = row.getMethods();
            groupStates = row.getStates();
            row.increaseRefcount();
            row.setLastUpdateTime(currentTime);
        }
        this.currentAggregatorMethods = groupAggregators;
        this.currentAggregatorStates = groupStates;
        for (i = 0; i < this.evaluators.length; ++i) {
            Object columnResult = this.evaluators[i].evaluate(eventsPerStream, true, exprEvaluatorContext);
            groupAggregators[i].enter(columnResult);
        }
        for (i = 0; i < this.currentAggregatorStates.length; ++i) {
            this.currentAggregatorStates[i].applyEnter(eventsPerStream, exprEvaluatorContext);
        }
        this.internalHandleUpdated(groupByKey, row);
    }

    private void sweep(long currentTime, long currentMaxAge) {
        ArrayDeque<Object> removed = new ArrayDeque<Object>();
        for (Map.Entry<Object, AggregationMethodRowAged> entry : this.aggregatorsPerGroup.entrySet()) {
            long age = currentTime - entry.getValue().getLastUpdateTime();
            if (age <= currentMaxAge) continue;
            removed.add(entry.getKey());
        }
        for (Map.Entry<Object, AggregationMethodRowAged> entry : removed) {
            this.aggregatorsPerGroup.remove(entry);
            this.internalHandleRemoved(entry);
            this.removedCallback.removed(entry);
        }
    }

    private long getMaxAge(long currentMaxAge) {
        Double maxAge = this.evaluationFunctionMaxAge.getLongValue();
        if (maxAge == null || maxAge <= 0.0) {
            return currentMaxAge;
        }
        return Math.round(maxAge * 1000.0);
    }

    private long getReclaimFrequency(long currentReclaimFrequency) {
        Double frequency = this.evaluationFunctionFrequency.getLongValue();
        if (frequency == null || frequency <= 0.0) {
            return currentReclaimFrequency;
        }
        return Math.round(frequency * 1000.0);
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        int i;
        AggregationState[] groupStates;
        AggregationMethod[] groupAggregators;
        AggregationMethodRowAged row = this.aggregatorsPerGroup.get(groupByKey);
        long currentTime = exprEvaluatorContext.getTimeProvider().getTime();
        if (row != null) {
            groupAggregators = row.getMethods();
            groupStates = row.getStates();
        } else {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceId(), groupByKey, this.groupKeyBinding, null);
            groupStates = this.methodResolutionService.newAccesses(exprEvaluatorContext.getAgentInstanceId(), this.isJoin, this.accessAggregations, groupByKey, this.groupKeyBinding, null);
            row = new AggregationMethodRowAged(this.methodResolutionService.getCurrentRowCount(groupAggregators, groupStates) + 1L, currentTime, groupAggregators, groupStates);
            this.aggregatorsPerGroup.put(groupByKey, row);
        }
        this.currentAggregatorMethods = groupAggregators;
        this.currentAggregatorStates = groupStates;
        for (i = 0; i < this.evaluators.length; ++i) {
            Object columnResult = this.evaluators[i].evaluate(eventsPerStream, false, exprEvaluatorContext);
            groupAggregators[i].leave(columnResult);
        }
        for (i = 0; i < this.currentAggregatorStates.length; ++i) {
            this.currentAggregatorStates[i].applyLeave(eventsPerStream, exprEvaluatorContext);
        }
        row.decreaseRefcount();
        row.setLastUpdateTime(currentTime);
        if (row.getRefcount() <= 0L) {
            this.removedKeys.add(groupByKey);
            this.methodResolutionService.removeAggregators(exprEvaluatorContext.getAgentInstanceId(), groupByKey, this.groupKeyBinding, null);
        }
        this.internalHandleUpdated(groupByKey, row);
    }

    @Override
    public void setCurrentAccess(Object groupByKey, int agentInstanceId, AggregationGroupByRollupLevel rollupLevel) {
        AggregationMethodRowAged row = this.aggregatorsPerGroup.get(groupByKey);
        if (row != null) {
            this.currentAggregatorMethods = row.getMethods();
            this.currentAggregatorStates = row.getStates();
        } else {
            this.currentAggregatorMethods = null;
        }
        if (this.currentAggregatorMethods == null) {
            this.currentAggregatorMethods = this.methodResolutionService.newAggregators(this.aggregators, agentInstanceId, groupByKey, this.groupKeyBinding, null);
            this.currentAggregatorStates = this.methodResolutionService.newAccesses(agentInstanceId, this.isJoin, this.accessAggregations, groupByKey, this.groupKeyBinding, null);
        }
        this.currentGroupKey = groupByKey;
    }

    @Override
    public Object getValue(int column, int agentInstanceId, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (column < this.aggregators.length) {
            return this.currentAggregatorMethods[column].getValue();
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getValue(this.currentAggregatorStates[pair.getSlot()], eventsPerStream, isNewData, exprEvaluatorContext);
    }

    @Override
    public Collection<EventBean> getCollectionOfEvents(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableEvents(this.currentAggregatorStates[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public Collection<Object> getCollectionScalar(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableScalar(this.currentAggregatorStates[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public EventBean getEventBean(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getEnumerableEvent(this.currentAggregatorStates[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
        this.removedCallback = callback;
    }

    public void internalHandleUpdated(Object groupByKey, AggregationMethodRowAged row) {
    }

    public void internalHandleRemoved(Object key) {
    }

    @Override
    public void accept(AggregationServiceVisitor visitor) {
        visitor.visitAggregations(this.aggregatorsPerGroup.size(), this.aggregatorsPerGroup);
    }

    @Override
    public void acceptGroupDetail(AggregationServiceVisitorWGroupDetail visitor) {
        visitor.visitGrouped(this.aggregatorsPerGroup.size());
        for (Map.Entry<Object, AggregationMethodRowAged> entry : this.aggregatorsPerGroup.entrySet()) {
            visitor.visitGroup(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean isGrouped() {
        return true;
    }

    protected void handleRemovedKeys() {
        if (!this.removedKeys.isEmpty()) {
            for (Object removedKey : this.removedKeys) {
                this.aggregatorsPerGroup.remove(removedKey);
                this.internalHandleRemoved(removedKey);
            }
            this.removedKeys.clear();
        }
    }

    @Override
    public Object getGroupKey(int agentInstanceId) {
        return this.currentGroupKey;
    }

    @Override
    public Collection<Object> getGroupKeys(ExprEvaluatorContext exprEvaluatorContext) {
        return this.aggregatorsPerGroup.keySet();
    }
}

