/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.annotation;

import com.espertech.esper.client.EPStatementException;
import com.espertech.esper.client.annotation.Hint;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.annotation.AnnotationAttribute;
import com.espertech.esper.epl.annotation.AnnotationException;
import com.espertech.esper.epl.annotation.EPLAnnotationInvocationHandler;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.AnnotationDesc;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleTypeCaster;
import com.espertech.esper.util.SimpleTypeCasterFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AnnotationUtil {
    private static final Log log = LogFactory.getLog(AnnotationUtil.class);

    public static Map<String, List<AnnotationDesc>> mapByNameLowerCase(List<AnnotationDesc> annotations) {
        HashMap<String, List<AnnotationDesc>> map = new HashMap<String, List<AnnotationDesc>>();
        for (AnnotationDesc desc : annotations) {
            String key = desc.getName().toLowerCase();
            if (map.containsKey(key)) {
                ((List)map.get(key)).add(desc);
                continue;
            }
            ArrayList<AnnotationDesc> annos = new ArrayList<AnnotationDesc>(2);
            annos.add(desc);
            map.put(key, annos);
        }
        return map;
    }

    public static Object getValue(AnnotationDesc desc) {
        for (Pair<String, Object> pair : desc.getAttributes()) {
            if (!pair.getFirst().toLowerCase().equals("value")) continue;
            return pair.getSecond();
        }
        return null;
    }

    public static Annotation[] compileAnnotations(List<AnnotationDesc> annotationSpec, EngineImportService engineImportService, String eplStatement) {
        Annotation[] annotations;
        try {
            annotations = AnnotationUtil.compileAnnotations(annotationSpec, engineImportService);
        }
        catch (AnnotationException e) {
            throw new EPStatementException("Failed to process statement annotations: " + e.getMessage(), e, eplStatement);
        }
        catch (RuntimeException ex) {
            String message = "Unexpected exception compiling annotations in statement, please consult the log file and report the exception: " + ex.getMessage();
            log.error((Object)message, (Throwable)ex);
            throw new EPStatementException(message, ex, eplStatement);
        }
        return annotations;
    }

    private static Annotation[] compileAnnotations(List<AnnotationDesc> desc, EngineImportService engineImportService) throws AnnotationException {
        Annotation[] annotations = new Annotation[desc.size()];
        for (int i = 0; i < desc.size(); ++i) {
            annotations[i] = AnnotationUtil.createProxy(desc.get(i), engineImportService);
            if (!(annotations[i] instanceof Hint)) continue;
            HintEnum.validateGetListed(annotations[i]);
        }
        return annotations;
    }

    private static Annotation createProxy(AnnotationDesc desc, EngineImportService engineImportService) throws AnnotationException {
        Class annotationClass;
        try {
            annotationClass = engineImportService.resolveAnnotation(desc.getName());
        }
        catch (EngineImportException e) {
            throw new AnnotationException("Failed to resolve @-annotation class: " + e.getMessage());
        }
        List<AnnotationAttribute> annotationAttributeLists = AnnotationUtil.getAttributes(annotationClass);
        HashSet<String> allAttributes = new HashSet<String>();
        LinkedHashSet<String> requiredAttributes = new LinkedHashSet<String>();
        for (AnnotationAttribute annotationAttribute : annotationAttributeLists) {
            allAttributes.add(annotationAttribute.getName());
            if (annotationAttribute.getDefaultValue() == null) continue;
            requiredAttributes.add(annotationAttribute.getName());
        }
        ArrayList<String> providedValues = new ArrayList<String>();
        for (Pair<String, Object> annotationValuePair : desc.getAttributes()) {
            providedValues.add(annotationValuePair.getFirst());
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (AnnotationAttribute annotationAttribute : annotationAttributeLists) {
            String attributeName = annotationAttribute.getName();
            Pair<String, Object> pairFound = null;
            for (Pair<String, Object> annotationValuePair : desc.getAttributes()) {
                if (!annotationValuePair.getFirst().equals(attributeName)) continue;
                pairFound = annotationValuePair;
            }
            Object valueProvided = pairFound == null ? null : pairFound.getSecond();
            Object value = AnnotationUtil.getFinalValue(annotationClass, annotationAttribute, valueProvided, engineImportService);
            properties.put(attributeName, value);
            providedValues.remove(attributeName);
            requiredAttributes.remove(attributeName);
        }
        if (requiredAttributes.size() > 0) {
            ArrayList required = new ArrayList(requiredAttributes);
            Collections.sort(required);
            throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a value for attribute '" + (String)required.iterator().next() + "'");
        }
        if (providedValues.size() > 0) {
            ArrayList provided = new ArrayList(providedValues);
            Collections.sort(provided);
            if (allAttributes.contains(provided.get(0))) {
                throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' has duplicate attribute values for attribute '" + (String)provided.get(0) + "'");
            }
            throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' does not have an attribute '" + (String)provided.get(0) + "'");
        }
        EPLAnnotationInvocationHandler handler = new EPLAnnotationInvocationHandler(annotationClass, properties);
        return (Annotation)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{annotationClass}, (InvocationHandler)handler);
    }

    private static Object getFinalValue(Class annotationClass, AnnotationAttribute annotationAttribute, Object value, EngineImportService engineImportService) throws AnnotationException {
        if (value == null) {
            if (annotationAttribute.getDefaultValue() == null) {
                throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a value for attribute '" + annotationAttribute.getName() + "'");
            }
            return annotationAttribute.getDefaultValue();
        }
        if (!annotationAttribute.getType().isArray()) {
            if (!annotationAttribute.getType().isAnnotation()) {
                SimpleTypeCaster caster = SimpleTypeCasterFactory.getCaster(value.getClass(), annotationAttribute.getType());
                Object finalValue = caster.cast(value);
                if (finalValue == null) {
                    throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a " + annotationAttribute.getType().getSimpleName() + "-typed value for attribute '" + annotationAttribute.getName() + "' but received " + "a " + value.getClass().getSimpleName() + "-typed value");
                }
                return finalValue;
            }
            if (!(value instanceof AnnotationDesc)) {
                throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a " + annotationAttribute.getType().getSimpleName() + "-typed value for attribute '" + annotationAttribute.getName() + "' but received " + "a " + value.getClass().getSimpleName() + "-typed value");
            }
            return AnnotationUtil.createProxy((AnnotationDesc)value, engineImportService);
        }
        if (!value.getClass().isArray()) {
            throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a " + annotationAttribute.getType().getSimpleName() + "-typed value for attribute '" + annotationAttribute.getName() + "' but received " + "a " + value.getClass().getSimpleName() + "-typed value");
        }
        Object array = Array.newInstance(annotationAttribute.getType().getComponentType(), Array.getLength(value));
        for (int i = 0; i < Array.getLength(value); ++i) {
            Object arrayValue = Array.get(value, i);
            if (arrayValue == null) {
                throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a " + "non-null value for array elements for attribute '" + annotationAttribute.getName() + "'");
            }
            SimpleTypeCaster caster = SimpleTypeCasterFactory.getCaster(arrayValue.getClass(), annotationAttribute.getType().getComponentType());
            Object finalValue = caster.cast(arrayValue);
            if (finalValue == null) {
                throw new AnnotationException("Annotation '" + annotationClass.getSimpleName() + "' requires a " + annotationAttribute.getType().getComponentType().getSimpleName() + "-typed value for array elements for attribute '" + annotationAttribute.getName() + "' but received " + "a " + arrayValue.getClass().getSimpleName() + "-typed value");
            }
            Array.set(array, i, finalValue);
        }
        return array;
    }

    private static List<AnnotationAttribute> getAttributes(Class annotationClass) {
        ArrayList<AnnotationAttribute> props = new ArrayList<AnnotationAttribute>();
        Method[] methods = annotationClass.getMethods();
        if (methods == null) {
            return Collections.EMPTY_LIST;
        }
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getReturnType() == Void.TYPE || methods[i].getParameterTypes().length > 0 || methods[i].getName().equals("class") || methods[i].getName().equals("getClass") || methods[i].getName().equals("toString") || methods[i].getName().equals("annotationType") || methods[i].getName().equals("hashCode")) continue;
            props.add(new AnnotationAttribute(methods[i].getName(), methods[i].getReturnType(), methods[i].getDefaultValue()));
        }
        Collections.sort(props, new Comparator<AnnotationAttribute>(){

            @Override
            public int compare(AnnotationAttribute o1, AnnotationAttribute o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return props;
    }

    public static Annotation findAnnotation(Annotation[] annotations, Class annotationClass) {
        if (!annotationClass.isAnnotation()) {
            throw new IllegalArgumentException("Class " + annotationClass.getName() + " is not an annotation class");
        }
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        for (Annotation anno : annotations) {
            if (!JavaClassHelper.isImplementsInterface(anno.getClass(), annotationClass)) continue;
            return anno;
        }
        return null;
    }

    public static List<Annotation> findAnnotations(Annotation[] annotations, Class annotationClass) {
        if (!annotationClass.isAnnotation()) {
            throw new IllegalArgumentException("Class " + annotationClass.getName() + " is not an annotation class");
        }
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        ArrayList<Annotation> annotationsList = new ArrayList<Annotation>();
        for (Annotation anno : annotations) {
            if (!JavaClassHelper.isImplementsInterface(anno.getClass(), annotationClass)) continue;
            annotationsList.add(anno);
        }
        return annotationsList;
    }

    public static Annotation[] mergeAnnotations(Annotation[] first, Annotation[] second) {
        return (Annotation[])CollectionUtil.addArrays(first, second);
    }

    public static String getExpectSingleStringValue(String msgPrefix, List<AnnotationDesc> annotationsSameName) throws ExprValidationException {
        if (annotationsSameName.size() > 1) {
            throw new ExprValidationException(msgPrefix + " multiple annotations provided named '" + annotationsSameName.get(0).getName() + "'");
        }
        AnnotationDesc annotation = annotationsSameName.get(0);
        Object value = AnnotationUtil.getValue(annotation);
        if (value == null) {
            throw new ExprValidationException(msgPrefix + " no value provided for annotation '" + annotation.getName() + "', expected a value");
        }
        if (!(value instanceof String)) {
            throw new ExprValidationException(msgPrefix + " string value expected for annotation '" + annotation.getName() + "'");
        }
        return (String)value;
    }
}

