/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.MethodPollingExecStrategyEnum;
import com.espertech.esper.epl.db.PollExecStrategy;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MethodPollingExecStrategyBase
implements PollExecStrategy {
    private static final Log log = LogFactory.getLog(MethodPollingExecStrategyBase.class);
    protected final EventAdapterService eventAdapterService;
    protected final FastMethod method;
    protected final EventType eventType;
    protected final Object invocationTarget;
    protected final MethodPollingExecStrategyEnum strategy;
    protected final VariableReader variableReader;
    protected final String variableName;
    protected final VariableService variableService;

    public MethodPollingExecStrategyBase(EventAdapterService eventAdapterService, FastMethod method, EventType eventType, Object invocationTarget, MethodPollingExecStrategyEnum strategy, VariableReader variableReader, String variableName, VariableService variableService) {
        this.eventAdapterService = eventAdapterService;
        this.method = method;
        this.eventType = eventType;
        this.invocationTarget = invocationTarget;
        this.strategy = strategy;
        this.variableReader = variableReader;
        this.variableName = variableName;
        this.variableService = variableService;
    }

    protected abstract List<EventBean> handleResult(Object var1);

    protected boolean checkNonNullArrayValue(Object value) {
        if (value == null) {
            log.warn((Object)("Expected non-null return result from method '" + this.method.getName() + "', but received null array element value"));
            return false;
        }
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void done() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public List<EventBean> poll(Object[] lookupValues, ExprEvaluatorContext exprEvaluatorContext) {
        switch (this.strategy) {
            case TARGET_CONST: {
                return this.invokeInternal(lookupValues, this.invocationTarget);
            }
            case TARGET_VAR: {
                return this.invokeInternalVariable(lookupValues, this.variableReader);
            }
            case TARGET_VAR_CONTEXT: {
                VariableReader reader = this.variableService.getReader(this.variableName, exprEvaluatorContext.getAgentInstanceId());
                if (reader == null) {
                    return null;
                }
                return this.invokeInternalVariable(lookupValues, reader);
            }
        }
        throw new UnsupportedOperationException("unrecognized strategy " + (Object)((Object)this.strategy));
    }

    private List<EventBean> invokeInternalVariable(Object[] lookupValues, VariableReader variableReader) {
        Object target = variableReader.getValue();
        if (target == null) {
            return null;
        }
        if (target instanceof EventBean) {
            target = ((EventBean)target).getUnderlying();
        }
        return this.invokeInternal(lookupValues, target);
    }

    private List<EventBean> invokeInternal(Object[] lookupValues, Object invocationTarget) {
        try {
            Object invocationResult = this.method.invoke(invocationTarget, lookupValues);
            if (invocationResult != null) {
                return this.handleResult(invocationResult);
            }
            return null;
        }
        catch (InvocationTargetException ex) {
            throw new EPException("Method '" + this.method.getName() + "' of class '" + this.method.getJavaMethod().getDeclaringClass().getName() + "' reported an exception: " + ex.getTargetException(), ex.getTargetException());
        }
    }
}

