/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.hook.AggregationFunctionFactory;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.access.AggregationStateImpl;
import com.espertech.esper.epl.agg.access.AggregationStateJoinImpl;
import com.espertech.esper.epl.agg.access.AggregationStateMinMaxByEver;
import com.espertech.esper.epl.agg.access.AggregationStateMinMaxByEverSpec;
import com.espertech.esper.epl.agg.access.AggregationStateSortedImpl;
import com.espertech.esper.epl.agg.access.AggregationStateSortedJoin;
import com.espertech.esper.epl.agg.access.AggregationStateSortedSpec;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.aggregator.AggregatorAvedev;
import com.espertech.esper.epl.agg.aggregator.AggregatorAvedevFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorAvg;
import com.espertech.esper.epl.agg.aggregator.AggregatorAvgBigDecimal;
import com.espertech.esper.epl.agg.aggregator.AggregatorAvgBigDecimalFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorAvgFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorCount;
import com.espertech.esper.epl.agg.aggregator.AggregatorCountEver;
import com.espertech.esper.epl.agg.aggregator.AggregatorCountEverFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorCountEverNonNull;
import com.espertech.esper.epl.agg.aggregator.AggregatorCountEverNonNullFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorCountFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorCountNonNull;
import com.espertech.esper.epl.agg.aggregator.AggregatorCountNonNullFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorDistinctValue;
import com.espertech.esper.epl.agg.aggregator.AggregatorDistinctValueFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorFirstEver;
import com.espertech.esper.epl.agg.aggregator.AggregatorFirstEverFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorLastEver;
import com.espertech.esper.epl.agg.aggregator.AggregatorLastEverFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorLeaving;
import com.espertech.esper.epl.agg.aggregator.AggregatorMedian;
import com.espertech.esper.epl.agg.aggregator.AggregatorMedianFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorMinMax;
import com.espertech.esper.epl.agg.aggregator.AggregatorMinMaxEver;
import com.espertech.esper.epl.agg.aggregator.AggregatorMinMaxEverFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorMinMaxFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorNth;
import com.espertech.esper.epl.agg.aggregator.AggregatorRate;
import com.espertech.esper.epl.agg.aggregator.AggregatorRateEver;
import com.espertech.esper.epl.agg.aggregator.AggregatorStddev;
import com.espertech.esper.epl.agg.aggregator.AggregatorStddevFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumBigDecimal;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumBigDecimalFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumBigInteger;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumBigIntegerFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumDouble;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumDoubleFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumFloat;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumFloatFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumInteger;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumIntegerFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumLong;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumLongFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumNumInteger;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumNumIntegerFilter;
import com.espertech.esper.epl.agg.service.AggregationGroupByRollupDesc;
import com.espertech.esper.epl.agg.service.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.agg.util.AggregationLocalGroupByPlan;
import com.espertech.esper.epl.approx.CountMinSketchAggState;
import com.espertech.esper.epl.approx.CountMinSketchSpec;
import com.espertech.esper.epl.approx.CountMinSketchState;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.EngineImportSingleRowDesc;
import com.espertech.esper.epl.core.EngineImportUndefinedException;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.plugin.PlugInAggregationMultiFunctionStateContext;
import com.espertech.esper.plugin.PlugInAggregationMultiFunctionStateFactory;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.type.MinMaxTypeEnum;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MethodResolutionServiceImpl
implements MethodResolutionService {
    private final EngineImportService engineImportService;
    private final TimeProvider timeProvider;

    public MethodResolutionServiceImpl(EngineImportService engineImportService, TimeProvider timeProvider) {
        this.engineImportService = engineImportService;
        this.timeProvider = timeProvider;
    }

    @Override
    public boolean isUdfCache() {
        return this.engineImportService.isUdfCache();
    }

    @Override
    public boolean isDuckType() {
        return this.engineImportService.isDuckType();
    }

    @Override
    public boolean isSortUsingCollator() {
        return this.engineImportService.isSortUsingCollator();
    }

    @Override
    public Method resolveMethod(String className, String methodName, Class[] paramTypes, boolean[] allowEventBeanType, boolean[] allowEventBeanCollType) throws EngineImportException {
        return this.engineImportService.resolveMethod(className, methodName, paramTypes, allowEventBeanType, allowEventBeanCollType);
    }

    @Override
    public Method resolveMethod(String className, String methodName) throws EngineImportException {
        return this.engineImportService.resolveMethod(className, methodName);
    }

    @Override
    public Method resolveNonStaticMethod(Class clazz, String methodName) throws EngineImportException {
        return this.engineImportService.resolveNonStaticMethod(clazz, methodName);
    }

    @Override
    public Constructor resolveCtor(Class clazz, Class[] paramTypes) throws EngineImportException {
        return this.engineImportService.resolveCtor(clazz, paramTypes);
    }

    @Override
    public Class resolveClass(String className) throws EngineImportException {
        return this.engineImportService.resolveClass(className);
    }

    @Override
    public Method resolveMethod(Class clazz, String methodName, Class[] paramTypes, boolean[] allowEventBeanType, boolean[] allowEventBeanCollType) throws EngineImportException {
        return this.engineImportService.resolveMethod(clazz, methodName, paramTypes, allowEventBeanType, allowEventBeanCollType);
    }

    @Override
    public AggregationMethod makeCountAggregator(int agentInstanceId, int groupId, int aggregationId, boolean isIgnoreNull, boolean hasFilter) {
        if (!hasFilter) {
            if (isIgnoreNull) {
                return new AggregatorCountNonNull();
            }
            return new AggregatorCount();
        }
        if (isIgnoreNull) {
            return new AggregatorCountNonNullFilter();
        }
        return new AggregatorCountFilter();
    }

    @Override
    public AggregationFunctionFactory resolveAggregationFactory(String functionName) throws EngineImportUndefinedException, EngineImportException {
        return this.engineImportService.resolveAggregationFactory(functionName);
    }

    @Override
    public Pair<Class, EngineImportSingleRowDesc> resolveSingleRow(String functionName) throws EngineImportUndefinedException, EngineImportException {
        return this.engineImportService.resolveSingleRow(functionName);
    }

    @Override
    public AggregationMethod makeSumAggregator(int agentInstanceId, int groupId, int aggregationId, Class type, boolean hasFilter) {
        if (!hasFilter) {
            if (type == BigInteger.class) {
                return new AggregatorSumBigInteger();
            }
            if (type == BigDecimal.class) {
                return new AggregatorSumBigDecimal();
            }
            if (type == Long.class || type == Long.TYPE) {
                return new AggregatorSumLong();
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return new AggregatorSumInteger();
            }
            if (type == Double.class || type == Double.TYPE) {
                return new AggregatorSumDouble();
            }
            if (type == Float.class || type == Float.TYPE) {
                return new AggregatorSumFloat();
            }
            return new AggregatorSumNumInteger();
        }
        if (type == BigInteger.class) {
            return new AggregatorSumBigIntegerFilter();
        }
        if (type == BigDecimal.class) {
            return new AggregatorSumBigDecimalFilter();
        }
        if (type == Long.class || type == Long.TYPE) {
            return new AggregatorSumLongFilter();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new AggregatorSumIntegerFilter();
        }
        if (type == Double.class || type == Double.TYPE) {
            return new AggregatorSumDoubleFilter();
        }
        if (type == Float.class || type == Float.TYPE) {
            return new AggregatorSumFloatFilter();
        }
        return new AggregatorSumNumIntegerFilter();
    }

    @Override
    public Class getSumAggregatorType(Class type) {
        if (type == BigInteger.class) {
            return BigInteger.class;
        }
        if (type == BigDecimal.class) {
            return BigDecimal.class;
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.class;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.class;
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.class;
        }
        return Integer.class;
    }

    @Override
    public AggregationMethod makeDistinctAggregator(int agentInstanceId, int groupId, int aggregationId, AggregationMethod aggregationMethod, Class childType, boolean hasFilter) {
        if (hasFilter) {
            return new AggregatorDistinctValueFilter(aggregationMethod);
        }
        return new AggregatorDistinctValue(aggregationMethod);
    }

    @Override
    public AggregationMethod makeAvgAggregator(int agentInstanceId, int groupId, int aggregationId, Class type, boolean hasFilter) {
        if (hasFilter) {
            if (type == BigDecimal.class || type == BigInteger.class) {
                return new AggregatorAvgBigDecimalFilter(this.engineImportService.getDefaultMathContext());
            }
            return new AggregatorAvgFilter();
        }
        if (type == BigDecimal.class || type == BigInteger.class) {
            return new AggregatorAvgBigDecimal(this.engineImportService.getDefaultMathContext());
        }
        return new AggregatorAvg();
    }

    @Override
    public Class getAvgAggregatorType(Class type) {
        if (type == BigDecimal.class || type == BigInteger.class) {
            return BigDecimal.class;
        }
        return Double.class;
    }

    @Override
    public AggregationMethod makeAvedevAggregator(int agentInstanceId, int groupId, int aggregationId, boolean hasFilter) {
        if (!hasFilter) {
            return new AggregatorAvedev();
        }
        return new AggregatorAvedevFilter();
    }

    @Override
    public AggregationMethod makeMedianAggregator(int agentInstanceId, int groupId, int aggregationId, boolean hasFilter) {
        if (!hasFilter) {
            return new AggregatorMedian();
        }
        return new AggregatorMedianFilter();
    }

    @Override
    public AggregationMethod makeMinMaxAggregator(int agentInstanceId, int groupId, int aggregationId, MinMaxTypeEnum minMaxTypeEnum, Class targetType, boolean isHasDataWindows, boolean hasFilter) {
        if (!hasFilter) {
            if (!isHasDataWindows) {
                return new AggregatorMinMaxEver(minMaxTypeEnum, targetType);
            }
            return new AggregatorMinMax(minMaxTypeEnum, targetType);
        }
        if (!isHasDataWindows) {
            return new AggregatorMinMaxEverFilter(minMaxTypeEnum, targetType);
        }
        return new AggregatorMinMaxFilter(minMaxTypeEnum, targetType);
    }

    @Override
    public AggregationMethod makeStddevAggregator(int agentInstanceId, int groupId, int aggregationId, boolean hasFilter) {
        if (!hasFilter) {
            return new AggregatorStddev();
        }
        return new AggregatorStddevFilter();
    }

    @Override
    public AggregationMethod makeFirstEverValueAggregator(int agentInstanceId, int groupId, int aggregationId, Class type, boolean hasFilter) {
        if (hasFilter) {
            return new AggregatorFirstEverFilter(type);
        }
        return new AggregatorFirstEver(type);
    }

    @Override
    public AggregationMethod makeCountEverValueAggregator(int agentInstanceId, int groupId, int aggregationId, boolean hasFilter, boolean ignoreNulls) {
        if (!hasFilter) {
            if (ignoreNulls) {
                return new AggregatorCountEverNonNull();
            }
            return new AggregatorCountEver();
        }
        if (ignoreNulls) {
            return new AggregatorCountEverNonNullFilter();
        }
        return new AggregatorCountEverFilter();
    }

    @Override
    public AggregationMethod makeLastEverValueAggregator(int agentInstanceId, int groupId, int aggregationId, Class type, boolean hasFilter) {
        if (hasFilter) {
            return new AggregatorLastEverFilter(type);
        }
        return new AggregatorLastEver(type);
    }

    @Override
    public AggregationMethod makeRateAggregator(int agentInstanceId, int groupId, int aggregationId) {
        return new AggregatorRate();
    }

    @Override
    public AggregationMethod makeRateEverAggregator(int agentInstanceId, int groupId, int aggregationId, long interval) {
        return new AggregatorRateEver(interval, this.timeProvider);
    }

    @Override
    public AggregationMethod makeNthAggregator(int agentInstanceId, int groupId, int aggregationId, Class returnType, int size) {
        return new AggregatorNth(returnType, size);
    }

    @Override
    public AggregationMethod makeLeavingAggregator(int agentInstanceId, int groupId, int aggregationId) {
        return new AggregatorLeaving();
    }

    @Override
    public AggregationMethod[] newAggregators(AggregationMethodFactory[] prototypes, int agentInstanceId) {
        return this.newAggregatorsInternal(prototypes, agentInstanceId);
    }

    @Override
    public AggregationMethod[] newAggregators(AggregationMethodFactory[] prototypes, int agentInstanceId, Object groupKey, Object groupKeyBinding, AggregationGroupByRollupLevel groupByRollupLevel) {
        return this.newAggregatorsInternal(prototypes, agentInstanceId);
    }

    public AggregationMethod[] newAggregatorsInternal(AggregationMethodFactory[] prototypes, int agentInstanceId) {
        AggregationMethod[] row = new AggregationMethod[prototypes.length];
        for (int i = 0; i < prototypes.length; ++i) {
            row[i] = prototypes[i].make(this, agentInstanceId, -1, i);
        }
        return row;
    }

    @Override
    public long getCurrentRowCount(AggregationMethod[] aggregators, AggregationState[] groupStates) {
        return 0L;
    }

    @Override
    public void removeAggregators(int agentInstanceId, Object groupKey, Object groupKeyBinding, AggregationGroupByRollupLevel level) {
    }

    @Override
    public AggregationState[] newAccesses(int agentInstanceId, boolean isJoin, AggregationStateFactory[] accessAggSpecs) {
        return this.newAccessInternal(agentInstanceId, accessAggSpecs, isJoin, null);
    }

    @Override
    public AggregationState[] newAccesses(int agentInstanceId, boolean isJoin, AggregationStateFactory[] accessAggSpecs, Object groupKey, Object groupKeyBinding, AggregationGroupByRollupLevel groupByRollupLevel) {
        return this.newAccessInternal(agentInstanceId, accessAggSpecs, isJoin, groupKey);
    }

    private AggregationState[] newAccessInternal(int agentInstanceId, AggregationStateFactory[] accessAggSpecs, boolean isJoin, Object groupKey) {
        AggregationState[] row = new AggregationState[accessAggSpecs.length];
        int i = 0;
        for (AggregationStateFactory spec : accessAggSpecs) {
            row[i] = spec.createAccess(this, agentInstanceId, 0, i, isJoin, groupKey);
            ++i;
        }
        return row;
    }

    @Override
    public AggregationState makeAccessAggLinearNonJoin(int agentInstanceId, int groupId, int aggregationId, int streamNum) {
        return new AggregationStateImpl(streamNum);
    }

    @Override
    public AggregationState makeAccessAggLinearJoin(int agentInstanceId, int groupId, int aggregationId, int streamNum) {
        return new AggregationStateJoinImpl(streamNum);
    }

    @Override
    public AggregationState makeAccessAggSortedNonJoin(int agentInstanceId, int groupId, int aggregationId, AggregationStateSortedSpec spec) {
        return new AggregationStateSortedImpl(spec);
    }

    @Override
    public AggregationState makeAccessAggSortedJoin(int agentInstanceId, int groupId, int aggregationId, AggregationStateSortedSpec spec) {
        return new AggregationStateSortedJoin(spec);
    }

    @Override
    public AggregationState makeAccessAggMinMaxEver(int agentInstanceId, int groupId, int aggregationId, AggregationStateMinMaxByEverSpec spec) {
        return new AggregationStateMinMaxByEver(spec);
    }

    @Override
    public AggregationState makeAccessAggPlugin(int agentInstanceId, int groupId, int aggregationId, boolean join, PlugInAggregationMultiFunctionStateFactory providerFactory, Object groupKey) {
        PlugInAggregationMultiFunctionStateContext context = new PlugInAggregationMultiFunctionStateContext(agentInstanceId, groupKey);
        return providerFactory.makeAggregationState(context);
    }

    @Override
    public AggregationState makeCountMinSketch(int agentInstanceId, int groupId, int aggregationId, CountMinSketchSpec specification) {
        return new CountMinSketchAggState(CountMinSketchState.makeState(specification), specification.getAgent());
    }

    @Override
    public void destroyedAgentInstance(int agentInstanceId) {
    }

    @Override
    public EngineImportService getEngineImportService() {
        return this.engineImportService;
    }

    @Override
    public Object getCriteriaKeyBinding(ExprEvaluator[] evaluators) {
        return null;
    }

    @Override
    public Object getGroupKeyBinding(ExprNode[] groupKeyExpressions, AggregationGroupByRollupDesc groupByRollupDesc) {
        return null;
    }

    @Override
    public Object getGroupKeyBinding(AggregationLocalGroupByPlan localGroupByPlan) {
        return null;
    }
}

