/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateAll;
import com.espertech.esper.event.EventBeanUtility;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;

public class ResultSetProcessorAggregateAllOutputAllHelper {
    private final ResultSetProcessorAggregateAll processor;
    private final Deque<EventBean> eventsOld = new ArrayDeque<EventBean>(2);
    private final Deque<EventBean> eventsNew = new ArrayDeque<EventBean>(2);

    public ResultSetProcessorAggregateAllOutputAllHelper(ResultSetProcessorAggregateAll processor) {
        this.processor = processor;
    }

    public void processView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic) {
        UniformPair<EventBean[]> pair = this.processor.processViewResult(newData, oldData, isGenerateSynthetic);
        this.apply(pair);
    }

    public void processJoin(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isGenerateSynthetic) {
        UniformPair<EventBean[]> pair = this.processor.processJoinResult(newEvents, oldEvents, isGenerateSynthetic);
        this.apply(pair);
    }

    public UniformPair<EventBean[]> output() {
        EventBean[] oldEvents = EventBeanUtility.toArrayNullIfEmpty(this.eventsOld);
        EventBean[] newEvents = EventBeanUtility.toArrayNullIfEmpty(this.eventsNew);
        UniformPair<EventBean[]> result = null;
        if (oldEvents != null || newEvents != null) {
            result = new UniformPair<EventBean[]>(newEvents, oldEvents);
        }
        this.eventsOld.clear();
        this.eventsNew.clear();
        return result;
    }

    private void apply(UniformPair<EventBean[]> pair) {
        if (pair == null) {
            return;
        }
        EventBeanUtility.addToCollection(pair.getFirst(), this.eventsNew);
        EventBeanUtility.addToCollection(pair.getSecond(), this.eventsOld);
    }
}

