/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetAggregateGroupedIterator;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateGroupedFactory;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateGroupedOutputAllHelper;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateGroupedOutputLastHelper;
import com.espertech.esper.epl.core.ResultSetProcessorUtil;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.view.OutputConditionPolled;
import com.espertech.esper.epl.view.OutputConditionPolledFactory;
import com.espertech.esper.view.Viewable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetProcessorAggregateGrouped
implements ResultSetProcessor,
AggregationRowRemovedCallback {
    private static final Log log = LogFactory.getLog(ResultSetProcessorAggregateGrouped.class);
    protected final ResultSetProcessorAggregateGroupedFactory prototype;
    private final SelectExprProcessor selectExprProcessor;
    private final OrderByProcessor orderByProcessor;
    protected final AggregationService aggregationService;
    protected AgentInstanceContext agentInstanceContext;
    protected final EventBean[] eventsPerStreamOneStream = new EventBean[1];
    private final Map<Object, EventBean[]> eventGroupReps = new HashMap<Object, EventBean[]>();
    private final Map<Object, EventBean[]> workCollection = new LinkedHashMap<Object, EventBean[]>();
    private final Map<Object, EventBean[]> workCollectionTwo = new LinkedHashMap<Object, EventBean[]>();
    private final Map<Object, EventBean[]> newGenerators = new HashMap<Object, EventBean[]>();
    private final Map<Object, EventBean[]> oldGenerators = new HashMap<Object, EventBean[]>();
    private final Map<Object, OutputConditionPolled> outputState = new HashMap<Object, OutputConditionPolled>();
    private ResultSetProcessorAggregateGroupedOutputLastHelper outputLastHelper;
    private ResultSetProcessorAggregateGroupedOutputAllHelper outputAllHelper;

    public ResultSetProcessorAggregateGrouped(ResultSetProcessorAggregateGroupedFactory prototype, SelectExprProcessor selectExprProcessor, OrderByProcessor orderByProcessor, AggregationService aggregationService, AgentInstanceContext agentInstanceContext) {
        this.prototype = prototype;
        this.selectExprProcessor = selectExprProcessor;
        this.orderByProcessor = orderByProcessor;
        this.aggregationService = aggregationService;
        this.agentInstanceContext = agentInstanceContext;
        aggregationService.setRemovedCallback(this);
        if (prototype.isOutputLast()) {
            this.outputLastHelper = new ResultSetProcessorAggregateGroupedOutputLastHelper(this);
        } else if (prototype.isOutputAll()) {
            this.outputAllHelper = new ResultSetProcessorAggregateGroupedOutputAllHelper(this);
        }
    }

    @Override
    public void setAgentInstanceContext(AgentInstanceContext agentInstanceContext) {
        this.agentInstanceContext = agentInstanceContext;
    }

    @Override
    public EventType getResultEventType() {
        return this.prototype.getResultEventType();
    }

    @Override
    public void applyViewResult(EventBean[] newData, EventBean[] oldData) {
        Object mk;
        int i$;
        int len$;
        EventBean[] arr$;
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            arr$ = newData;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                EventBean aNewData;
                eventsPerStream[0] = aNewData = arr$[i$];
                mk = this.generateGroupKey(eventsPerStream, true);
                this.aggregationService.applyEnter(eventsPerStream, mk, this.agentInstanceContext);
            }
        }
        if (oldData != null) {
            arr$ = oldData;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                EventBean anOldData;
                eventsPerStream[0] = anOldData = arr$[i$];
                mk = this.generateGroupKey(eventsPerStream, false);
                this.aggregationService.applyLeave(eventsPerStream, mk, this.agentInstanceContext);
            }
        }
    }

    @Override
    public void applyJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents) {
        Object mk;
        if (!newEvents.isEmpty()) {
            for (MultiKey<EventBean> eventsPerStream : newEvents) {
                mk = this.generateGroupKey(eventsPerStream.getArray(), true);
                this.aggregationService.applyEnter(eventsPerStream.getArray(), mk, this.agentInstanceContext);
            }
        }
        if (oldEvents != null && !oldEvents.isEmpty()) {
            for (MultiKey<EventBean> eventsPerStream : oldEvents) {
                mk = this.generateGroupKey(eventsPerStream.getArray(), false);
                this.aggregationService.applyLeave(eventsPerStream.getArray(), mk, this.agentInstanceContext);
            }
        }
    }

    @Override
    public UniformPair<EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        int count;
        Object[] newDataGroupByKeys = this.generateGroupKeys(newEvents, true);
        Object[] oldDataGroupByKeys = this.generateGroupKeys(oldEvents, false);
        if (this.prototype.isUnidirectional()) {
            this.clear();
        }
        if (!newEvents.isEmpty()) {
            count = 0;
            for (MultiKey<EventBean> eventsPerStream : newEvents) {
                this.aggregationService.applyEnter(eventsPerStream.getArray(), newDataGroupByKeys[count], this.agentInstanceContext);
                ++count;
            }
        }
        if (!oldEvents.isEmpty()) {
            count = 0;
            for (MultiKey<EventBean> eventsPerStream : oldEvents) {
                this.aggregationService.applyLeave(eventsPerStream.getArray(), oldDataGroupByKeys[count], this.agentInstanceContext);
                ++count;
            }
        }
        EventBean[] selectOldEvents = null;
        if (this.prototype.isSelectRStream()) {
            selectOldEvents = this.generateOutputEventsJoin(oldEvents, oldDataGroupByKeys, this.oldGenerators, false, isSynthesize);
        }
        if ((selectNewEvents = this.generateOutputEventsJoin(newEvents, newDataGroupByKeys, this.newGenerators, true, isSynthesize)) != null || selectOldEvents != null) {
            return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    @Override
    public UniformPair<EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        int i;
        Object[] newDataGroupByKeys = this.generateGroupKeys(newData, true);
        Object[] oldDataGroupByKeys = this.generateGroupKeys(oldData, false);
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                this.aggregationService.applyEnter(eventsPerStream, newDataGroupByKeys[i], this.agentInstanceContext);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                this.aggregationService.applyLeave(eventsPerStream, oldDataGroupByKeys[i], this.agentInstanceContext);
            }
        }
        EventBean[] selectOldEvents = null;
        if (this.prototype.isSelectRStream()) {
            selectOldEvents = this.generateOutputEventsView(oldData, oldDataGroupByKeys, this.oldGenerators, false, isSynthesize);
        }
        if ((selectNewEvents = this.generateOutputEventsView(newData, newDataGroupByKeys, this.newGenerators, true, isSynthesize)) != null || selectOldEvents != null) {
            return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    private EventBean[] generateOutputEventsView(EventBean[] outputEvents, Object[] groupByKeys, Map<Object, EventBean[]> generators, boolean isNewData, boolean isSynthesize) {
        if (outputEvents == null) {
            return null;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] events = new EventBean[outputEvents.length];
        Object[] keys = new Object[outputEvents.length];
        EventBean[][] currentGenerators = null;
        if (this.prototype.isSorting()) {
            currentGenerators = new EventBean[outputEvents.length][];
        }
        int countOutputRows = 0;
        for (int countInputRows = 0; countInputRows < outputEvents.length; ++countInputRows) {
            Boolean result;
            this.aggregationService.setCurrentAccess(groupByKeys[countInputRows], this.agentInstanceContext.getAgentInstanceId(), null);
            eventsPerStream[0] = outputEvents[countInputRows];
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            events[countOutputRows] = this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext);
            keys[countOutputRows] = groupByKeys[countInputRows];
            if (this.prototype.isSorting()) {
                EventBean[] currentEventsPerStream = new EventBean[]{outputEvents[countInputRows]};
                generators.put(keys[countOutputRows], currentEventsPerStream);
                currentGenerators[countOutputRows] = currentEventsPerStream;
            }
            ++countOutputRows;
        }
        if (countOutputRows != events.length) {
            if (countOutputRows == 0) {
                return null;
            }
            EventBean[] outEvents = new EventBean[countOutputRows];
            System.arraycopy(events, 0, outEvents, 0, countOutputRows);
            events = outEvents;
            if (this.prototype.isSorting()) {
                Object[] outKeys = new Object[countOutputRows];
                System.arraycopy(keys, 0, outKeys, 0, countOutputRows);
                keys = outKeys;
                EventBean[][] outGens = new EventBean[countOutputRows][];
                System.arraycopy(currentGenerators, 0, outGens, 0, countOutputRows);
                currentGenerators = outGens;
            }
        }
        if (this.prototype.isSorting()) {
            events = this.orderByProcessor.sort(events, currentGenerators, keys, isNewData, this.agentInstanceContext);
        }
        return events;
    }

    protected Object[] generateGroupKeys(Set<MultiKey<EventBean>> resultSet, boolean isNewData) {
        if (resultSet.isEmpty()) {
            return null;
        }
        Object[] keys = new Object[resultSet.size()];
        int count = 0;
        for (MultiKey<EventBean> eventsPerStream : resultSet) {
            keys[count] = this.generateGroupKey(eventsPerStream.getArray(), isNewData);
            ++count;
        }
        return keys;
    }

    protected Object[] generateGroupKeys(EventBean[] events, boolean isNewData) {
        if (events == null) {
            return null;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        Object[] keys = new Object[events.length];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            keys[i] = this.generateGroupKey(eventsPerStream, isNewData);
        }
        return keys;
    }

    protected Object generateGroupKey(EventBean[] eventsPerStream, boolean isNewData) {
        if (this.prototype.getGroupKeyNode() != null) {
            return this.prototype.getGroupKeyNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext);
        }
        Object[] keys = new Object[this.prototype.getGroupKeyNodes().length];
        int count = 0;
        for (ExprEvaluator exprNode : this.prototype.getGroupKeyNodes()) {
            keys[count] = exprNode.evaluate(eventsPerStream, isNewData, this.agentInstanceContext);
            ++count;
        }
        return new MultiKeyUntyped(keys);
    }

    private EventBean[] generateOutputEventsJoin(Set<MultiKey<EventBean>> resultSet, Object[] groupByKeys, Map<Object, EventBean[]> generators, boolean isNewData, boolean isSynthesize) {
        if (resultSet.isEmpty()) {
            return null;
        }
        EventBean[] events = new EventBean[resultSet.size()];
        Object[] keys = new Object[resultSet.size()];
        EventBean[][] currentGenerators = null;
        if (this.prototype.isSorting()) {
            currentGenerators = new EventBean[resultSet.size()][];
        }
        int countOutputRows = 0;
        int countInputRows = -1;
        for (MultiKey<EventBean> row : resultSet) {
            Boolean result;
            EventBean[] eventsPerStream = row.getArray();
            this.aggregationService.setCurrentAccess(groupByKeys[++countInputRows], this.agentInstanceContext.getAgentInstanceId(), null);
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            events[countOutputRows] = this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext);
            keys[countOutputRows] = groupByKeys[countInputRows];
            if (this.prototype.isSorting()) {
                generators.put(keys[countOutputRows], eventsPerStream);
                currentGenerators[countOutputRows] = eventsPerStream;
            }
            ++countOutputRows;
        }
        if (countOutputRows != events.length) {
            if (countOutputRows == 0) {
                return null;
            }
            EventBean[] outEvents = new EventBean[countOutputRows];
            System.arraycopy(events, 0, outEvents, 0, countOutputRows);
            events = outEvents;
            if (this.prototype.isSorting()) {
                Object[] outKeys = new Object[countOutputRows];
                System.arraycopy(keys, 0, outKeys, 0, countOutputRows);
                keys = outKeys;
                EventBean[][] outGens = new EventBean[countOutputRows][];
                System.arraycopy(currentGenerators, 0, outGens, 0, countOutputRows);
                currentGenerators = outGens;
            }
        }
        if (this.prototype.isSorting()) {
            events = this.orderByProcessor.sort(events, currentGenerators, keys, isNewData, this.agentInstanceContext);
        }
        return events;
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        if (!this.prototype.isHistoricalOnly()) {
            return this.obtainIterator(parent);
        }
        this.aggregationService.clearResults(this.agentInstanceContext);
        Iterator<EventBean> it = parent.iterator();
        EventBean[] eventsPerStream = new EventBean[1];
        while (it.hasNext()) {
            eventsPerStream[0] = it.next();
            Object groupKey = this.generateGroupKey(eventsPerStream, true);
            this.aggregationService.applyEnter(eventsPerStream, groupKey, this.agentInstanceContext);
        }
        ArrayDeque<EventBean> deque = ResultSetProcessorUtil.iteratorToDeque(this.obtainIterator(parent));
        this.aggregationService.clearResults(this.agentInstanceContext);
        return deque.iterator();
    }

    private Iterator<EventBean> obtainIterator(Viewable parent) {
        if (this.orderByProcessor == null) {
            return new ResultSetAggregateGroupedIterator(parent.iterator(), this, this.aggregationService, this.agentInstanceContext);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        ArrayList<EventBean> outgoingEvents = new ArrayList<EventBean>();
        ArrayList<Object> orderKeys = new ArrayList<Object>();
        Iterator<EventBean> i$ = parent.iterator();
        while (i$.hasNext()) {
            Boolean pass;
            EventBean candidate;
            eventsPerStream[0] = candidate = i$.next();
            Object groupKey = this.generateGroupKey(eventsPerStream, true);
            this.aggregationService.setCurrentAccess(groupKey, this.agentInstanceContext.getAgentInstanceId(), null);
            if (this.prototype.getOptionalHavingNode() != null && ((pass = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, true, this.agentInstanceContext)) == null || !pass.booleanValue())) continue;
            outgoingEvents.add(this.selectExprProcessor.process(eventsPerStream, true, true, this.agentInstanceContext));
            Object orderKey = this.orderByProcessor.getSortKey(eventsPerStream, true, this.agentInstanceContext);
            orderKeys.add(orderKey);
        }
        EventBean[] outgoingEventsArr = outgoingEvents.toArray(new EventBean[outgoingEvents.size()]);
        Object[] orderKeysArr = orderKeys.toArray(new Object[orderKeys.size()]);
        EventBean[] orderedEvents = this.orderByProcessor.sort(outgoingEventsArr, orderKeysArr, this.agentInstanceContext);
        return new ArrayEventIterator(orderedEvents);
    }

    public SelectExprProcessor getSelectExprProcessor() {
        return this.selectExprProcessor;
    }

    public ExprEvaluator getOptionalHavingNode() {
        return this.prototype.getOptionalHavingNode();
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        Object[] groupByKeys = this.generateGroupKeys(joinSet, true);
        EventBean[] result = this.generateOutputEventsJoin(joinSet, groupByKeys, this.newGenerators, true, true);
        return new ArrayEventIterator(result);
    }

    @Override
    public void clear() {
        this.aggregationService.clearResults(this.agentInstanceContext);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UniformPair<EventBean[]> processOutputLimitedJoin(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        void var9_51;
        if (outputLimitLimitType == OutputLimitLimitType.DEFAULT) {
            void var9_29;
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.prototype.isSelectRStream()) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<Object> newEventsSortKey = null;
            LinkedList<Object> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<Object>();
                if (this.prototype.isSelectRStream()) {
                    oldEventsSortKey = new LinkedList<Object>();
                }
            }
            for (UniformPair<Set<MultiKey<EventBean>>> uniformPair : joinEventsSet) {
                int count;
                Set<MultiKey<EventBean>> newData = uniformPair.getFirst();
                Set<MultiKey<EventBean>> oldData = uniformPair.getSecond();
                Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
                Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                if (this.prototype.isUnidirectional()) {
                    this.clear();
                }
                if (newData != null) {
                    count = 0;
                    for (MultiKey<EventBean> aNewData : newData) {
                        this.aggregationService.applyEnter(aNewData.getArray(), newDataMultiKey[count], this.agentInstanceContext);
                        ++count;
                    }
                }
                if (oldData != null) {
                    count = 0;
                    for (MultiKey<EventBean> anOldData : oldData) {
                        this.aggregationService.applyLeave(anOldData.getArray(), oldDataMultiKey[count], this.agentInstanceContext);
                        ++count;
                    }
                }
                if (this.prototype.isSelectRStream()) {
                    this.generateOutputBatchedJoin(oldData, oldDataMultiKey, false, generateSynthetic, oldEvents, oldEventsSortKey);
                }
                this.generateOutputBatchedJoin(newData, newDataMultiKey, true, generateSynthetic, newEvents, newEventsSortKey);
            }
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            Object var9_25 = null;
            if (this.prototype.isSelectRStream()) {
                EventBean[] eventBeanArray;
                EventBean[] eventBeanArray2 = eventBeanArray = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
                if (this.prototype.isSelectRStream()) {
                    void var9_27;
                    Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                    EventBean[] eventBeanArray = this.orderByProcessor.sort((EventBean[])var9_27, sortKeysOld, this.agentInstanceContext);
                }
            }
            if (newEventsArr == null && var9_29 == null) {
                return null;
            }
            return new UniformPair<void>((void)newEventsArr, var9_29);
        }
        if (outputLimitLimitType == OutputLimitLimitType.ALL) {
            void var9_37;
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.prototype.isSelectRStream()) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<Object> newEventsSortKey = null;
            LinkedList<Object> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<Object>();
                if (this.prototype.isSelectRStream()) {
                    oldEventsSortKey = new LinkedList<Object>();
                }
            }
            this.workCollection.clear();
            for (UniformPair<Set<MultiKey<EventBean>>> uniformPair : joinEventsSet) {
                int count;
                Set<MultiKey<EventBean>> newData = uniformPair.getFirst();
                Set<MultiKey<EventBean>> oldData = uniformPair.getSecond();
                Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
                Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                if (this.prototype.isUnidirectional()) {
                    this.clear();
                }
                if (newData != null) {
                    count = 0;
                    for (MultiKey<EventBean> aNewData : newData) {
                        Object mk = newDataMultiKey[count];
                        this.aggregationService.applyEnter(aNewData.getArray(), mk, this.agentInstanceContext);
                        ++count;
                        this.workCollection.put(mk, aNewData.getArray());
                        this.eventGroupReps.put(mk, aNewData.getArray());
                    }
                }
                if (oldData != null) {
                    count = 0;
                    for (MultiKey<EventBean> anOldData : oldData) {
                        this.aggregationService.applyLeave(anOldData.getArray(), oldDataMultiKey[count], this.agentInstanceContext);
                        ++count;
                    }
                }
                if (this.prototype.isSelectRStream()) {
                    this.generateOutputBatchedJoin(oldData, oldDataMultiKey, false, generateSynthetic, oldEvents, oldEventsSortKey);
                }
                this.generateOutputBatchedJoin(newData, newDataMultiKey, true, generateSynthetic, newEvents, newEventsSortKey);
            }
            for (Map.Entry entry : this.eventGroupReps.entrySet()) {
                if (this.workCollection.containsKey(entry.getKey())) continue;
                this.workCollectionTwo.put(entry.getKey(), (EventBean[])entry.getValue());
                this.generateOutputBatchedArr(this.workCollectionTwo, true, generateSynthetic, newEvents, newEventsSortKey);
                this.workCollectionTwo.clear();
            }
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            Object var9_33 = null;
            if (this.prototype.isSelectRStream()) {
                EventBean[] eventBeanArray;
                EventBean[] eventBeanArray3 = eventBeanArray = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
                if (this.prototype.isSelectRStream()) {
                    void var9_35;
                    Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                    EventBean[] eventBeanArray = this.orderByProcessor.sort((EventBean[])var9_35, sortKeysOld, this.agentInstanceContext);
                }
            }
            if (newEventsArr == null && var9_37 == null) {
                return null;
            }
            return new UniformPair<void>((void)newEventsArr, var9_37);
        }
        if (outputLimitLimitType == OutputLimitLimitType.FIRST) {
            void var9_45;
            Set<MultiKey<EventBean>> oldData;
            Set<MultiKey<EventBean>> newData;
            ArrayList<EventBean> resultNewEvents = new ArrayList<EventBean>();
            ArrayList<Object> resultNewSortKeys = null;
            ArrayList resultOldEvents = null;
            ArrayList resultOldSortKeys = null;
            if (this.orderByProcessor != null) {
                resultNewSortKeys = new ArrayList<Object>();
            }
            if (this.prototype.isSelectRStream()) {
                resultOldEvents = new ArrayList();
                resultOldSortKeys = new ArrayList();
            }
            this.workCollection.clear();
            if (this.prototype.getOptionalHavingNode() == null) {
                for (UniformPair<Set<MultiKey<EventBean>>> uniformPair : joinEventsSet) {
                    boolean pass;
                    OutputConditionPolled outputStateGroup;
                    Object mk;
                    int count;
                    newData = uniformPair.getFirst();
                    oldData = uniformPair.getSecond();
                    Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
                    Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                    if (newData != null) {
                        count = 0;
                        for (MultiKey<EventBean> aNewData : newData) {
                            mk = newDataMultiKey[count];
                            outputStateGroup = this.outputState.get(mk);
                            if (outputStateGroup == null) {
                                try {
                                    outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                                }
                                catch (ExprValidationException e) {
                                    log.error((Object)("Error starting output limit for group for statement '" + this.agentInstanceContext.getStatementContext().getStatementName() + "'"));
                                }
                                this.outputState.put(newDataMultiKey[count], outputStateGroup);
                            }
                            if (pass = outputStateGroup.updateOutputCondition(1, 0)) {
                                this.workCollection.put(mk, aNewData.getArray());
                            }
                            this.aggregationService.applyEnter(aNewData.getArray(), mk, this.agentInstanceContext);
                            ++count;
                        }
                    }
                    if (oldData != null) {
                        count = 0;
                        for (MultiKey<EventBean> aOldData : oldData) {
                            mk = oldDataMultiKey[count];
                            outputStateGroup = this.outputState.get(mk);
                            if (outputStateGroup == null) {
                                try {
                                    outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                                }
                                catch (ExprValidationException e) {
                                    log.error((Object)("Error starting output limit for group for statement '" + this.agentInstanceContext.getStatementContext().getStatementName() + "'"));
                                }
                                this.outputState.put(oldDataMultiKey[count], outputStateGroup);
                            }
                            if (pass = outputStateGroup.updateOutputCondition(0, 1)) {
                                this.workCollection.put(mk, aOldData.getArray());
                            }
                            this.aggregationService.applyLeave(aOldData.getArray(), mk, this.agentInstanceContext);
                            ++count;
                        }
                    }
                    this.generateOutputBatchedArr(this.workCollection, false, generateSynthetic, resultNewEvents, resultNewSortKeys);
                }
            } else {
                for (UniformPair<Set<MultiKey<EventBean>>> uniformPair : joinEventsSet) {
                    boolean pass;
                    OutputConditionPolled outputStateGroup;
                    Boolean result;
                    Object mk;
                    int count;
                    newData = uniformPair.getFirst();
                    oldData = uniformPair.getSecond();
                    Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
                    Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                    if (newData != null) {
                        count = 0;
                        for (MultiKey<EventBean> aNewData : newData) {
                            mk = newDataMultiKey[count];
                            this.aggregationService.applyEnter(aNewData.getArray(), mk, this.agentInstanceContext);
                            ++count;
                        }
                    }
                    if (oldData != null) {
                        count = 0;
                        for (MultiKey<EventBean> aOldData : oldData) {
                            mk = oldDataMultiKey[count];
                            this.aggregationService.applyLeave(aOldData.getArray(), mk, this.agentInstanceContext);
                            ++count;
                        }
                    }
                    if (newData != null) {
                        count = 0;
                        for (MultiKey<EventBean> aNewData : newData) {
                            mk = newDataMultiKey[count];
                            this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceId(), null);
                            result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(aNewData.getArray(), true, this.agentInstanceContext);
                            if (result == null || !result.booleanValue()) {
                                ++count;
                                continue;
                            }
                            outputStateGroup = this.outputState.get(mk);
                            if (outputStateGroup == null) {
                                try {
                                    outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                                }
                                catch (ExprValidationException e) {
                                    log.error((Object)("Error starting output limit for group for statement '" + this.agentInstanceContext.getStatementContext().getStatementName() + "'"));
                                }
                                this.outputState.put(mk, outputStateGroup);
                            }
                            if (pass = outputStateGroup.updateOutputCondition(1, 0)) {
                                this.workCollection.put(mk, aNewData.getArray());
                            }
                            ++count;
                        }
                    }
                    if (oldData != null) {
                        count = 0;
                        for (MultiKey<EventBean> aOldData : oldData) {
                            mk = oldDataMultiKey[count];
                            this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceId(), null);
                            result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(aOldData.getArray(), true, this.agentInstanceContext);
                            if (result == null || !result.booleanValue()) {
                                ++count;
                                continue;
                            }
                            outputStateGroup = this.outputState.get(mk);
                            if (outputStateGroup == null) {
                                try {
                                    outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                                }
                                catch (ExprValidationException e) {
                                    log.error((Object)("Error starting output limit for group for statement '" + this.agentInstanceContext.getStatementContext().getStatementName() + "'"));
                                }
                                this.outputState.put(mk, outputStateGroup);
                            }
                            if (!(pass = outputStateGroup.updateOutputCondition(0, 1))) continue;
                            this.workCollection.put(mk, aOldData.getArray());
                        }
                    }
                    this.generateOutputBatchedArr(this.workCollection, false, generateSynthetic, resultNewEvents, resultNewSortKeys);
                }
            }
            EventBean[] newEventsArr = null;
            Object var9_41 = null;
            if (!resultNewEvents.isEmpty()) {
                newEventsArr = resultNewEvents.toArray(new EventBean[resultNewEvents.size()]);
            }
            if (resultOldEvents != null && !resultOldEvents.isEmpty()) {
                EventBean[] eventBeanArray = resultOldEvents.toArray(new EventBean[resultOldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                Object[] sortKeysNew = resultNewSortKeys.isEmpty() ? null : resultNewSortKeys.toArray(new Object[resultNewSortKeys.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
                if (this.prototype.isSelectRStream()) {
                    void var9_43;
                    Object[] sortKeysOld = resultOldSortKeys.isEmpty() ? null : resultOldSortKeys.toArray(new Object[resultOldSortKeys.size()]);
                    EventBean[] eventBeanArray = this.orderByProcessor.sort((EventBean[])var9_43, sortKeysOld, this.agentInstanceContext);
                }
            }
            if (newEventsArr == null && var9_45 == null) {
                return null;
            }
            return new UniformPair<void>((void)newEventsArr, var9_45);
        }
        LinkedHashMap<Object, EventBean> lastPerGroupNew = new LinkedHashMap<Object, EventBean>();
        LinkedHashMap<Object, EventBean> lastPerGroupOld = null;
        if (this.prototype.isSelectRStream()) {
            lastPerGroupOld = new LinkedHashMap<Object, EventBean>();
        }
        LinkedHashMap<Object, Object> newEventsSortKey = null;
        LinkedHashMap<Object, Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedHashMap<Object, Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedHashMap<Object, Object>();
            }
        }
        for (UniformPair<Set<MultiKey<EventBean>>> uniformPair : joinEventsSet) {
            int count;
            Set<MultiKey<EventBean>> newData = uniformPair.getFirst();
            Set<MultiKey<EventBean>> oldData = uniformPair.getSecond();
            Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
            Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
            if (this.prototype.isUnidirectional()) {
                this.clear();
            }
            if (newData != null) {
                count = 0;
                for (MultiKey<EventBean> aNewData : newData) {
                    Object mk = newDataMultiKey[count];
                    this.aggregationService.applyEnter(aNewData.getArray(), mk, this.agentInstanceContext);
                    ++count;
                }
            }
            if (oldData != null) {
                count = 0;
                for (MultiKey<EventBean> anOldData : oldData) {
                    this.workCollection.put(oldDataMultiKey[count], anOldData.getArray());
                    this.aggregationService.applyLeave(anOldData.getArray(), oldDataMultiKey[count], this.agentInstanceContext);
                    ++count;
                }
            }
            if (this.prototype.isSelectRStream()) {
                this.generateOutputBatchedJoin(oldData, oldDataMultiKey, false, generateSynthetic, lastPerGroupOld, oldEventsSortKey);
            }
            this.generateOutputBatchedJoin(newData, newDataMultiKey, false, generateSynthetic, lastPerGroupNew, newEventsSortKey);
        }
        EventBean[] newEventsArr = lastPerGroupNew.isEmpty() ? null : lastPerGroupNew.values().toArray(new EventBean[lastPerGroupNew.size()]);
        Object var9_47 = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray;
            EventBean[] eventBeanArray4 = eventBeanArray = lastPerGroupOld.isEmpty() ? null : lastPerGroupOld.values().toArray(new EventBean[lastPerGroupOld.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.values().toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                void var9_49;
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.values().toArray(new Object[oldEventsSortKey.size()]);
                EventBean[] eventBeanArray = this.orderByProcessor.sort((EventBean[])var9_49, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && var9_51 == null) {
            return null;
        }
        return new UniformPair<void>((void)newEventsArr, var9_51);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UniformPair<EventBean[]> processOutputLimitedView(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        void var9_51;
        if (outputLimitLimitType == OutputLimitLimitType.DEFAULT) {
            void var9_29;
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.prototype.isSelectRStream()) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<Object> newEventsSortKey = null;
            LinkedList<Object> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<Object>();
                if (this.prototype.isSelectRStream()) {
                    oldEventsSortKey = new LinkedList<Object>();
                }
            }
            for (UniformPair<EventBean[]> uniformPair : viewEventsList) {
                int i$;
                int len$;
                EventBean[] arr$;
                int count;
                EventBean[] newData = uniformPair.getFirst();
                EventBean[] oldData = uniformPair.getSecond();
                Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
                Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                if (newData != null) {
                    count = 0;
                    arr$ = newData;
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        EventBean aNewData;
                        this.eventsPerStreamOneStream[0] = aNewData = arr$[i$];
                        this.aggregationService.applyEnter(this.eventsPerStreamOneStream, newDataMultiKey[count], this.agentInstanceContext);
                        ++count;
                    }
                }
                if (oldData != null) {
                    count = 0;
                    arr$ = oldData;
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        EventBean anOldData;
                        this.eventsPerStreamOneStream[0] = anOldData = arr$[i$];
                        this.aggregationService.applyLeave(this.eventsPerStreamOneStream, oldDataMultiKey[count], this.agentInstanceContext);
                        ++count;
                    }
                }
                if (this.prototype.isSelectRStream()) {
                    this.generateOutputBatchedView(oldData, oldDataMultiKey, false, generateSynthetic, oldEvents, oldEventsSortKey);
                }
                this.generateOutputBatchedView(newData, newDataMultiKey, true, generateSynthetic, newEvents, newEventsSortKey);
            }
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            Object var9_25 = null;
            if (this.prototype.isSelectRStream()) {
                EventBean[] eventBeanArray;
                EventBean[] eventBeanArray2 = eventBeanArray = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
                if (this.prototype.isSelectRStream()) {
                    void var9_27;
                    Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                    EventBean[] eventBeanArray = this.orderByProcessor.sort((EventBean[])var9_27, sortKeysOld, this.agentInstanceContext);
                }
            }
            if (newEventsArr == null && var9_29 == null) {
                return null;
            }
            return new UniformPair<void>((void)newEventsArr, var9_29);
        }
        if (outputLimitLimitType == OutputLimitLimitType.ALL) {
            void var9_37;
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.prototype.isSelectRStream()) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<Object> newEventsSortKey = null;
            LinkedList<Object> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<Object>();
                if (this.prototype.isSelectRStream()) {
                    oldEventsSortKey = new LinkedList<Object>();
                }
            }
            this.workCollection.clear();
            for (UniformPair<EventBean[]> uniformPair : viewEventsList) {
                int count;
                EventBean[] newData = uniformPair.getFirst();
                EventBean[] oldData = uniformPair.getSecond();
                Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
                Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                EventBean[] eventsPerStream = new EventBean[1];
                if (newData != null) {
                    count = 0;
                    for (EventBean aNewData : newData) {
                        Object mk = newDataMultiKey[count];
                        eventsPerStream[0] = aNewData;
                        this.aggregationService.applyEnter(eventsPerStream, mk, this.agentInstanceContext);
                        ++count;
                        this.workCollection.put(mk, eventsPerStream);
                        this.eventGroupReps.put(mk, new EventBean[]{aNewData});
                    }
                }
                if (oldData != null) {
                    count = 0;
                    EventBean[] arr$ = oldData;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        EventBean anOldData;
                        eventsPerStream[0] = anOldData = arr$[i$];
                        this.aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[count], this.agentInstanceContext);
                        ++count;
                    }
                }
                if (this.prototype.isSelectRStream()) {
                    this.generateOutputBatchedView(oldData, oldDataMultiKey, false, generateSynthetic, oldEvents, oldEventsSortKey);
                }
                this.generateOutputBatchedView(newData, newDataMultiKey, true, generateSynthetic, newEvents, newEventsSortKey);
            }
            for (Map.Entry entry : this.eventGroupReps.entrySet()) {
                if (this.workCollection.containsKey(entry.getKey())) continue;
                this.workCollectionTwo.put(entry.getKey(), (EventBean[])entry.getValue());
                this.generateOutputBatchedArr(this.workCollectionTwo, true, generateSynthetic, newEvents, newEventsSortKey);
                this.workCollectionTwo.clear();
            }
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            Object var9_33 = null;
            if (this.prototype.isSelectRStream()) {
                EventBean[] eventBeanArray;
                EventBean[] eventBeanArray3 = eventBeanArray = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
                if (this.prototype.isSelectRStream()) {
                    void var9_35;
                    Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                    EventBean[] eventBeanArray = this.orderByProcessor.sort((EventBean[])var9_35, sortKeysOld, this.agentInstanceContext);
                }
            }
            if (newEventsArr == null && var9_37 == null) {
                return null;
            }
            return new UniformPair<void>((void)newEventsArr, var9_37);
        }
        if (outputLimitLimitType == OutputLimitLimitType.FIRST) {
            void var9_45;
            EventBean[] oldData;
            EventBean[] newData;
            ArrayList<EventBean> resultNewEvents = new ArrayList<EventBean>();
            ArrayList<Object> resultNewSortKeys = null;
            ArrayList resultOldEvents = null;
            ArrayList resultOldSortKeys = null;
            if (this.orderByProcessor != null) {
                resultNewSortKeys = new ArrayList<Object>();
            }
            if (this.prototype.isSelectRStream()) {
                resultOldEvents = new ArrayList();
                resultOldSortKeys = new ArrayList();
            }
            this.workCollection.clear();
            if (this.prototype.getOptionalHavingNode() == null) {
                for (UniformPair<EventBean[]> uniformPair : viewEventsList) {
                    boolean pass;
                    OutputConditionPolled outputStateGroup;
                    Object mk;
                    int i;
                    newData = uniformPair.getFirst();
                    oldData = uniformPair.getSecond();
                    Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
                    Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                    if (newData != null) {
                        for (i = 0; i < newData.length; ++i) {
                            this.eventsPerStreamOneStream[0] = newData[i];
                            mk = newDataMultiKey[i];
                            outputStateGroup = this.outputState.get(mk);
                            if (outputStateGroup == null) {
                                try {
                                    outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                                }
                                catch (ExprValidationException e) {
                                    log.error((Object)("Error starting output limit for group for statement '" + this.agentInstanceContext.getStatementContext().getStatementName() + "'"));
                                }
                                this.outputState.put(newDataMultiKey[i], outputStateGroup);
                            }
                            if (pass = outputStateGroup.updateOutputCondition(1, 0)) {
                                this.workCollection.put(mk, new EventBean[]{newData[i]});
                            }
                            this.aggregationService.applyEnter(this.eventsPerStreamOneStream, mk, this.agentInstanceContext);
                        }
                    }
                    if (oldData != null) {
                        for (i = 0; i < oldData.length; ++i) {
                            this.eventsPerStreamOneStream[0] = oldData[i];
                            mk = oldDataMultiKey[i];
                            outputStateGroup = this.outputState.get(mk);
                            if (outputStateGroup == null) {
                                try {
                                    outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                                }
                                catch (ExprValidationException e) {
                                    log.error((Object)("Error starting output limit for group for statement '" + this.agentInstanceContext.getStatementContext().getStatementName() + "'"));
                                }
                                this.outputState.put(oldDataMultiKey[i], outputStateGroup);
                            }
                            if (pass = outputStateGroup.updateOutputCondition(0, 1)) {
                                this.workCollection.put(mk, new EventBean[]{oldData[i]});
                            }
                            this.aggregationService.applyLeave(this.eventsPerStreamOneStream, mk, this.agentInstanceContext);
                        }
                    }
                    this.generateOutputBatchedArr(this.workCollection, false, generateSynthetic, resultNewEvents, resultNewSortKeys);
                }
            } else {
                for (UniformPair<EventBean[]> uniformPair : viewEventsList) {
                    boolean pass;
                    OutputConditionPolled outputStateGroup;
                    Boolean result;
                    Object mk;
                    int i;
                    newData = uniformPair.getFirst();
                    oldData = uniformPair.getSecond();
                    Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
                    Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                    if (newData != null) {
                        for (i = 0; i < newData.length; ++i) {
                            this.eventsPerStreamOneStream[0] = newData[i];
                            mk = newDataMultiKey[i];
                            this.aggregationService.applyEnter(this.eventsPerStreamOneStream, mk, this.agentInstanceContext);
                        }
                    }
                    if (oldData != null) {
                        for (i = 0; i < oldData.length; ++i) {
                            this.eventsPerStreamOneStream[0] = oldData[i];
                            mk = oldDataMultiKey[i];
                            this.aggregationService.applyLeave(this.eventsPerStreamOneStream, mk, this.agentInstanceContext);
                        }
                    }
                    if (newData != null) {
                        for (i = 0; i < newData.length; ++i) {
                            this.eventsPerStreamOneStream[0] = newData[i];
                            mk = newDataMultiKey[i];
                            this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceId(), null);
                            result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(this.eventsPerStreamOneStream, true, this.agentInstanceContext);
                            if (result == null || !result.booleanValue()) continue;
                            outputStateGroup = this.outputState.get(mk);
                            if (outputStateGroup == null) {
                                try {
                                    outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                                }
                                catch (ExprValidationException e) {
                                    log.error((Object)("Error starting output limit for group for statement '" + this.agentInstanceContext.getStatementContext().getStatementName() + "'"));
                                }
                                this.outputState.put(mk, outputStateGroup);
                            }
                            if (!(pass = outputStateGroup.updateOutputCondition(1, 0))) continue;
                            this.workCollection.put(mk, new EventBean[]{newData[i]});
                        }
                    }
                    if (oldData != null) {
                        for (i = 0; i < oldData.length; ++i) {
                            this.eventsPerStreamOneStream[0] = oldData[i];
                            mk = oldDataMultiKey[i];
                            this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceId(), null);
                            result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(this.eventsPerStreamOneStream, true, this.agentInstanceContext);
                            if (result == null || !result.booleanValue()) continue;
                            outputStateGroup = this.outputState.get(mk);
                            if (outputStateGroup == null) {
                                try {
                                    outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                                }
                                catch (ExprValidationException e) {
                                    log.error((Object)("Error starting output limit for group for statement '" + this.agentInstanceContext.getStatementContext().getStatementName() + "'"));
                                }
                                this.outputState.put(oldDataMultiKey[i], outputStateGroup);
                            }
                            if (!(pass = outputStateGroup.updateOutputCondition(0, 1))) continue;
                            this.workCollection.put(mk, new EventBean[]{oldData[i]});
                        }
                    }
                    this.generateOutputBatchedArr(this.workCollection, false, generateSynthetic, resultNewEvents, resultNewSortKeys);
                }
            }
            EventBean[] newEventsArr = null;
            Object var9_41 = null;
            if (!resultNewEvents.isEmpty()) {
                newEventsArr = resultNewEvents.toArray(new EventBean[resultNewEvents.size()]);
            }
            if (resultOldEvents != null && !resultOldEvents.isEmpty()) {
                EventBean[] eventBeanArray = resultOldEvents.toArray(new EventBean[resultOldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                Object[] sortKeysNew = resultNewSortKeys.isEmpty() ? null : resultNewSortKeys.toArray(new Object[resultNewSortKeys.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
                if (this.prototype.isSelectRStream()) {
                    void var9_43;
                    Object[] sortKeysOld = resultOldSortKeys.isEmpty() ? null : resultOldSortKeys.toArray(new Object[resultOldSortKeys.size()]);
                    EventBean[] eventBeanArray = this.orderByProcessor.sort((EventBean[])var9_43, sortKeysOld, this.agentInstanceContext);
                }
            }
            if (newEventsArr == null && var9_45 == null) {
                return null;
            }
            return new UniformPair<void>((void)newEventsArr, var9_45);
        }
        LinkedHashMap<Object, EventBean> lastPerGroupNew = new LinkedHashMap<Object, EventBean>();
        LinkedHashMap<Object, EventBean> lastPerGroupOld = null;
        if (this.prototype.isSelectRStream()) {
            lastPerGroupOld = new LinkedHashMap<Object, EventBean>();
        }
        LinkedHashMap<Object, Object> newEventsSortKey = null;
        LinkedHashMap<Object, Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedHashMap<Object, Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedHashMap<Object, Object>();
            }
        }
        for (UniformPair<EventBean[]> uniformPair : viewEventsList) {
            int count;
            EventBean[] newData = uniformPair.getFirst();
            EventBean[] oldData = uniformPair.getSecond();
            Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
            Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
            if (newData != null) {
                count = 0;
                for (EventBean aNewData : newData) {
                    Object mk = newDataMultiKey[count];
                    this.eventsPerStreamOneStream[0] = aNewData;
                    this.aggregationService.applyEnter(this.eventsPerStreamOneStream, mk, this.agentInstanceContext);
                    ++count;
                }
            }
            if (oldData != null) {
                count = 0;
                EventBean[] arr$ = oldData;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    EventBean anOldData;
                    this.eventsPerStreamOneStream[0] = anOldData = arr$[i$];
                    this.aggregationService.applyLeave(this.eventsPerStreamOneStream, oldDataMultiKey[count], this.agentInstanceContext);
                    ++count;
                }
            }
            if (this.prototype.isSelectRStream()) {
                this.generateOutputBatchedView(oldData, oldDataMultiKey, false, generateSynthetic, lastPerGroupOld, oldEventsSortKey);
            }
            this.generateOutputBatchedView(newData, newDataMultiKey, false, generateSynthetic, lastPerGroupNew, newEventsSortKey);
        }
        EventBean[] newEventsArr = lastPerGroupNew.isEmpty() ? null : lastPerGroupNew.values().toArray(new EventBean[lastPerGroupNew.size()]);
        Object var9_47 = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray;
            EventBean[] eventBeanArray4 = eventBeanArray = lastPerGroupOld.isEmpty() ? null : lastPerGroupOld.values().toArray(new EventBean[lastPerGroupOld.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.values().toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                void var9_49;
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.values().toArray(new Object[oldEventsSortKey.size()]);
                EventBean[] eventBeanArray = this.orderByProcessor.sort((EventBean[])var9_49, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && var9_51 == null) {
            return null;
        }
        return new UniformPair<void>((void)newEventsArr, var9_51);
    }

    private void generateOutputBatchedArr(Map<Object, EventBean[]> keysAndEvents, boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents, List<Object> optSortKeys) {
        for (Map.Entry<Object, EventBean[]> entry : keysAndEvents.entrySet()) {
            Boolean result;
            EventBean[] eventsPerStream = entry.getValue();
            this.aggregationService.setCurrentAccess(entry.getKey(), this.agentInstanceContext.getAgentInstanceId(), null);
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            resultEvents.add(this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext));
            if (!this.prototype.isSorting()) continue;
            optSortKeys.add(this.orderByProcessor.getSortKey(eventsPerStream, isNewData, this.agentInstanceContext));
        }
    }

    protected void generateOutputBatchedView(EventBean[] outputEvents, Object[] groupByKeys, boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents, List<Object> optSortKeys) {
        if (outputEvents == null) {
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        int count = 0;
        for (int i = 0; i < outputEvents.length; ++i) {
            Boolean result;
            this.aggregationService.setCurrentAccess(groupByKeys[count], this.agentInstanceContext.getAgentInstanceId(), null);
            eventsPerStream[0] = outputEvents[count];
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            resultEvents.add(this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext));
            if (this.prototype.isSorting()) {
                optSortKeys.add(this.orderByProcessor.getSortKey(eventsPerStream, isNewData, this.agentInstanceContext));
            }
            ++count;
        }
    }

    protected void generateOutputBatchedJoin(Set<MultiKey<EventBean>> outputEvents, Object[] groupByKeys, boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents, List<Object> optSortKeys) {
        if (outputEvents == null) {
            return;
        }
        int count = 0;
        for (MultiKey<EventBean> row : outputEvents) {
            Boolean result;
            this.aggregationService.setCurrentAccess(groupByKeys[count], this.agentInstanceContext.getAgentInstanceId(), null);
            EventBean[] eventsPerStream = row.getArray();
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            resultEvents.add(this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext));
            if (this.prototype.isSorting()) {
                optSortKeys.add(this.orderByProcessor.getSortKey(eventsPerStream, isNewData, this.agentInstanceContext));
            }
            ++count;
        }
    }

    protected EventBean generateOutputBatchedSingle(Object groupByKey, EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize) {
        Boolean result;
        this.aggregationService.setCurrentAccess(groupByKey, this.agentInstanceContext.getAgentInstanceId(), null);
        if (!(this.prototype.getOptionalHavingNode() == null || (result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) != null && result.booleanValue())) {
            return null;
        }
        return this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext);
    }

    protected void generateOutputBatchedView(EventBean[] outputEvents, Object[] groupByKeys, boolean isNewData, boolean isSynthesize, Map<Object, EventBean> resultEvents, Map<Object, Object> optSortKeys) {
        if (outputEvents == null) {
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        int count = 0;
        for (int i = 0; i < outputEvents.length; ++i) {
            Boolean result;
            Object groupKey = groupByKeys[count];
            this.aggregationService.setCurrentAccess(groupKey, this.agentInstanceContext.getAgentInstanceId(), null);
            eventsPerStream[0] = outputEvents[count];
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            resultEvents.put(groupKey, this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext));
            if (this.prototype.isSorting()) {
                optSortKeys.put(groupKey, this.orderByProcessor.getSortKey(eventsPerStream, isNewData, this.agentInstanceContext));
            }
            ++count;
        }
    }

    protected void generateOutputBatchedJoin(Set<MultiKey<EventBean>> outputEvents, Object[] groupByKeys, boolean isNewData, boolean isSynthesize, Map<Object, EventBean> resultEvents, Map<Object, Object> optSortKeys) {
        if (outputEvents == null) {
            return;
        }
        int count = 0;
        for (MultiKey<EventBean> row : outputEvents) {
            Boolean result;
            Object groupKey = groupByKeys[count];
            this.aggregationService.setCurrentAccess(groupKey, this.agentInstanceContext.getAgentInstanceId(), null);
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(row.getArray(), isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            resultEvents.put(groupKey, this.selectExprProcessor.process(row.getArray(), isNewData, isSynthesize, this.agentInstanceContext));
            if (this.prototype.isSorting()) {
                optSortKeys.put(groupKey, this.orderByProcessor.getSortKey(row.getArray(), isNewData, this.agentInstanceContext));
            }
            ++count;
        }
    }

    @Override
    public boolean hasAggregation() {
        return true;
    }

    @Override
    public void removed(Object key) {
        this.eventGroupReps.remove(key);
    }

    @Override
    public void processOutputLimitedLastAllNonBufferedView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic, boolean isAll) {
        if (isAll) {
            this.outputAllHelper.processView(newData, oldData, isGenerateSynthetic);
        } else {
            this.outputLastHelper.processView(newData, oldData, isGenerateSynthetic);
        }
    }

    @Override
    public void processOutputLimitedLastAllNonBufferedJoin(Set<MultiKey<EventBean>> newData, Set<MultiKey<EventBean>> oldData, boolean isGenerateSynthetic, boolean isAll) {
        if (isAll) {
            this.outputAllHelper.processJoin(newData, oldData, isGenerateSynthetic);
        } else {
            this.outputLastHelper.processJoin(newData, oldData, isGenerateSynthetic);
        }
    }

    @Override
    public UniformPair<EventBean[]> continueOutputLimitedLastAllNonBufferedView(boolean isSynthesize, boolean isAll) {
        if (isAll) {
            return this.outputAllHelper.outputView(isSynthesize);
        }
        return this.outputLastHelper.outputView(isSynthesize);
    }

    @Override
    public UniformPair<EventBean[]> continueOutputLimitedLastAllNonBufferedJoin(boolean isSynthesize, boolean isAll) {
        if (isAll) {
            return this.outputAllHelper.outputJoin(isSynthesize);
        }
        return this.outputLastHelper.outputJoin(isSynthesize);
    }
}

