/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.core.ResultSetProcessorRowForAll;
import com.espertech.esper.epl.core.ResultSetProcessorUtil;
import com.espertech.esper.event.EventBeanUtility;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;

public class ResultSetProcessorRowForAllOutputAllHelper {
    private final ResultSetProcessorRowForAll processor;
    private final Deque<EventBean> eventsOld = new ArrayDeque<EventBean>(2);
    private final Deque<EventBean> eventsNew = new ArrayDeque<EventBean>(2);

    public ResultSetProcessorRowForAllOutputAllHelper(ResultSetProcessorRowForAll processor) {
        this.processor = processor;
    }

    public void processView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic) {
        if (this.processor.prototype.isSelectRStream()) {
            EventBean[] events = this.processor.getSelectListEvents(false, isGenerateSynthetic, false);
            EventBeanUtility.addToCollection(events, this.eventsOld);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        ResultSetProcessorUtil.applyAggViewResult(this.processor.aggregationService, this.processor.exprEvaluatorContext, newData, oldData, eventsPerStream);
        EventBean[] events = this.processor.getSelectListEvents(true, isGenerateSynthetic, false);
        EventBeanUtility.addToCollection(events, this.eventsNew);
    }

    public void processJoin(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isGenerateSynthetic) {
        EventBean[] events;
        if (this.processor.prototype.isSelectRStream()) {
            events = this.processor.getSelectListEvents(false, isGenerateSynthetic, true);
            EventBeanUtility.addToCollection(events, this.eventsOld);
        }
        ResultSetProcessorUtil.applyAggJoinResult(this.processor.aggregationService, this.processor.exprEvaluatorContext, newEvents, oldEvents);
        events = this.processor.getSelectListEvents(true, isGenerateSynthetic, true);
        EventBeanUtility.addToCollection(events, this.eventsNew);
    }

    public UniformPair<EventBean[]> outputView(boolean isGenerateSynthetic) {
        return this.output(isGenerateSynthetic, false);
    }

    public UniformPair<EventBean[]> outputJoin(boolean isGenerateSynthetic) {
        return this.output(isGenerateSynthetic, true);
    }

    private UniformPair<EventBean[]> output(boolean isGenerateSynthetic, boolean isJoin) {
        EventBean[] oldEvents = EventBeanUtility.toArrayNullIfEmpty(this.eventsOld);
        EventBean[] newEvents = EventBeanUtility.toArrayNullIfEmpty(this.eventsNew);
        if (newEvents == null) {
            newEvents = this.processor.getSelectListEvents(true, isGenerateSynthetic, isJoin);
        }
        if (oldEvents == null && this.processor.prototype.isSelectRStream()) {
            oldEvents = this.processor.getSelectListEvents(false, isGenerateSynthetic, isJoin);
        }
        UniformPair<EventBean[]> result = null;
        if (oldEvents != null || newEvents != null) {
            result = new UniformPair<EventBean[]>(newEvents, oldEvents);
        }
        this.eventsOld.clear();
        this.eventsNew.clear();
        return result;
    }
}

