/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ResultSetProcessorRowPerGroupOutputAllHelper {
    protected final ResultSetProcessorRowPerGroup processor;
    private final Map<Object, EventBean[]> groupReps = new LinkedHashMap<Object, EventBean[]>();
    private final Map<Object, EventBean> groupRepsOutputLastUnordRStream = new LinkedHashMap<Object, EventBean>();
    private boolean first;

    public ResultSetProcessorRowPerGroupOutputAllHelper(ResultSetProcessorRowPerGroup processor) {
        this.processor = processor;
    }

    public void processView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic) {
        Object mk;
        EventBean[] eventsPerStream;
        this.generateRemoveStreamJustOnce(isGenerateSynthetic, false);
        if (newData != null) {
            for (EventBean aNewData : newData) {
                eventsPerStream = new EventBean[]{aNewData};
                mk = this.processor.generateGroupKey(eventsPerStream, true);
                this.groupReps.put(mk, eventsPerStream);
                if (this.processor.prototype.isSelectRStream() && !this.groupRepsOutputLastUnordRStream.containsKey(mk)) {
                    this.processor.generateOutputBatchedNoSortWMap(false, mk, eventsPerStream, true, isGenerateSynthetic, this.groupRepsOutputLastUnordRStream);
                }
                this.processor.aggregationService.applyEnter(eventsPerStream, mk, this.processor.agentInstanceContext);
            }
        }
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                eventsPerStream = new EventBean[]{anOldData};
                mk = this.processor.generateGroupKey(eventsPerStream, true);
                if (this.processor.prototype.isSelectRStream() && !this.groupRepsOutputLastUnordRStream.containsKey(mk)) {
                    this.processor.generateOutputBatchedNoSortWMap(false, mk, eventsPerStream, false, isGenerateSynthetic, this.groupRepsOutputLastUnordRStream);
                }
                this.processor.aggregationService.applyLeave(eventsPerStream, mk, this.processor.agentInstanceContext);
            }
        }
    }

    public void processJoin(Set<MultiKey<EventBean>> newData, Set<MultiKey<EventBean>> oldData, boolean isGenerateSynthetic) {
        Object mk;
        this.generateRemoveStreamJustOnce(isGenerateSynthetic, true);
        if (newData != null) {
            for (MultiKey<EventBean> aNewData : newData) {
                mk = this.processor.generateGroupKey(aNewData.getArray(), true);
                this.groupReps.put(mk, aNewData.getArray());
                if (this.processor.prototype.isSelectRStream() && !this.groupRepsOutputLastUnordRStream.containsKey(mk)) {
                    this.processor.generateOutputBatchedNoSortWMap(true, mk, aNewData.getArray(), true, isGenerateSynthetic, this.groupRepsOutputLastUnordRStream);
                }
                this.processor.aggregationService.applyEnter(aNewData.getArray(), mk, this.processor.agentInstanceContext);
            }
        }
        if (oldData != null) {
            for (MultiKey<EventBean> anOldData : oldData) {
                mk = this.processor.generateGroupKey(anOldData.getArray(), false);
                if (this.processor.prototype.isSelectRStream() && !this.groupRepsOutputLastUnordRStream.containsKey(mk)) {
                    this.processor.generateOutputBatchedNoSortWMap(true, mk, anOldData.getArray(), false, isGenerateSynthetic, this.groupRepsOutputLastUnordRStream);
                }
                this.processor.aggregationService.applyLeave(anOldData.getArray(), mk, this.processor.agentInstanceContext);
            }
        }
    }

    public UniformPair<EventBean[]> outputView(boolean isSynthesize) {
        this.generateRemoveStreamJustOnce(isSynthesize, false);
        return this.output(isSynthesize, false);
    }

    public UniformPair<EventBean[]> outputJoin(boolean isSynthesize) {
        this.generateRemoveStreamJustOnce(isSynthesize, true);
        return this.output(isSynthesize, true);
    }

    private UniformPair<EventBean[]> output(boolean isSynthesize, boolean join) {
        ArrayList<EventBean> newEvents = new ArrayList<EventBean>(4);
        this.processor.generateOutputBatchedArr(join, this.groupReps, true, isSynthesize, newEvents, null);
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (!this.groupRepsOutputLastUnordRStream.isEmpty()) {
            Collection<EventBean> oldEvents = this.groupRepsOutputLastUnordRStream.values();
            oldEventsArr = oldEvents.toArray(new EventBean[oldEvents.size()]);
            this.groupRepsOutputLastUnordRStream.clear();
        }
        this.first = true;
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<Object>(newEventsArr, oldEventsArr);
    }

    private void generateRemoveStreamJustOnce(boolean isSynthesize, boolean join) {
        if (this.first && this.processor.prototype.isSelectRStream()) {
            for (Map.Entry<Object, EventBean[]> groupRep : this.groupReps.entrySet()) {
                Object mk = this.processor.generateGroupKey(groupRep.getValue(), false);
                this.processor.generateOutputBatchedNoSortWMap(join, mk, groupRep.getValue(), false, isSynthesize, this.groupRepsOutputLastUnordRStream);
            }
        }
        this.first = false;
    }
}

