/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.scopetest.EPAssertionUtil;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.rollup.GroupByRollupKey;
import com.espertech.esper.epl.agg.service.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupRollupFactory;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupRollupOutputAllHelper;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupRollupOutputLastHelper;
import com.espertech.esper.epl.core.ResultSetProcessorUtil;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.view.OutputConditionPolled;
import com.espertech.esper.epl.view.OutputConditionPolledFactory;
import com.espertech.esper.view.Viewable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetProcessorRowPerGroupRollup
implements ResultSetProcessor,
AggregationRowRemovedCallback {
    private static final Log log = LogFactory.getLog(ResultSetProcessorRowPerGroupRollup.class);
    protected final ResultSetProcessorRowPerGroupRollupFactory prototype;
    protected final OrderByProcessor orderByProcessor;
    protected final AggregationService aggregationService;
    protected AgentInstanceContext agentInstanceContext;
    protected final Map<Object, EventBean[]>[] outputLimitGroupRepsPerLevel;
    private final Map<Object, OutputConditionPolled>[] outputState;
    protected final Map<Object, EventBean>[] eventPerGroupBuf;
    private final Map<Object, EventBean[]>[] eventPerGroupJoinBuf;
    private final EventArrayAndSortKeyArray rstreamEventSortArrayPair;
    private final ResultSetProcessorRowPerGroupRollupOutputLastHelper outputLastHelper;
    private final ResultSetProcessorRowPerGroupRollupOutputAllHelper outputAllHelper;

    public ResultSetProcessorRowPerGroupRollup(ResultSetProcessorRowPerGroupRollupFactory prototype, OrderByProcessor orderByProcessor, AggregationService aggregationService, AgentInstanceContext agentInstanceContext) {
        int i;
        this.prototype = prototype;
        this.orderByProcessor = orderByProcessor;
        this.aggregationService = aggregationService;
        this.agentInstanceContext = agentInstanceContext;
        aggregationService.setRemovedCallback(this);
        int levelCount = prototype.getGroupByRollupDesc().getLevels().length;
        if (prototype.isJoin()) {
            this.eventPerGroupJoinBuf = new LinkedHashMap[levelCount];
            for (i = 0; i < levelCount; ++i) {
                this.eventPerGroupJoinBuf[i] = new LinkedHashMap<Object, EventBean[]>();
            }
            this.eventPerGroupBuf = null;
        } else {
            this.eventPerGroupBuf = new LinkedHashMap[levelCount];
            for (i = 0; i < levelCount; ++i) {
                this.eventPerGroupBuf[i] = new LinkedHashMap<Object, EventBean>();
            }
            this.eventPerGroupJoinBuf = null;
        }
        if (prototype.getOutputLimitSpec() != null) {
            this.outputLimitGroupRepsPerLevel = new LinkedHashMap[levelCount];
            for (i = 0; i < levelCount; ++i) {
                this.outputLimitGroupRepsPerLevel[i] = new LinkedHashMap<Object, EventBean[]>();
            }
            if (prototype.getOutputLimitSpec().getDisplayLimit() == OutputLimitLimitType.LAST) {
                this.outputLastHelper = new ResultSetProcessorRowPerGroupRollupOutputLastHelper(this, this.outputLimitGroupRepsPerLevel.length);
                this.outputAllHelper = null;
            } else if (prototype.getOutputLimitSpec().getDisplayLimit() == OutputLimitLimitType.ALL) {
                this.outputAllHelper = new ResultSetProcessorRowPerGroupRollupOutputAllHelper(this, this.outputLimitGroupRepsPerLevel.length);
                this.outputLastHelper = null;
            } else {
                this.outputLastHelper = null;
                this.outputAllHelper = null;
            }
        } else {
            this.outputLimitGroupRepsPerLevel = null;
            this.outputLastHelper = null;
            this.outputAllHelper = null;
        }
        if (prototype.getOutputLimitSpec() != null && prototype.getOutputLimitSpec().getDisplayLimit() == OutputLimitLimitType.FIRST) {
            this.outputState = new Map[levelCount];
            for (i = 0; i < levelCount; ++i) {
                this.outputState[i] = new HashMap<Object, OutputConditionPolled>();
            }
        } else {
            this.outputState = null;
        }
        if (prototype.getOutputLimitSpec() != null && (prototype.isSelectRStream() || prototype.getOutputLimitSpec().getDisplayLimit() == OutputLimitLimitType.FIRST)) {
            List[] eventsPerLevel = new List[prototype.getGroupByRollupDesc().getLevels().length];
            List[] sortKeyPerLevel = null;
            if (orderByProcessor != null) {
                sortKeyPerLevel = new List[prototype.getGroupByRollupDesc().getLevels().length];
            }
            for (AggregationGroupByRollupLevel level : prototype.getGroupByRollupDesc().getLevels()) {
                eventsPerLevel[level.getLevelNumber()] = new ArrayList();
                if (orderByProcessor == null) continue;
                sortKeyPerLevel[level.getLevelNumber()] = new ArrayList();
            }
            this.rstreamEventSortArrayPair = new EventArrayAndSortKeyArray(eventsPerLevel, sortKeyPerLevel);
        } else {
            this.rstreamEventSortArrayPair = null;
        }
    }

    @Override
    public void setAgentInstanceContext(AgentInstanceContext agentInstanceContext) {
        this.agentInstanceContext = agentInstanceContext;
    }

    @Override
    public EventType getResultEventType() {
        return this.prototype.getResultEventType();
    }

    @Override
    public UniformPair<EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        int count;
        if (this.prototype.isUnidirectional()) {
            this.clear();
        }
        this.resetEventPerGroupJoinBuf();
        Object[][] newDataMultiKey = this.generateGroupKeysJoin(newEvents, this.eventPerGroupJoinBuf, true);
        Object[][] oldDataMultiKey = this.generateGroupKeysJoin(oldEvents, this.eventPerGroupJoinBuf, false);
        EventBean[] selectOldEvents = null;
        if (this.prototype.isSelectRStream()) {
            selectOldEvents = this.generateOutputEventsJoin(this.eventPerGroupJoinBuf, false, isSynthesize);
        }
        if (newEvents != null) {
            count = 0;
            for (MultiKey<EventBean> mk : newEvents) {
                this.aggregationService.applyEnter(mk.getArray(), newDataMultiKey[count++], this.agentInstanceContext);
            }
        }
        if (oldEvents != null) {
            count = 0;
            for (MultiKey<EventBean> mk : oldEvents) {
                this.aggregationService.applyLeave(mk.getArray(), oldDataMultiKey[count++], this.agentInstanceContext);
            }
        }
        if ((selectNewEvents = this.generateOutputEventsJoin(this.eventPerGroupJoinBuf, true, isSynthesize)) != null || selectOldEvents != null) {
            return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    @Override
    public UniformPair<EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        int i;
        this.resetEventPerGroupBuf();
        Object[][] newDataMultiKey = this.generateGroupKeysView(newData, this.eventPerGroupBuf, true);
        Object[][] oldDataMultiKey = this.generateGroupKeysView(oldData, this.eventPerGroupBuf, false);
        EventBean[] selectOldEvents = null;
        if (this.prototype.isSelectRStream()) {
            selectOldEvents = this.generateOutputEventsView(this.eventPerGroupBuf, false, isSynthesize);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                this.aggregationService.applyEnter(eventsPerStream, newDataMultiKey[i], this.agentInstanceContext);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                this.aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[i], this.agentInstanceContext);
            }
        }
        if ((selectNewEvents = this.generateOutputEventsView(this.eventPerGroupBuf, true, isSynthesize)) != null || selectOldEvents != null) {
            return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    protected EventBean[] generateOutputEventsView(Map<Object, EventBean>[] keysAndEvents, boolean isNewData, boolean isSynthesize) {
        EventBean[] eventsPerStream = new EventBean[1];
        ArrayList<EventBean> events = new ArrayList<EventBean>(1);
        ArrayList<GroupByRollupKey> currentGenerators = null;
        if (this.prototype.isSorting()) {
            currentGenerators = new ArrayList<GroupByRollupKey>(4);
        }
        AggregationGroupByRollupLevel[] levels = this.prototype.getGroupByRollupDesc().getLevels();
        SelectExprProcessor[] selectExprProcessors = this.prototype.getPerLevelExpression().getSelectExprProcessor();
        ExprEvaluator[] optionalHavingClauses = this.prototype.getPerLevelExpression().getOptionalHavingNodes();
        for (AggregationGroupByRollupLevel level : levels) {
            for (Map.Entry<Object, EventBean> entry : keysAndEvents[level.getLevelNumber()].entrySet()) {
                Boolean result;
                Object groupKey = entry.getKey();
                this.aggregationService.setCurrentAccess(groupKey, this.agentInstanceContext.getAgentInstanceId(), level);
                eventsPerStream[0] = entry.getValue();
                if (optionalHavingClauses != null && ((result = (Boolean)optionalHavingClauses[level.getLevelNumber()].evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
                events.add(selectExprProcessors[level.getLevelNumber()].process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext));
                if (!this.prototype.isSorting()) continue;
                EventBean[] currentEventsPerStream = new EventBean[]{entry.getValue()};
                currentGenerators.add(new GroupByRollupKey(currentEventsPerStream, level, groupKey));
            }
        }
        if (events.isEmpty()) {
            return null;
        }
        EventBean[] outgoing = events.toArray(new EventBean[events.size()]);
        if (outgoing.length > 1 && this.prototype.isSorting()) {
            return this.orderByProcessor.sort(outgoing, currentGenerators, isNewData, this.agentInstanceContext, this.prototype.getPerLevelExpression().getOptionalOrderByElements());
        }
        return outgoing;
    }

    private EventBean[] generateOutputEventsJoin(Map<Object, EventBean[]>[] eventPairs, boolean isNewData, boolean synthesize) {
        ArrayList<EventBean> events = new ArrayList<EventBean>(1);
        ArrayList<GroupByRollupKey> currentGenerators = null;
        if (this.prototype.isSorting()) {
            currentGenerators = new ArrayList<GroupByRollupKey>(4);
        }
        AggregationGroupByRollupLevel[] levels = this.prototype.getGroupByRollupDesc().getLevels();
        SelectExprProcessor[] selectExprProcessors = this.prototype.getPerLevelExpression().getSelectExprProcessor();
        ExprEvaluator[] optionalHavingClauses = this.prototype.getPerLevelExpression().getOptionalHavingNodes();
        for (AggregationGroupByRollupLevel level : levels) {
            for (Map.Entry<Object, EventBean[]> entry : eventPairs[level.getLevelNumber()].entrySet()) {
                Boolean result;
                Object groupKey = entry.getKey();
                this.aggregationService.setCurrentAccess(groupKey, this.agentInstanceContext.getAgentInstanceId(), level);
                if (optionalHavingClauses != null && ((result = (Boolean)optionalHavingClauses[level.getLevelNumber()].evaluate(entry.getValue(), isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
                events.add(selectExprProcessors[level.getLevelNumber()].process(entry.getValue(), isNewData, synthesize, this.agentInstanceContext));
                if (!this.prototype.isSorting()) continue;
                currentGenerators.add(new GroupByRollupKey(entry.getValue(), level, groupKey));
            }
        }
        if (events.isEmpty()) {
            return null;
        }
        EventBean[] outgoing = events.toArray(new EventBean[events.size()]);
        if (outgoing.length > 1 && this.prototype.isSorting()) {
            return this.orderByProcessor.sort(outgoing, currentGenerators, isNewData, this.agentInstanceContext, this.prototype.getPerLevelExpression().getOptionalOrderByElements());
        }
        return outgoing;
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        if (!this.prototype.isHistoricalOnly()) {
            return this.obtainIterator(parent);
        }
        this.aggregationService.clearResults(this.agentInstanceContext);
        Iterator<EventBean> it = parent.iterator();
        EventBean[] eventsPerStream = new EventBean[1];
        Object[] groupKeys = new Object[this.prototype.getGroupByRollupDesc().getLevels().length];
        AggregationGroupByRollupLevel[] levels = this.prototype.getGroupByRollupDesc().getLevels();
        while (it.hasNext()) {
            eventsPerStream[0] = it.next();
            Object groupKeyComplete = this.generateGroupKey(eventsPerStream, true);
            for (int j = 0; j < levels.length; ++j) {
                Object subkey;
                groupKeys[j] = subkey = levels[j].computeSubkey(groupKeyComplete);
            }
            this.aggregationService.applyEnter(eventsPerStream, groupKeys, this.agentInstanceContext);
        }
        ArrayDeque<EventBean> deque = ResultSetProcessorUtil.iteratorToDeque(this.obtainIterator(parent));
        this.aggregationService.clearResults(this.agentInstanceContext);
        return deque.iterator();
    }

    private Iterator<EventBean> obtainIterator(Viewable parent) {
        this.resetEventPerGroupBuf();
        EventBean[] events = EPAssertionUtil.iteratorToArray(parent.iterator());
        this.generateGroupKeysView(events, this.eventPerGroupBuf, true);
        EventBean[] output = this.generateOutputEventsView(this.eventPerGroupBuf, true, true);
        return new ArrayEventIterator(output);
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        this.resetEventPerGroupJoinBuf();
        this.generateGroupKeysJoin(joinSet, this.eventPerGroupJoinBuf, true);
        EventBean[] output = this.generateOutputEventsJoin(this.eventPerGroupJoinBuf, true, true);
        return new ArrayEventIterator(output);
    }

    @Override
    public void clear() {
        this.aggregationService.clearResults(this.agentInstanceContext);
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedJoin(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType == OutputLimitLimitType.DEFAULT) {
            return this.handleOutputLimitDefaultJoin(joinEventsSet, generateSynthetic);
        }
        if (outputLimitLimitType == OutputLimitLimitType.ALL) {
            return this.handleOutputLimitAllJoin(joinEventsSet, generateSynthetic);
        }
        if (outputLimitLimitType == OutputLimitLimitType.FIRST) {
            return this.handleOutputLimitFirstJoin(joinEventsSet, generateSynthetic);
        }
        return this.handleOutputLimitLastJoin(joinEventsSet, generateSynthetic);
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedView(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType == OutputLimitLimitType.DEFAULT) {
            return this.handleOutputLimitDefaultView(viewEventsList, generateSynthetic);
        }
        if (outputLimitLimitType == OutputLimitLimitType.ALL) {
            return this.handleOutputLimitAllView(viewEventsList, generateSynthetic);
        }
        if (outputLimitLimitType == OutputLimitLimitType.FIRST) {
            return this.handleOutputLimitFirstView(viewEventsList, generateSynthetic);
        }
        return this.handleOutputLimitLastView(viewEventsList, generateSynthetic);
    }

    private UniformPair<EventBean[]> handleOutputLimitFirstView(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic) {
        for (Map<Object, EventBean[]> aGroupRepsView : this.outputLimitGroupRepsPerLevel) {
            aGroupRepsView.clear();
        }
        this.rstreamEventSortArrayPair.reset();
        int oldEventCount = this.prototype.getPerLevelExpression().getOptionalHavingNodes() == null ? this.handleOutputLimitFirstViewNoHaving(viewEventsList, generateSynthetic, this.rstreamEventSortArrayPair.getEventsPerLevel(), this.rstreamEventSortArrayPair.getSortKeyPerLevel()) : this.handleOutputLimitFirstViewHaving(viewEventsList, generateSynthetic, this.rstreamEventSortArrayPair.getEventsPerLevel(), this.rstreamEventSortArrayPair.getSortKeyPerLevel());
        return this.generateAndSort(this.outputLimitGroupRepsPerLevel, generateSynthetic, oldEventCount);
    }

    private UniformPair<EventBean[]> handleOutputLimitFirstJoin(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic) {
        for (Map<Object, EventBean[]> aGroupRepsView : this.outputLimitGroupRepsPerLevel) {
            aGroupRepsView.clear();
        }
        this.rstreamEventSortArrayPair.reset();
        int oldEventCount = this.prototype.getPerLevelExpression().getOptionalHavingNodes() == null ? this.handleOutputLimitFirstJoinNoHaving(joinEventsSet, generateSynthetic, this.rstreamEventSortArrayPair.getEventsPerLevel(), this.rstreamEventSortArrayPair.getSortKeyPerLevel()) : this.handleOutputLimitFirstJoinHaving(joinEventsSet, generateSynthetic, this.rstreamEventSortArrayPair.getEventsPerLevel(), this.rstreamEventSortArrayPair.getSortKeyPerLevel());
        return this.generateAndSort(this.outputLimitGroupRepsPerLevel, generateSynthetic, oldEventCount);
    }

    private int handleOutputLimitFirstViewHaving(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic, List<EventBean>[] oldEventsPerLevel, List<Object>[] oldEventsSortKeyPerLevel) {
        int oldEventCount = 0;
        ExprEvaluator[] havingPerLevel = this.prototype.getPerLevelExpression().getOptionalHavingNodes();
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            boolean pass;
            OutputConditionPolled outputStateGroup;
            Boolean result;
            Object groupKey;
            Object groupKeyComplete;
            EventBean[] eventsPerStream;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            Object[] groupKeysPerLevel = new Object[this.prototype.getGroupByRollupDesc().getLevels().length];
            if (newData != null) {
                for (EventBean aNewData : newData) {
                    eventsPerStream = new EventBean[]{aNewData};
                    groupKeyComplete = this.generateGroupKey(eventsPerStream, true);
                    for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                        groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    }
                    this.aggregationService.applyEnter(eventsPerStream, groupKeysPerLevel, this.agentInstanceContext);
                }
            }
            if (oldData != null) {
                for (EventBean anOldData : oldData) {
                    eventsPerStream = new EventBean[]{anOldData};
                    groupKeyComplete = this.generateGroupKey(eventsPerStream, false);
                    for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                        groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    }
                    this.aggregationService.applyLeave(eventsPerStream, groupKeysPerLevel, this.agentInstanceContext);
                }
            }
            if (newData != null) {
                for (EventBean aNewData : newData) {
                    eventsPerStream = new EventBean[]{aNewData};
                    groupKeyComplete = this.generateGroupKey(eventsPerStream, true);
                    for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                        groupKey = level.computeSubkey(groupKeyComplete);
                        this.aggregationService.setCurrentAccess(groupKey, this.agentInstanceContext.getAgentInstanceId(), level);
                        result = (Boolean)havingPerLevel[level.getLevelNumber()].evaluate(eventsPerStream, true, this.agentInstanceContext);
                        if (result == null || !result.booleanValue()) continue;
                        outputStateGroup = this.outputState[level.getLevelNumber()].get(groupKey);
                        if (outputStateGroup == null) {
                            try {
                                outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                            }
                            catch (ExprValidationException e) {
                                throw this.handleConditionValidationException(e);
                            }
                            this.outputState[level.getLevelNumber()].put(groupKey, outputStateGroup);
                        }
                        if (!(pass = outputStateGroup.updateOutputCondition(1, 0)) || this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, eventsPerStream) != null || !this.prototype.isSelectRStream()) continue;
                        this.generateOutputBatched(false, groupKey, level, eventsPerStream, true, generateSynthetic, oldEventsPerLevel, oldEventsSortKeyPerLevel);
                        ++oldEventCount;
                    }
                }
            }
            if (oldData == null) continue;
            for (EventBean anOldData : oldData) {
                eventsPerStream = new EventBean[]{anOldData};
                groupKeyComplete = this.generateGroupKey(eventsPerStream, false);
                for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                    groupKey = level.computeSubkey(groupKeyComplete);
                    this.aggregationService.setCurrentAccess(groupKey, this.agentInstanceContext.getAgentInstanceId(), level);
                    result = (Boolean)havingPerLevel[level.getLevelNumber()].evaluate(eventsPerStream, false, this.agentInstanceContext);
                    if (result == null || !result.booleanValue()) continue;
                    outputStateGroup = this.outputState[level.getLevelNumber()].get(groupKey);
                    if (outputStateGroup == null) {
                        try {
                            outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                        }
                        catch (ExprValidationException e) {
                            throw this.handleConditionValidationException(e);
                        }
                        this.outputState[level.getLevelNumber()].put(groupKey, outputStateGroup);
                    }
                    if (!(pass = outputStateGroup.updateOutputCondition(1, 0)) || this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, eventsPerStream) != null || !this.prototype.isSelectRStream()) continue;
                    this.generateOutputBatched(false, groupKey, level, eventsPerStream, false, generateSynthetic, oldEventsPerLevel, oldEventsSortKeyPerLevel);
                    ++oldEventCount;
                }
            }
        }
        return oldEventCount;
    }

    private int handleOutputLimitFirstJoinNoHaving(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventSet, boolean generateSynthetic, List<EventBean>[] oldEventsPerLevel, List<Object>[] oldEventsSortKeyPerLevel) {
        int oldEventCount = 0;
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventSet) {
            boolean pass;
            OutputConditionPolled outputStateGroup;
            Object groupKey;
            Object groupKeyComplete;
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            Object[] groupKeysPerLevel = new Object[this.prototype.getGroupByRollupDesc().getLevels().length];
            if (newData != null) {
                for (MultiKey<EventBean> aNewData : newData) {
                    groupKeyComplete = this.generateGroupKey(aNewData.getArray(), true);
                    for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                        groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                        outputStateGroup = this.outputState[level.getLevelNumber()].get(groupKey);
                        if (outputStateGroup == null) {
                            try {
                                outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                            }
                            catch (ExprValidationException e) {
                                throw this.handleConditionValidationException(e);
                            }
                            this.outputState[level.getLevelNumber()].put(groupKey, outputStateGroup);
                        }
                        if (!(pass = outputStateGroup.updateOutputCondition(1, 0)) || this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, aNewData.getArray()) != null || !this.prototype.isSelectRStream()) continue;
                        this.generateOutputBatched(false, groupKey, level, aNewData.getArray(), true, generateSynthetic, oldEventsPerLevel, oldEventsSortKeyPerLevel);
                        ++oldEventCount;
                    }
                    this.aggregationService.applyEnter(aNewData.getArray(), groupKeysPerLevel, this.agentInstanceContext);
                }
            }
            if (oldData == null) continue;
            for (MultiKey<EventBean> anOldData : oldData) {
                groupKeyComplete = this.generateGroupKey(anOldData.getArray(), false);
                for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    outputStateGroup = this.outputState[level.getLevelNumber()].get(groupKey);
                    if (outputStateGroup == null) {
                        try {
                            outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                        }
                        catch (ExprValidationException e) {
                            throw this.handleConditionValidationException(e);
                        }
                        this.outputState[level.getLevelNumber()].put(groupKey, outputStateGroup);
                    }
                    if (!(pass = outputStateGroup.updateOutputCondition(1, 0)) || this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, anOldData.getArray()) != null || !this.prototype.isSelectRStream()) continue;
                    this.generateOutputBatched(false, groupKey, level, anOldData.getArray(), false, generateSynthetic, oldEventsPerLevel, oldEventsSortKeyPerLevel);
                    ++oldEventCount;
                }
                this.aggregationService.applyLeave(anOldData.getArray(), groupKeysPerLevel, this.agentInstanceContext);
            }
        }
        return oldEventCount;
    }

    private int handleOutputLimitFirstJoinHaving(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventSet, boolean generateSynthetic, List<EventBean>[] oldEventsPerLevel, List<Object>[] oldEventsSortKeyPerLevel) {
        int oldEventCount = 0;
        ExprEvaluator[] havingPerLevel = this.prototype.getPerLevelExpression().getOptionalHavingNodes();
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventSet) {
            boolean pass;
            OutputConditionPolled outputStateGroup;
            Boolean result;
            Object groupKey;
            Object groupKeyComplete;
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            Object[] groupKeysPerLevel = new Object[this.prototype.getGroupByRollupDesc().getLevels().length];
            if (newData != null) {
                for (MultiKey<EventBean> aNewData : newData) {
                    groupKeyComplete = this.generateGroupKey(aNewData.getArray(), true);
                    for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                        groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    }
                    this.aggregationService.applyEnter(aNewData.getArray(), groupKeysPerLevel, this.agentInstanceContext);
                }
            }
            if (oldData != null) {
                for (MultiKey<EventBean> anOldData : oldData) {
                    groupKeyComplete = this.generateGroupKey(anOldData.getArray(), false);
                    for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                        groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    }
                    this.aggregationService.applyLeave(anOldData.getArray(), groupKeysPerLevel, this.agentInstanceContext);
                }
            }
            if (newData != null) {
                for (MultiKey<EventBean> aNewData : newData) {
                    groupKeyComplete = this.generateGroupKey(aNewData.getArray(), true);
                    for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                        groupKey = level.computeSubkey(groupKeyComplete);
                        this.aggregationService.setCurrentAccess(groupKey, this.agentInstanceContext.getAgentInstanceId(), level);
                        result = (Boolean)havingPerLevel[level.getLevelNumber()].evaluate(aNewData.getArray(), true, this.agentInstanceContext);
                        if (result == null || !result.booleanValue()) continue;
                        outputStateGroup = this.outputState[level.getLevelNumber()].get(groupKey);
                        if (outputStateGroup == null) {
                            try {
                                outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                            }
                            catch (ExprValidationException e) {
                                throw this.handleConditionValidationException(e);
                            }
                            this.outputState[level.getLevelNumber()].put(groupKey, outputStateGroup);
                        }
                        if (!(pass = outputStateGroup.updateOutputCondition(1, 0)) || this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, aNewData.getArray()) != null || !this.prototype.isSelectRStream()) continue;
                        this.generateOutputBatched(false, groupKey, level, aNewData.getArray(), true, generateSynthetic, oldEventsPerLevel, oldEventsSortKeyPerLevel);
                        ++oldEventCount;
                    }
                }
            }
            if (oldData == null) continue;
            for (MultiKey<EventBean> anOldData : oldData) {
                groupKeyComplete = this.generateGroupKey(anOldData.getArray(), false);
                for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                    groupKey = level.computeSubkey(groupKeyComplete);
                    this.aggregationService.setCurrentAccess(groupKey, this.agentInstanceContext.getAgentInstanceId(), level);
                    result = (Boolean)havingPerLevel[level.getLevelNumber()].evaluate(anOldData.getArray(), false, this.agentInstanceContext);
                    if (result == null || !result.booleanValue()) continue;
                    outputStateGroup = this.outputState[level.getLevelNumber()].get(groupKey);
                    if (outputStateGroup == null) {
                        try {
                            outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                        }
                        catch (ExprValidationException e) {
                            throw this.handleConditionValidationException(e);
                        }
                        this.outputState[level.getLevelNumber()].put(groupKey, outputStateGroup);
                    }
                    if (!(pass = outputStateGroup.updateOutputCondition(1, 0)) || this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, anOldData.getArray()) != null || !this.prototype.isSelectRStream()) continue;
                    this.generateOutputBatched(false, groupKey, level, anOldData.getArray(), false, generateSynthetic, oldEventsPerLevel, oldEventsSortKeyPerLevel);
                    ++oldEventCount;
                }
            }
        }
        return oldEventCount;
    }

    private int handleOutputLimitFirstViewNoHaving(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic, List<EventBean>[] oldEventsPerLevel, List<Object>[] oldEventsSortKeyPerLevel) {
        int oldEventCount = 0;
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            boolean pass;
            OutputConditionPolled outputStateGroup;
            Object groupKey;
            Object groupKeyComplete;
            EventBean[] eventsPerStream;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            Object[] groupKeysPerLevel = new Object[this.prototype.getGroupByRollupDesc().getLevels().length];
            if (newData != null) {
                for (EventBean aNewData : newData) {
                    eventsPerStream = new EventBean[]{aNewData};
                    groupKeyComplete = this.generateGroupKey(eventsPerStream, true);
                    for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                        groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                        outputStateGroup = this.outputState[level.getLevelNumber()].get(groupKey);
                        if (outputStateGroup == null) {
                            try {
                                outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                            }
                            catch (ExprValidationException e) {
                                throw this.handleConditionValidationException(e);
                            }
                            this.outputState[level.getLevelNumber()].put(groupKey, outputStateGroup);
                        }
                        if (!(pass = outputStateGroup.updateOutputCondition(1, 0)) || this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, eventsPerStream) != null || !this.prototype.isSelectRStream()) continue;
                        this.generateOutputBatched(false, groupKey, level, eventsPerStream, true, generateSynthetic, oldEventsPerLevel, oldEventsSortKeyPerLevel);
                        ++oldEventCount;
                    }
                    this.aggregationService.applyEnter(eventsPerStream, groupKeysPerLevel, this.agentInstanceContext);
                }
            }
            if (oldData == null) continue;
            for (EventBean anOldData : oldData) {
                eventsPerStream = new EventBean[]{anOldData};
                groupKeyComplete = this.generateGroupKey(eventsPerStream, false);
                for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    outputStateGroup = this.outputState[level.getLevelNumber()].get(groupKey);
                    if (outputStateGroup == null) {
                        try {
                            outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                        }
                        catch (ExprValidationException e) {
                            throw this.handleConditionValidationException(e);
                        }
                        this.outputState[level.getLevelNumber()].put(groupKey, outputStateGroup);
                    }
                    if (!(pass = outputStateGroup.updateOutputCondition(1, 0)) || this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, eventsPerStream) != null || !this.prototype.isSelectRStream()) continue;
                    this.generateOutputBatched(false, groupKey, level, eventsPerStream, false, generateSynthetic, oldEventsPerLevel, oldEventsSortKeyPerLevel);
                    ++oldEventCount;
                }
                this.aggregationService.applyLeave(eventsPerStream, groupKeysPerLevel, this.agentInstanceContext);
            }
        }
        return oldEventCount;
    }

    private UniformPair<EventBean[]> handleOutputLimitDefaultView(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic) {
        ArrayList<EventBean> newEvents = new ArrayList<EventBean>();
        ArrayList<Object> newEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new ArrayList<Object>();
        }
        ArrayList<EventBean> oldEvents = null;
        ArrayList<Object> oldEventsSortKey = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new ArrayList<EventBean>();
            if (this.orderByProcessor != null) {
                oldEventsSortKey = new ArrayList<Object>();
            }
        }
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            int i;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            this.resetEventPerGroupBuf();
            Object[][] newDataMultiKey = this.generateGroupKeysView(newData, this.eventPerGroupBuf, true);
            Object[][] oldDataMultiKey = this.generateGroupKeysView(oldData, this.eventPerGroupBuf, false);
            if (this.prototype.isSelectRStream()) {
                this.generateOutputBatchedCollectNonJoin(this.eventPerGroupBuf, false, generateSynthetic, oldEvents, oldEventsSortKey);
            }
            EventBean[] eventsPerStream = new EventBean[1];
            if (newData != null) {
                for (i = 0; i < newData.length; ++i) {
                    eventsPerStream[0] = newData[i];
                    this.aggregationService.applyEnter(eventsPerStream, newDataMultiKey[i], this.agentInstanceContext);
                }
            }
            if (oldData != null) {
                for (i = 0; i < oldData.length; ++i) {
                    eventsPerStream[0] = oldData[i];
                    this.aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[i], this.agentInstanceContext);
                }
            }
            this.generateOutputBatchedCollectNonJoin(this.eventPerGroupBuf, true, generateSynthetic, newEvents, newEventsSortKey);
        }
        return this.convertToArrayMaySort(newEvents, newEventsSortKey, oldEvents, oldEventsSortKey);
    }

    private UniformPair<EventBean[]> handleOutputLimitDefaultJoin(List<UniformPair<Set<MultiKey<EventBean>>>> viewEventsList, boolean generateSynthetic) {
        ArrayList<EventBean> newEvents = new ArrayList<EventBean>();
        ArrayList<Object> newEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new ArrayList<Object>();
        }
        ArrayList<EventBean> oldEvents = null;
        ArrayList<Object> oldEventsSortKey = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new ArrayList<EventBean>();
            if (this.orderByProcessor != null) {
                oldEventsSortKey = new ArrayList<Object>();
            }
        }
        for (UniformPair<Set<MultiKey<EventBean>>> pair : viewEventsList) {
            int count;
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            this.resetEventPerGroupJoinBuf();
            Object[][] newDataMultiKey = this.generateGroupKeysJoin(newData, this.eventPerGroupJoinBuf, true);
            Object[][] oldDataMultiKey = this.generateGroupKeysJoin(oldData, this.eventPerGroupJoinBuf, false);
            if (this.prototype.isSelectRStream()) {
                this.generateOutputBatchedCollectJoin(this.eventPerGroupJoinBuf, false, generateSynthetic, oldEvents, oldEventsSortKey);
            }
            if (newData != null) {
                count = 0;
                for (MultiKey<EventBean> newEvent : newData) {
                    this.aggregationService.applyEnter(newEvent.getArray(), newDataMultiKey[count++], this.agentInstanceContext);
                }
            }
            if (oldData != null) {
                count = 0;
                for (MultiKey<EventBean> oldEvent : oldData) {
                    this.aggregationService.applyLeave(oldEvent.getArray(), oldDataMultiKey[count++], this.agentInstanceContext);
                }
            }
            this.generateOutputBatchedCollectJoin(this.eventPerGroupJoinBuf, true, generateSynthetic, newEvents, newEventsSortKey);
        }
        return this.convertToArrayMaySort(newEvents, newEventsSortKey, oldEvents, oldEventsSortKey);
    }

    @Override
    public boolean hasAggregation() {
        return true;
    }

    @Override
    public void removed(Object key) {
        throw new UnsupportedOperationException();
    }

    protected Object generateGroupKey(EventBean[] eventsPerStream, boolean isNewData) {
        if (this.prototype.getGroupKeyNode() != null) {
            return this.prototype.getGroupKeyNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext);
        }
        ExprEvaluator[] evals = this.prototype.getGroupKeyNodes();
        Object[] keys = new Object[evals.length];
        for (int i = 0; i < evals.length; ++i) {
            keys[i] = evals[i].evaluate(eventsPerStream, isNewData, this.agentInstanceContext);
        }
        return new MultiKeyUntyped(keys);
    }

    private void generateOutputBatched(boolean join, Object mk, AggregationGroupByRollupLevel level, EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, List<EventBean>[] resultEvents, List<Object>[] optSortKeys) {
        List<EventBean> resultList = resultEvents[level.getLevelNumber()];
        List<Object> sortKeys = optSortKeys == null ? null : optSortKeys[level.getLevelNumber()];
        this.generateOutputBatched(join, mk, level, eventsPerStream, isNewData, isSynthesize, resultList, sortKeys);
    }

    protected void generateOutputBatched(boolean join, Object mk, AggregationGroupByRollupLevel level, EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents, List<Object> optSortKeys) {
        Boolean result;
        this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceId(), level);
        if (!(this.prototype.getPerLevelExpression().getOptionalHavingNodes() == null || (result = (Boolean)this.prototype.getPerLevelExpression().getOptionalHavingNodes()[level.getLevelNumber()].evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) != null && result.booleanValue())) {
            return;
        }
        resultEvents.add(this.prototype.getPerLevelExpression().getSelectExprProcessor()[level.getLevelNumber()].process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext));
        if (this.prototype.isSorting()) {
            optSortKeys.add(this.orderByProcessor.getSortKey(eventsPerStream, isNewData, this.agentInstanceContext, this.prototype.getPerLevelExpression().getOptionalOrderByElements()[level.getLevelNumber()]));
        }
    }

    protected void generateOutputBatchedMapUnsorted(boolean join, Object mk, AggregationGroupByRollupLevel level, EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, Map<Object, EventBean> resultEvents) {
        Boolean result;
        this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceId(), level);
        if (!(this.prototype.getPerLevelExpression().getOptionalHavingNodes() == null || (result = (Boolean)this.prototype.getPerLevelExpression().getOptionalHavingNodes()[level.getLevelNumber()].evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) != null && result.booleanValue())) {
            return;
        }
        resultEvents.put(mk, this.prototype.getPerLevelExpression().getSelectExprProcessor()[level.getLevelNumber()].process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext));
    }

    private UniformPair<EventBean[]> handleOutputLimitLastView(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic) {
        int oldEventCount = 0;
        if (this.prototype.isSelectRStream()) {
            this.rstreamEventSortArrayPair.reset();
        }
        for (Map<Object, EventBean[]> aGroupRepsView : this.outputLimitGroupRepsPerLevel) {
            aGroupRepsView.clear();
        }
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            Object groupKey;
            Object groupKeyComplete;
            EventBean[] eventsPerStream;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            Object[] groupKeysPerLevel = new Object[this.prototype.getGroupByRollupDesc().getLevels().length];
            if (newData != null) {
                for (EventBean aNewData : newData) {
                    eventsPerStream = new EventBean[]{aNewData};
                    groupKeyComplete = this.generateGroupKey(eventsPerStream, true);
                    for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                        groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                        if (this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, eventsPerStream) != null || !this.prototype.isSelectRStream()) continue;
                        this.generateOutputBatched(false, groupKey, level, eventsPerStream, true, generateSynthetic, this.rstreamEventSortArrayPair.getEventsPerLevel(), this.rstreamEventSortArrayPair.getSortKeyPerLevel());
                        ++oldEventCount;
                    }
                    this.aggregationService.applyEnter(eventsPerStream, groupKeysPerLevel, this.agentInstanceContext);
                }
            }
            if (oldData == null) continue;
            for (EventBean anOldData : oldData) {
                eventsPerStream = new EventBean[]{anOldData};
                groupKeyComplete = this.generateGroupKey(eventsPerStream, false);
                for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    if (this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, eventsPerStream) != null || !this.prototype.isSelectRStream()) continue;
                    this.generateOutputBatched(true, groupKey, level, eventsPerStream, true, generateSynthetic, this.rstreamEventSortArrayPair.getEventsPerLevel(), this.rstreamEventSortArrayPair.getSortKeyPerLevel());
                    ++oldEventCount;
                }
                this.aggregationService.applyLeave(eventsPerStream, groupKeysPerLevel, this.agentInstanceContext);
            }
        }
        return this.generateAndSort(this.outputLimitGroupRepsPerLevel, generateSynthetic, oldEventCount);
    }

    private UniformPair<EventBean[]> handleOutputLimitLastJoin(List<UniformPair<Set<MultiKey<EventBean>>>> viewEventsList, boolean generateSynthetic) {
        int oldEventCount = 0;
        if (this.prototype.isSelectRStream()) {
            this.rstreamEventSortArrayPair.reset();
        }
        for (Map<Object, EventBean[]> aGroupRepsView : this.outputLimitGroupRepsPerLevel) {
            aGroupRepsView.clear();
        }
        for (UniformPair<Set<MultiKey<EventBean>>> pair : viewEventsList) {
            Object groupKey;
            Object groupKeyComplete;
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            Object[] groupKeysPerLevel = new Object[this.prototype.getGroupByRollupDesc().getLevels().length];
            if (newData != null) {
                for (MultiKey<EventBean> aNewData : newData) {
                    groupKeyComplete = this.generateGroupKey(aNewData.getArray(), true);
                    for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                        groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                        if (this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, aNewData.getArray()) != null || !this.prototype.isSelectRStream()) continue;
                        this.generateOutputBatched(false, groupKey, level, aNewData.getArray(), true, generateSynthetic, this.rstreamEventSortArrayPair.getEventsPerLevel(), this.rstreamEventSortArrayPair.getSortKeyPerLevel());
                        ++oldEventCount;
                    }
                    this.aggregationService.applyEnter(aNewData.getArray(), groupKeysPerLevel, this.agentInstanceContext);
                }
            }
            if (oldData == null) continue;
            for (MultiKey<EventBean> anOldData : oldData) {
                groupKeyComplete = this.generateGroupKey(anOldData.getArray(), false);
                for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    if (this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, anOldData.getArray()) != null || !this.prototype.isSelectRStream()) continue;
                    this.generateOutputBatched(true, groupKey, level, anOldData.getArray(), true, generateSynthetic, this.rstreamEventSortArrayPair.getEventsPerLevel(), this.rstreamEventSortArrayPair.getSortKeyPerLevel());
                    ++oldEventCount;
                }
                this.aggregationService.applyLeave(anOldData.getArray(), groupKeysPerLevel, this.agentInstanceContext);
            }
        }
        return this.generateAndSort(this.outputLimitGroupRepsPerLevel, generateSynthetic, oldEventCount);
    }

    private UniformPair<EventBean[]> handleOutputLimitAllView(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic) {
        int oldEventCount = 0;
        if (this.prototype.isSelectRStream()) {
            this.rstreamEventSortArrayPair.reset();
            for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                Map<Object, EventBean[]> groupGenerators = this.outputLimitGroupRepsPerLevel[level.getLevelNumber()];
                for (Map.Entry<Object, EventBean[]> entry : groupGenerators.entrySet()) {
                    this.generateOutputBatched(false, entry.getKey(), level, entry.getValue(), false, generateSynthetic, this.rstreamEventSortArrayPair.getEventsPerLevel(), this.rstreamEventSortArrayPair.getSortKeyPerLevel());
                    ++oldEventCount;
                }
            }
        }
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            EventBean[] existing;
            Object groupKey;
            Object groupKeyComplete;
            EventBean[] eventsPerStream;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            Object[] groupKeysPerLevel = new Object[this.prototype.getGroupByRollupDesc().getLevels().length];
            if (newData != null) {
                for (EventBean aNewData : newData) {
                    eventsPerStream = new EventBean[]{aNewData};
                    groupKeyComplete = this.generateGroupKey(eventsPerStream, true);
                    for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                        groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                        existing = this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, eventsPerStream);
                        if (existing != null || !this.prototype.isSelectRStream()) continue;
                        this.generateOutputBatched(false, groupKey, level, eventsPerStream, true, generateSynthetic, this.rstreamEventSortArrayPair.getEventsPerLevel(), this.rstreamEventSortArrayPair.getSortKeyPerLevel());
                        ++oldEventCount;
                    }
                    this.aggregationService.applyEnter(eventsPerStream, groupKeysPerLevel, this.agentInstanceContext);
                }
            }
            if (oldData == null) continue;
            for (EventBean anOldData : oldData) {
                eventsPerStream = new EventBean[]{anOldData};
                groupKeyComplete = this.generateGroupKey(eventsPerStream, false);
                for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    existing = this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, eventsPerStream);
                    if (existing != null || !this.prototype.isSelectRStream()) continue;
                    this.generateOutputBatched(false, groupKey, level, eventsPerStream, false, generateSynthetic, this.rstreamEventSortArrayPair.getEventsPerLevel(), this.rstreamEventSortArrayPair.getSortKeyPerLevel());
                    ++oldEventCount;
                }
                this.aggregationService.applyLeave(eventsPerStream, groupKeysPerLevel, this.agentInstanceContext);
            }
        }
        return this.generateAndSort(this.outputLimitGroupRepsPerLevel, generateSynthetic, oldEventCount);
    }

    private UniformPair<EventBean[]> handleOutputLimitAllJoin(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic) {
        int oldEventCount = 0;
        if (this.prototype.isSelectRStream()) {
            this.rstreamEventSortArrayPair.reset();
            for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                Map<Object, EventBean[]> groupGenerators = this.outputLimitGroupRepsPerLevel[level.getLevelNumber()];
                for (Map.Entry entry : groupGenerators.entrySet()) {
                    this.generateOutputBatched(false, entry.getKey(), level, (EventBean[])entry.getValue(), false, generateSynthetic, this.rstreamEventSortArrayPair.getEventsPerLevel(), this.rstreamEventSortArrayPair.getSortKeyPerLevel());
                    ++oldEventCount;
                }
            }
        }
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
            T[] existing;
            Object groupKey;
            Object groupKeyComplete;
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            Object[] groupKeysPerLevel = new Object[this.prototype.getGroupByRollupDesc().getLevels().length];
            if (newData != null) {
                for (MultiKey multiKey : newData) {
                    groupKeyComplete = this.generateGroupKey((EventBean[])multiKey.getArray(), true);
                    for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                        groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                        existing = this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, (EventBean[])multiKey.getArray());
                        if (existing != null || !this.prototype.isSelectRStream()) continue;
                        this.generateOutputBatched(false, groupKey, level, (EventBean[])multiKey.getArray(), true, generateSynthetic, this.rstreamEventSortArrayPair.getEventsPerLevel(), this.rstreamEventSortArrayPair.getSortKeyPerLevel());
                        ++oldEventCount;
                    }
                    this.aggregationService.applyEnter((EventBean[])multiKey.getArray(), groupKeysPerLevel, this.agentInstanceContext);
                }
            }
            if (oldData == null) continue;
            for (MultiKey multiKey : oldData) {
                groupKeyComplete = this.generateGroupKey((EventBean[])multiKey.getArray(), false);
                for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    existing = this.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, (EventBean[])multiKey.getArray());
                    if (existing != null || !this.prototype.isSelectRStream()) continue;
                    this.generateOutputBatched(false, groupKey, level, (EventBean[])multiKey.getArray(), false, generateSynthetic, this.rstreamEventSortArrayPair.getEventsPerLevel(), this.rstreamEventSortArrayPair.getSortKeyPerLevel());
                    ++oldEventCount;
                }
                this.aggregationService.applyLeave((EventBean[])multiKey.getArray(), groupKeysPerLevel, this.agentInstanceContext);
            }
        }
        return this.generateAndSort(this.outputLimitGroupRepsPerLevel, generateSynthetic, oldEventCount);
    }

    private void generateOutputBatchedCollectNonJoin(Map<Object, EventBean>[] eventPairs, boolean isNewData, boolean generateSynthetic, List<EventBean> events, List<Object> sortKey) {
        AggregationGroupByRollupLevel[] levels = this.prototype.getGroupByRollupDesc().getLevels();
        EventBean[] eventsPerStream = new EventBean[1];
        for (AggregationGroupByRollupLevel level : levels) {
            Map<Object, EventBean> eventsForLevel = eventPairs[level.getLevelNumber()];
            for (Map.Entry<Object, EventBean> pair : eventsForLevel.entrySet()) {
                eventsPerStream[0] = pair.getValue();
                this.generateOutputBatched(false, pair.getKey(), level, eventsPerStream, isNewData, generateSynthetic, events, sortKey);
            }
        }
    }

    private void generateOutputBatchedCollectJoin(Map<Object, EventBean[]>[] eventPairs, boolean isNewData, boolean generateSynthetic, List<EventBean> events, List<Object> sortKey) {
        AggregationGroupByRollupLevel[] levels;
        for (AggregationGroupByRollupLevel level : levels = this.prototype.getGroupByRollupDesc().getLevels()) {
            Map<Object, EventBean[]> eventsForLevel = eventPairs[level.getLevelNumber()];
            for (Map.Entry<Object, EventBean[]> pair : eventsForLevel.entrySet()) {
                this.generateOutputBatched(false, pair.getKey(), level, pair.getValue(), isNewData, generateSynthetic, events, sortKey);
            }
        }
    }

    private void resetEventPerGroupBuf() {
        for (Map<Object, EventBean> anEventPerGroupBuf : this.eventPerGroupBuf) {
            anEventPerGroupBuf.clear();
        }
    }

    private void resetEventPerGroupJoinBuf() {
        for (Map<Object, EventBean[]> anEventPerGroupBuf : this.eventPerGroupJoinBuf) {
            anEventPerGroupBuf.clear();
        }
    }

    private EventsAndSortKeysPair getOldEventsSortKeys(int oldEventCount, List<EventBean>[] oldEventsPerLevel, List<Object>[] oldEventsSortKeyPerLevel) {
        EventBean[] oldEventsArr = new EventBean[oldEventCount];
        Object[] oldEventsSortKeys = null;
        if (this.orderByProcessor != null) {
            oldEventsSortKeys = new Object[oldEventCount];
        }
        int countEvents = 0;
        int countSortKeys = 0;
        for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
            List<EventBean> events = oldEventsPerLevel[level.getLevelNumber()];
            for (EventBean event : events) {
                oldEventsArr[countEvents++] = event;
            }
            if (this.orderByProcessor == null) continue;
            List<Object> sortKeys = oldEventsSortKeyPerLevel[level.getLevelNumber()];
            for (Object sortKey : sortKeys) {
                oldEventsSortKeys[countSortKeys++] = sortKey;
            }
        }
        return new EventsAndSortKeysPair(oldEventsArr, oldEventsSortKeys);
    }

    protected Object[][] generateGroupKeysView(EventBean[] events, Map<Object, EventBean>[] eventPerKey, boolean isNewData) {
        if (events == null) {
            return null;
        }
        Object[][] result = new Object[events.length][];
        EventBean[] eventsPerStream = new EventBean[1];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            Object groupKeyComplete = this.generateGroupKey(eventsPerStream, isNewData);
            AggregationGroupByRollupLevel[] levels = this.prototype.getGroupByRollupDesc().getLevels();
            result[i] = new Object[levels.length];
            for (int j = 0; j < levels.length; ++j) {
                Object subkey;
                result[i][j] = subkey = levels[j].computeSubkey(groupKeyComplete);
                eventPerKey[levels[j].getLevelNumber()].put(subkey, events[i]);
            }
        }
        return result;
    }

    private Object[][] generateGroupKeysJoin(Set<MultiKey<EventBean>> events, Map<Object, EventBean[]>[] eventPerKey, boolean isNewData) {
        if (events == null || events.isEmpty()) {
            return null;
        }
        Object[][] result = new Object[events.size()][];
        int count = -1;
        for (MultiKey<EventBean> eventrow : events) {
            Object groupKeyComplete = this.generateGroupKey(eventrow.getArray(), isNewData);
            AggregationGroupByRollupLevel[] levels = this.prototype.getGroupByRollupDesc().getLevels();
            result[++count] = new Object[levels.length];
            for (int j = 0; j < levels.length; ++j) {
                Object subkey;
                result[count][j] = subkey = levels[j].computeSubkey(groupKeyComplete);
                eventPerKey[levels[j].getLevelNumber()].put(subkey, eventrow.getArray());
            }
        }
        return result;
    }

    private UniformPair<EventBean[]> generateAndSort(Map<Object, EventBean[]>[] outputLimitGroupRepsPerLevel, boolean generateSynthetic, int oldEventCount) {
        EventBean[] newEventsArr;
        EventBean[] oldEventsArr = null;
        Object[] oldEventSortKeys = null;
        if (this.prototype.isSelectRStream() && oldEventCount > 0) {
            EventsAndSortKeysPair pair = this.getOldEventsSortKeys(oldEventCount, this.rstreamEventSortArrayPair.getEventsPerLevel(), this.rstreamEventSortArrayPair.getSortKeyPerLevel());
            oldEventsArr = pair.getEvents();
            oldEventSortKeys = pair.getSortKeys();
        }
        ArrayList<EventBean> newEvents = new ArrayList<EventBean>();
        ArrayList<Object> newEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new ArrayList<Object>();
        }
        for (AggregationGroupByRollupLevel level : this.prototype.getGroupByRollupDesc().getLevels()) {
            Map<Object, EventBean[]> groupGenerators = outputLimitGroupRepsPerLevel[level.getLevelNumber()];
            for (Map.Entry<Object, EventBean[]> entry : groupGenerators.entrySet()) {
                this.generateOutputBatched(false, entry.getKey(), level, entry.getValue(), true, generateSynthetic, newEvents, newEventsSortKey);
            }
        }
        EventBean[] eventBeanArray = newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, oldEventSortKeys, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    @Override
    public void applyViewResult(EventBean[] newData, EventBean[] oldData) {
        Object[] keys;
        int i$;
        int len$;
        EventBean[] arr$;
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            arr$ = newData;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                EventBean aNewData;
                eventsPerStream[0] = aNewData = arr$[i$];
                keys = this.generateGroupKeysNonJoin(eventsPerStream, true);
                this.aggregationService.applyEnter(eventsPerStream, keys, this.agentInstanceContext);
            }
        }
        if (oldData != null) {
            arr$ = oldData;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                EventBean anOldData;
                eventsPerStream[0] = anOldData = arr$[i$];
                keys = this.generateGroupKeysNonJoin(eventsPerStream, false);
                this.aggregationService.applyLeave(eventsPerStream, keys, this.agentInstanceContext);
            }
        }
    }

    @Override
    public void applyJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents) {
        Object[] keys;
        if (newEvents != null) {
            for (MultiKey<EventBean> mk : newEvents) {
                keys = this.generateGroupKeysNonJoin(mk.getArray(), true);
                this.aggregationService.applyEnter(mk.getArray(), keys, this.agentInstanceContext);
            }
        }
        if (oldEvents != null) {
            for (MultiKey<EventBean> mk : oldEvents) {
                keys = this.generateGroupKeysNonJoin(mk.getArray(), false);
                this.aggregationService.applyLeave(mk.getArray(), keys, this.agentInstanceContext);
            }
        }
    }

    @Override
    public void processOutputLimitedLastAllNonBufferedView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic, boolean isAll) {
        if (isAll) {
            this.outputAllHelper.processView(newData, oldData, isGenerateSynthetic);
        } else {
            this.outputLastHelper.processView(newData, oldData, isGenerateSynthetic);
        }
    }

    @Override
    public void processOutputLimitedLastAllNonBufferedJoin(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isGenerateSynthetic, boolean isAll) {
        if (isAll) {
            this.outputAllHelper.processJoin(newEvents, oldEvents, isGenerateSynthetic);
        } else {
            this.outputLastHelper.processJoin(newEvents, oldEvents, isGenerateSynthetic);
        }
    }

    @Override
    public UniformPair<EventBean[]> continueOutputLimitedLastAllNonBufferedView(boolean isSynthesize, boolean isAll) {
        if (isAll) {
            return this.outputAllHelper.outputView(isSynthesize);
        }
        return this.outputLastHelper.outputView(isSynthesize);
    }

    @Override
    public UniformPair<EventBean[]> continueOutputLimitedLastAllNonBufferedJoin(boolean isSynthesize, boolean isAll) {
        if (isAll) {
            return this.outputAllHelper.outputJoin(isSynthesize);
        }
        return this.outputLastHelper.outputJoin(isSynthesize);
    }

    private UniformPair<EventBean[]> convertToArrayMaySort(List<EventBean> newEvents, List<Object> newEventsSortKey, List<EventBean> oldEvents, List<Object> oldEventsSortKey) {
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private EPException handleConditionValidationException(ExprValidationException e) {
        return new EPException("Error starting output limit for group for statement '" + this.agentInstanceContext.getStatementContext().getStatementName() + "': " + e.getMessage(), e);
    }

    private Object[] generateGroupKeysNonJoin(EventBean[] eventsPerStream, boolean isNewData) {
        Object groupKeyComplete = this.generateGroupKey(eventsPerStream, true);
        AggregationGroupByRollupLevel[] levels = this.prototype.getGroupByRollupDesc().getLevels();
        Object[] result = new Object[levels.length];
        for (int j = 0; j < levels.length; ++j) {
            Object subkey;
            result[j] = subkey = levels[j].computeSubkey(groupKeyComplete);
        }
        return result;
    }

    private static class EventsAndSortKeysPair {
        private final EventBean[] events;
        private final Object[] sortKeys;

        private EventsAndSortKeysPair(EventBean[] events, Object[] sortKeys) {
            this.events = events;
            this.sortKeys = sortKeys;
        }

        public EventBean[] getEvents() {
            return this.events;
        }

        public Object[] getSortKeys() {
            return this.sortKeys;
        }
    }

    private static class EventArrayAndSortKeyArray {
        private final List<EventBean>[] eventsPerLevel;
        private final List<Object>[] sortKeyPerLevel;

        private EventArrayAndSortKeyArray(List<EventBean>[] eventsPerLevel, List<Object>[] sortKeyPerLevel) {
            this.eventsPerLevel = eventsPerLevel;
            this.sortKeyPerLevel = sortKeyPerLevel;
        }

        public List<EventBean>[] getEventsPerLevel() {
            return this.eventsPerLevel;
        }

        public List<Object>[] getSortKeyPerLevel() {
            return this.sortKeyPerLevel;
        }

        public void reset() {
            for (List<EventBean> anEventsPerLevel : this.eventsPerLevel) {
                anEventsPerLevel.clear();
            }
            if (this.sortKeyPerLevel != null) {
                for (List<Object> anSortKeyPerLevel : this.sortKeyPerLevel) {
                    anSortKeyPerLevel.clear();
                }
            }
        }
    }
}

