/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.rollup.GroupByRollupPerLevelExpression;
import com.espertech.esper.epl.agg.service.AggregationGroupByRollupDesc;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorFactory;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupRollup;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupRollupUnbound;
import com.espertech.esper.epl.core.ResultSetProcessorType;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitSpec;

public class ResultSetProcessorRowPerGroupRollupFactory
implements ResultSetProcessorFactory {
    private final GroupByRollupPerLevelExpression perLevelExpression;
    private final ExprNode[] groupKeyNodeExpressions;
    private final ExprEvaluator groupKeyNode;
    private final ExprEvaluator[] groupKeyNodes;
    private final boolean isSorting;
    private final boolean isSelectRStream;
    private final boolean isUnidirectional;
    private final OutputLimitSpec outputLimitSpec;
    private final boolean noDataWindowSingleSnapshot;
    private final AggregationGroupByRollupDesc groupByRollupDesc;
    private final boolean isJoin;
    private final boolean isHistoricalOnly;

    public ResultSetProcessorRowPerGroupRollupFactory(GroupByRollupPerLevelExpression perLevelExpression, ExprNode[] groupKeyNodeExpressions, ExprEvaluator[] groupKeyNodes, boolean isSelectRStream, boolean isUnidirectional, OutputLimitSpec outputLimitSpec, boolean isSorting, boolean noDataWindowSingleStream, AggregationGroupByRollupDesc groupByRollupDesc, boolean isJoin, boolean isHistoricalOnly, boolean iterateUnbounded) {
        this.groupKeyNodeExpressions = groupKeyNodeExpressions;
        this.perLevelExpression = perLevelExpression;
        this.groupKeyNodes = groupKeyNodes;
        this.groupKeyNode = groupKeyNodes.length == 1 ? groupKeyNodes[0] : null;
        this.isSorting = isSorting;
        this.isSelectRStream = isSelectRStream;
        this.isUnidirectional = isUnidirectional;
        this.outputLimitSpec = outputLimitSpec;
        this.noDataWindowSingleSnapshot = iterateUnbounded || outputLimitSpec != null && outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.SNAPSHOT && noDataWindowSingleStream;
        this.groupByRollupDesc = groupByRollupDesc;
        this.isJoin = isJoin;
        this.isHistoricalOnly = isHistoricalOnly;
    }

    @Override
    public ResultSetProcessor instantiate(OrderByProcessor orderByProcessor, AggregationService aggregationService, AgentInstanceContext agentInstanceContext) {
        if (this.noDataWindowSingleSnapshot && !this.isHistoricalOnly) {
            return new ResultSetProcessorRowPerGroupRollupUnbound(this, orderByProcessor, aggregationService, agentInstanceContext);
        }
        return new ResultSetProcessorRowPerGroupRollup(this, orderByProcessor, aggregationService, agentInstanceContext);
    }

    @Override
    public EventType getResultEventType() {
        return this.perLevelExpression.getSelectExprProcessor()[0].getResultEventType();
    }

    @Override
    public boolean hasAggregation() {
        return true;
    }

    public ExprEvaluator[] getGroupKeyNodes() {
        return this.groupKeyNodes;
    }

    public ExprEvaluator getGroupKeyNode() {
        return this.groupKeyNode;
    }

    public boolean isSorting() {
        return this.isSorting;
    }

    public boolean isSelectRStream() {
        return this.isSelectRStream;
    }

    public boolean isUnidirectional() {
        return this.isUnidirectional;
    }

    public OutputLimitSpec getOutputLimitSpec() {
        return this.outputLimitSpec;
    }

    public ExprNode[] getGroupKeyNodeExpressions() {
        return this.groupKeyNodeExpressions;
    }

    public AggregationGroupByRollupDesc getGroupByRollupDesc() {
        return this.groupByRollupDesc;
    }

    public GroupByRollupPerLevelExpression getPerLevelExpression() {
        return this.perLevelExpression;
    }

    public boolean isJoin() {
        return this.isJoin;
    }

    public boolean isHistoricalOnly() {
        return this.isHistoricalOnly;
    }

    @Override
    public ResultSetProcessorType getResultSetProcessorType() {
        return ResultSetProcessorType.FULLYAGGREGATED_GROUPED_ROLLUP;
    }
}

