/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.agg.service.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupRollup;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ResultSetProcessorRowPerGroupRollupOutputAllHelper {
    private final ResultSetProcessorRowPerGroupRollup processor;
    private final Map<Object, EventBean>[] groupRepsOutputLastUnordRStream;
    private boolean first;

    public ResultSetProcessorRowPerGroupRollupOutputAllHelper(ResultSetProcessorRowPerGroupRollup processor, int levelCount) {
        this.processor = processor;
        this.groupRepsOutputLastUnordRStream = new LinkedHashMap[levelCount];
        for (int i = 0; i < levelCount; ++i) {
            this.groupRepsOutputLastUnordRStream[i] = new LinkedHashMap<Object, EventBean>();
        }
    }

    public void processView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic) {
        Object groupKey;
        Object groupKeyComplete;
        EventBean[] eventsPerStream;
        this.generateRemoveStreamJustOnce(isGenerateSynthetic, false);
        Object[] groupKeysPerLevel = new Object[this.processor.prototype.getGroupByRollupDesc().getLevels().length];
        if (newData != null) {
            for (EventBean aNewData : newData) {
                eventsPerStream = new EventBean[]{aNewData};
                groupKeyComplete = this.processor.generateGroupKey(eventsPerStream, true);
                for (AggregationGroupByRollupLevel level : this.processor.prototype.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    if (this.processor.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, eventsPerStream) != null || !this.processor.prototype.isSelectRStream()) continue;
                    this.processor.generateOutputBatchedMapUnsorted(false, groupKey, level, eventsPerStream, true, isGenerateSynthetic, this.groupRepsOutputLastUnordRStream[level.getLevelNumber()]);
                }
                this.processor.aggregationService.applyEnter(eventsPerStream, groupKeysPerLevel, this.processor.agentInstanceContext);
            }
        }
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                eventsPerStream = new EventBean[]{anOldData};
                groupKeyComplete = this.processor.generateGroupKey(eventsPerStream, false);
                for (AggregationGroupByRollupLevel level : this.processor.prototype.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    if (this.processor.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, eventsPerStream) != null || !this.processor.prototype.isSelectRStream()) continue;
                    this.processor.generateOutputBatchedMapUnsorted(true, groupKey, level, eventsPerStream, false, isGenerateSynthetic, this.groupRepsOutputLastUnordRStream[level.getLevelNumber()]);
                }
                this.processor.aggregationService.applyLeave(eventsPerStream, groupKeysPerLevel, this.processor.agentInstanceContext);
            }
        }
    }

    public void processJoin(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isGenerateSynthetic) {
        Object groupKey;
        Object groupKeyComplete;
        this.generateRemoveStreamJustOnce(isGenerateSynthetic, true);
        Object[] groupKeysPerLevel = new Object[this.processor.prototype.getGroupByRollupDesc().getLevels().length];
        if (newEvents != null) {
            for (MultiKey<EventBean> newEvent : newEvents) {
                EventBean[] aNewData = newEvent.getArray();
                groupKeyComplete = this.processor.generateGroupKey(aNewData, true);
                for (AggregationGroupByRollupLevel level : this.processor.prototype.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    if (this.processor.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, aNewData) != null || !this.processor.prototype.isSelectRStream()) continue;
                    this.processor.generateOutputBatchedMapUnsorted(false, groupKey, level, aNewData, true, isGenerateSynthetic, this.groupRepsOutputLastUnordRStream[level.getLevelNumber()]);
                }
                this.processor.aggregationService.applyEnter(aNewData, groupKeysPerLevel, this.processor.agentInstanceContext);
            }
        }
        if (oldEvents != null) {
            for (MultiKey<EventBean> oldEvent : oldEvents) {
                EventBean[] aOldData = oldEvent.getArray();
                groupKeyComplete = this.processor.generateGroupKey(aOldData, false);
                for (AggregationGroupByRollupLevel level : this.processor.prototype.getGroupByRollupDesc().getLevels()) {
                    groupKeysPerLevel[level.getLevelNumber()] = groupKey = level.computeSubkey(groupKeyComplete);
                    if (this.processor.outputLimitGroupRepsPerLevel[level.getLevelNumber()].put(groupKey, aOldData) != null || !this.processor.prototype.isSelectRStream()) continue;
                    this.processor.generateOutputBatchedMapUnsorted(true, groupKey, level, aOldData, false, isGenerateSynthetic, this.groupRepsOutputLastUnordRStream[level.getLevelNumber()]);
                }
                this.processor.aggregationService.applyLeave(aOldData, groupKeysPerLevel, this.processor.agentInstanceContext);
            }
        }
    }

    public UniformPair<EventBean[]> outputView(boolean isSynthesize) {
        this.generateRemoveStreamJustOnce(isSynthesize, false);
        return this.output(isSynthesize, false);
    }

    public UniformPair<EventBean[]> outputJoin(boolean isSynthesize) {
        this.generateRemoveStreamJustOnce(isSynthesize, true);
        return this.output(isSynthesize, true);
    }

    private UniformPair<EventBean[]> output(boolean isSynthesize, boolean isJoin) {
        ArrayList<EventBean> newEvents = new ArrayList<EventBean>(4);
        for (AggregationGroupByRollupLevel level : this.processor.prototype.getGroupByRollupDesc().getLevels()) {
            Map<Object, EventBean[]> groupGenerators = this.processor.outputLimitGroupRepsPerLevel[level.getLevelNumber()];
            for (Map.Entry<Object, EventBean[]> entry : groupGenerators.entrySet()) {
                this.processor.generateOutputBatched(isJoin, entry.getKey(), level, entry.getValue(), true, isSynthesize, newEvents, null);
            }
        }
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.processor.prototype.isSelectRStream()) {
            ArrayList<EventBean> oldEventList = new ArrayList<EventBean>(4);
            for (Map<Object, EventBean> map : this.groupRepsOutputLastUnordRStream) {
                oldEventList.addAll(map.values());
                map.clear();
            }
            if (!oldEventList.isEmpty()) {
                oldEventsArr = oldEventList.toArray(new EventBean[oldEventList.size()]);
            }
        }
        this.first = true;
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<Object>(newEventsArr, oldEventsArr);
    }

    private void generateRemoveStreamJustOnce(boolean isSynthesize, boolean join) {
        if (this.first && this.processor.prototype.isSelectRStream()) {
            for (AggregationGroupByRollupLevel level : this.processor.prototype.getGroupByRollupDesc().getLevels()) {
                for (Map.Entry<Object, EventBean[]> groupRep : this.processor.outputLimitGroupRepsPerLevel[level.getLevelNumber()].entrySet()) {
                    Object groupKeyPartial = this.processor.generateGroupKey(groupRep.getValue(), false);
                    Object groupKey = level.computeSubkey(groupKeyPartial);
                    this.processor.generateOutputBatchedMapUnsorted(join, groupKey, level, groupRep.getValue(), false, isSynthesize, this.groupRepsOutputLastUnordRStream[level.getLevelNumber()]);
                }
            }
        }
        this.first = false;
    }
}

