/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorFactory;
import com.espertech.esper.epl.core.ResultSetProcessorSimple;
import com.espertech.esper.epl.core.ResultSetProcessorType;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitSpec;

public class ResultSetProcessorSimpleFactory
implements ResultSetProcessorFactory {
    private final boolean isSelectRStream;
    private final SelectExprProcessor selectExprProcessor;
    private final ExprEvaluator optionalHavingExpr;
    private final OutputLimitSpec outputLimitSpec;

    public ResultSetProcessorSimpleFactory(SelectExprProcessor selectExprProcessor, ExprEvaluator optionalHavingNode, boolean isSelectRStream, OutputLimitSpec outputLimitSpec) {
        this.selectExprProcessor = selectExprProcessor;
        this.optionalHavingExpr = optionalHavingNode;
        this.isSelectRStream = isSelectRStream;
        this.outputLimitSpec = outputLimitSpec;
    }

    @Override
    public ResultSetProcessorType getResultSetProcessorType() {
        return ResultSetProcessorType.UNAGGREGATED_UNGROUPED;
    }

    @Override
    public ResultSetProcessor instantiate(OrderByProcessor orderByProcessor, AggregationService aggregationService, AgentInstanceContext agentInstanceContext) {
        return new ResultSetProcessorSimple(this, this.selectExprProcessor, orderByProcessor, agentInstanceContext);
    }

    @Override
    public EventType getResultEventType() {
        return this.selectExprProcessor.getResultEventType();
    }

    @Override
    public boolean hasAggregation() {
        return false;
    }

    public boolean isSelectRStream() {
        return this.isSelectRStream;
    }

    public ExprEvaluator getOptionalHavingExpr() {
        return this.optionalHavingExpr;
    }

    public boolean isOutputLast() {
        return this.outputLimitSpec != null && this.outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.LAST;
    }

    public boolean isOutputAll() {
        return this.outputLimitSpec != null && this.outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.ALL;
    }
}

