/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.event.BaseNestableEventType;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanManufactureException;
import com.espertech.esper.event.EventBeanManufacturer;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.bean.EventBeanManufacturerCtor;
import com.espertech.esper.event.bean.InstanceManufacturerUtil;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.TypeWidener;
import com.espertech.esper.util.TypeWidenerFactory;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.reflect.FastConstructor;

public class SelectExprInsertEventBeanFactory {
    public static SelectExprProcessor getInsertUnderlyingNonJoin(EventAdapterService eventAdapterService, EventType eventType, boolean isUsingWildcard, StreamTypeService typeService, ExprEvaluator[] expressionNodes, String[] columnNames, Object[] expressionReturnTypes, EngineImportService engineImportService, InsertIntoDesc insertIntoDesc, String[] columnNamesAsProvided, boolean allowNestableTargetFragmentTypes) throws ExprValidationException {
        if (expressionReturnTypes.length == 1 && expressionReturnTypes[0] instanceof Class && eventType instanceof BaseNestableEventType && JavaClassHelper.isSubclassOrImplementsInterface((Class)expressionReturnTypes[0], eventType.getUnderlyingType()) && insertIntoDesc.getColumnNames().isEmpty() && columnNamesAsProvided[0] == null) {
            if (eventType instanceof MapEventType) {
                return new SelectExprInsertNativeExpressionCoerceMap(eventType, expressionNodes[0], eventAdapterService);
            }
            return new SelectExprInsertNativeExpressionCoerceObjectArray(eventType, expressionNodes[0], eventAdapterService);
        }
        if (eventType.getPropertyDescriptors().length == 0 && columnNames.length == 1 && columnNames[0].equals("null") && expressionReturnTypes[0] == null && !isUsingWildcard) {
            EventBeanManufacturer eventManufacturer;
            try {
                eventManufacturer = eventAdapterService.getManufacturer(eventType, new WriteablePropertyDescriptor[0], engineImportService, true);
            }
            catch (EventBeanManufactureException e) {
                throw new ExprValidationException(e.getMessage(), e);
            }
            return new SelectExprInsertNativeNoEval(eventType, eventManufacturer);
        }
        Set<WriteablePropertyDescriptor> writableProps = eventAdapterService.getWriteableProperties(eventType, false);
        boolean isEligible = SelectExprInsertEventBeanFactory.checkEligible(eventType, writableProps, allowNestableTargetFragmentTypes);
        if (!isEligible) {
            return null;
        }
        try {
            return SelectExprInsertEventBeanFactory.initializeSetterManufactor(eventType, writableProps, isUsingWildcard, typeService, expressionNodes, columnNames, expressionReturnTypes, engineImportService, eventAdapterService);
        }
        catch (ExprValidationException ex) {
            if (!(eventType instanceof BeanEventType)) {
                throw ex;
            }
            try {
                return SelectExprInsertEventBeanFactory.initializeCtorInjection((BeanEventType)eventType, expressionNodes, expressionReturnTypes, engineImportService, eventAdapterService);
            }
            catch (ExprValidationException ctorEx) {
                if (writableProps.isEmpty()) {
                    throw ctorEx;
                }
                throw ex;
            }
        }
    }

    public static SelectExprProcessor getInsertUnderlyingJoinWildcard(EventAdapterService eventAdapterService, EventType eventType, String[] streamNames, EventType[] streamTypes, EngineImportService engineImportService) throws ExprValidationException {
        Set<WriteablePropertyDescriptor> writableProps = eventAdapterService.getWriteableProperties(eventType, false);
        boolean isEligible = SelectExprInsertEventBeanFactory.checkEligible(eventType, writableProps, false);
        if (!isEligible) {
            return null;
        }
        try {
            return SelectExprInsertEventBeanFactory.initializeJoinWildcardInternal(eventType, writableProps, streamNames, streamTypes, engineImportService, eventAdapterService);
        }
        catch (ExprValidationException ex) {
            if (!(eventType instanceof BeanEventType)) {
                throw ex;
            }
            try {
                ExprEvaluator[] evaluators = new ExprEvaluator[streamTypes.length];
                Object[] resultTypes = new Object[streamTypes.length];
                for (int i = 0; i < streamTypes.length; ++i) {
                    evaluators[i] = new ExprEvaluatorJoinWildcard(i, streamTypes[i].getUnderlyingType());
                    resultTypes[i] = evaluators[i].getType();
                }
                return SelectExprInsertEventBeanFactory.initializeCtorInjection((BeanEventType)eventType, evaluators, resultTypes, engineImportService, eventAdapterService);
            }
            catch (ExprValidationException ctorEx) {
                if (writableProps.isEmpty()) {
                    throw ctorEx;
                }
                throw ex;
            }
        }
    }

    private static boolean checkEligible(EventType eventType, Set<WriteablePropertyDescriptor> writableProps, boolean allowNestableTargetFragmentTypes) {
        if (writableProps == null) {
            return false;
        }
        if (!allowNestableTargetFragmentTypes && eventType instanceof BaseNestableEventType) {
            for (EventPropertyDescriptor prop : eventType.getPropertyDescriptors()) {
                if (!prop.isFragment()) continue;
                return false;
            }
        }
        return true;
    }

    private static SelectExprProcessor initializeSetterManufactor(EventType eventType, Set<WriteablePropertyDescriptor> writables, boolean isUsingWildcard, StreamTypeService typeService, ExprEvaluator[] expressionNodes, String[] columnNames, Object[] expressionReturnTypes, EngineImportService engineImportService, EventAdapterService eventAdapterService) throws ExprValidationException {
        EventBeanManufacturer eventManufacturer;
        ArrayList<WriteablePropertyDescriptor> writablePropertiesList = new ArrayList<WriteablePropertyDescriptor>();
        ArrayList<ExprEvaluator> evaluatorsList = new ArrayList<ExprEvaluator>();
        ArrayList<TypeWidener> widenersList = new ArrayList<TypeWidener>();
        for (int i = 0; i < columnNames.length; ++i) {
            WriteablePropertyDescriptor selectedWritable = null;
            TypeWidener widener = null;
            ExprEvaluator evaluator = expressionNodes[i];
            for (WriteablePropertyDescriptor desc : writables) {
                EventType columnEventType;
                if (!desc.getPropertyName().equals(columnNames[i])) continue;
                Object columnType = expressionReturnTypes[i];
                if (columnType == null) {
                    TypeWidenerFactory.getCheckPropertyAssignType(columnNames[i], null, desc.getType(), desc.getPropertyName());
                } else if (columnType instanceof EventType) {
                    columnEventType = (EventType)columnType;
                    final Class returnType = columnEventType.getUnderlyingType();
                    widener = TypeWidenerFactory.getCheckPropertyAssignType(columnNames[i], columnEventType.getUnderlyingType(), desc.getType(), desc.getPropertyName());
                    if (JavaClassHelper.isSubclassOrImplementsInterface(returnType, desc.getType())) {
                        selectedWritable = desc;
                        widener = new TypeWidener(){

                            @Override
                            public Object widen(Object input) {
                                if (input instanceof EventBean) {
                                    return ((EventBean)input).getUnderlying();
                                }
                                return input;
                            }
                        };
                        continue;
                    }
                    int streamNum = 0;
                    for (int j = 0; j < typeService.getEventTypes().length; ++j) {
                        if (typeService.getEventTypes()[j] != columnEventType) continue;
                        streamNum = j;
                        break;
                    }
                    final int streamNumEval = streamNum;
                    evaluator = new ExprEvaluator(){

                        @Override
                        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                            EventBean theEvent = eventsPerStream[streamNumEval];
                            if (theEvent != null) {
                                return theEvent.getUnderlying();
                            }
                            return null;
                        }

                        @Override
                        public Class getType() {
                            return returnType;
                        }
                    };
                } else if (columnType instanceof EventType[]) {
                    columnEventType = ((EventType[])columnType)[0];
                    final Class componentReturnType = columnEventType.getUnderlyingType();
                    Class<?> arrayReturnType = Array.newInstance(componentReturnType, 0).getClass();
                    widener = TypeWidenerFactory.getCheckPropertyAssignType(columnNames[i], arrayReturnType, desc.getType(), desc.getPropertyName());
                    final ExprEvaluator inner = evaluator;
                    evaluator = new ExprEvaluator(){

                        @Override
                        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                            Object result = inner.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                            if (!(result instanceof EventBean[])) {
                                return null;
                            }
                            EventBean[] events = (EventBean[])result;
                            Object values = Array.newInstance(componentReturnType, events.length);
                            for (int i = 0; i < events.length; ++i) {
                                Array.set(values, i, events[i].getUnderlying());
                            }
                            return values;
                        }

                        @Override
                        public Class getType() {
                            return componentReturnType;
                        }
                    };
                } else {
                    if (!(columnType instanceof Class)) {
                        String message = "Invalid assignment of column '" + columnNames[i] + "' of type '" + columnType + "' to event property '" + desc.getPropertyName() + "' typed as '" + desc.getType().getName() + "', column and parameter types mismatch";
                        throw new ExprValidationException(message);
                    }
                    widener = TypeWidenerFactory.getCheckPropertyAssignType(columnNames[i], (Class)columnType, desc.getType(), desc.getPropertyName());
                }
                selectedWritable = desc;
                break;
            }
            if (selectedWritable == null) {
                String message = "Column '" + columnNames[i] + "' could not be assigned to any of the properties of the underlying type (missing column names, event property, setter method or constructor?)";
                throw new ExprValidationException(message);
            }
            writablePropertiesList.add(selectedWritable);
            evaluatorsList.add(evaluator);
            widenersList.add(widener);
        }
        if (isUsingWildcard) {
            EventType sourceType = typeService.getEventTypes()[0];
            for (EventPropertyDescriptor eventPropDescriptor : sourceType.getPropertyDescriptors()) {
                if (eventPropDescriptor.isRequiresIndex() || eventPropDescriptor.isRequiresMapkey()) continue;
                WriteablePropertyDescriptor selectedWritable = null;
                TypeWidener widener = null;
                ExprEvaluator evaluator = null;
                for (WriteablePropertyDescriptor writableDesc : writables) {
                    if (!writableDesc.getPropertyName().equals(eventPropDescriptor.getPropertyName())) continue;
                    widener = TypeWidenerFactory.getCheckPropertyAssignType(eventPropDescriptor.getPropertyName(), eventPropDescriptor.getPropertyType(), writableDesc.getType(), writableDesc.getPropertyName());
                    selectedWritable = writableDesc;
                    final String propertyName = eventPropDescriptor.getPropertyName();
                    final Class propertyType = eventPropDescriptor.getPropertyType();
                    evaluator = new ExprEvaluator(){

                        @Override
                        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                            EventBean theEvent = eventsPerStream[0];
                            if (theEvent != null) {
                                return theEvent.get(propertyName);
                            }
                            return null;
                        }

                        @Override
                        public Class getType() {
                            return propertyType;
                        }
                    };
                    break;
                }
                if (selectedWritable == null) {
                    String message = "Event property '" + eventPropDescriptor.getPropertyName() + "' could not be assigned to any of the properties of the underlying type (missing column names, event property, setter method or constructor?)";
                    throw new ExprValidationException(message);
                }
                writablePropertiesList.add(selectedWritable);
                evaluatorsList.add(evaluator);
                widenersList.add(widener);
            }
        }
        WriteablePropertyDescriptor[] writableProperties = writablePropertiesList.toArray(new WriteablePropertyDescriptor[writablePropertiesList.size()]);
        ExprEvaluator[] exprEvaluators = evaluatorsList.toArray(new ExprEvaluator[evaluatorsList.size()]);
        TypeWidener[] wideners = widenersList.toArray(new TypeWidener[widenersList.size()]);
        try {
            eventManufacturer = eventAdapterService.getManufacturer(eventType, writableProperties, engineImportService, false);
        }
        catch (EventBeanManufactureException e) {
            throw new ExprValidationException(e.getMessage(), e);
        }
        return new SelectExprInsertNativeWidening(eventType, eventManufacturer, exprEvaluators, wideners);
    }

    private static SelectExprProcessor initializeCtorInjection(BeanEventType beanEventType, ExprEvaluator[] exprEvaluators, Object[] expressionReturnTypes, EngineImportService engineImportService, EventAdapterService eventAdapterService) throws ExprValidationException {
        Pair<FastConstructor, ExprEvaluator[]> pair = InstanceManufacturerUtil.getManufacturer(beanEventType.getUnderlyingType(), engineImportService, exprEvaluators, expressionReturnTypes);
        EventBeanManufacturerCtor eventManufacturer = new EventBeanManufacturerCtor(pair.getFirst(), beanEventType, eventAdapterService);
        return new SelectExprInsertNativeNoWiden(beanEventType, eventManufacturer, pair.getSecond());
    }

    private static SelectExprProcessor initializeJoinWildcardInternal(EventType eventType, Set<WriteablePropertyDescriptor> writables, String[] streamNames, EventType[] streamTypes, EngineImportService engineImportService, EventAdapterService eventAdapterService) throws ExprValidationException {
        EventBeanManufacturer eventManufacturer;
        ArrayList<WriteablePropertyDescriptor> writablePropertiesList = new ArrayList<WriteablePropertyDescriptor>();
        ArrayList<5> evaluatorsList = new ArrayList<5>();
        ArrayList<TypeWidener> widenersList = new ArrayList<TypeWidener>();
        int i = 0;
        while (i < streamNames.length) {
            WriteablePropertyDescriptor selectedWritable = null;
            TypeWidener widener = null;
            for (WriteablePropertyDescriptor desc : writables) {
                if (!desc.getPropertyName().equals(streamNames[i])) continue;
                widener = TypeWidenerFactory.getCheckPropertyAssignType(streamNames[i], streamTypes[i].getUnderlyingType(), desc.getType(), desc.getPropertyName());
                selectedWritable = desc;
                break;
            }
            if (selectedWritable == null) {
                String message = "Stream underlying object for stream '" + streamNames[i] + "' could not be assigned to any of the properties of the underlying type (missing column names, event property or setter method?)";
                throw new ExprValidationException(message);
            }
            final int streamNum = i++;
            final Class returnType = streamTypes[streamNum].getUnderlyingType();
            ExprEvaluator evaluator = new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    EventBean theEvent = eventsPerStream[streamNum];
                    if (theEvent != null) {
                        return theEvent.getUnderlying();
                    }
                    return null;
                }

                @Override
                public Class getType() {
                    return returnType;
                }
            };
            writablePropertiesList.add(selectedWritable);
            evaluatorsList.add(evaluator);
            widenersList.add(widener);
        }
        WriteablePropertyDescriptor[] writableProperties = writablePropertiesList.toArray(new WriteablePropertyDescriptor[writablePropertiesList.size()]);
        ExprEvaluator[] exprEvaluators = evaluatorsList.toArray(new ExprEvaluator[evaluatorsList.size()]);
        TypeWidener[] wideners = widenersList.toArray(new TypeWidener[widenersList.size()]);
        try {
            eventManufacturer = eventAdapterService.getManufacturer(eventType, writableProperties, engineImportService, false);
        }
        catch (EventBeanManufactureException e) {
            throw new ExprValidationException(e.getMessage(), e);
        }
        return new SelectExprInsertNativeWidening(eventType, eventManufacturer, exprEvaluators, wideners);
    }

    public static class ExprEvaluatorJoinWildcard
    implements ExprEvaluator {
        private final int streamNum;
        private final Class returnType;

        public ExprEvaluatorJoinWildcard(int streamNum, Class returnType) {
            this.streamNum = streamNum;
            this.returnType = returnType;
        }

        @Override
        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            EventBean bean = eventsPerStream[this.streamNum];
            if (bean == null) {
                return null;
            }
            return bean.getUnderlying();
        }

        @Override
        public Class getType() {
            return this.returnType;
        }
    }

    public static class SelectExprInsertNativeNoEval
    implements SelectExprProcessor {
        private static final Object[] EMPTY_PROPS = new Object[0];
        private final EventType eventType;
        private final EventBeanManufacturer eventManufacturer;

        public SelectExprInsertNativeNoEval(EventType eventType, EventBeanManufacturer eventManufacturer) {
            this.eventType = eventType;
            this.eventManufacturer = eventManufacturer;
        }

        @Override
        public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
            return this.eventManufacturer.make(EMPTY_PROPS);
        }

        @Override
        public EventType getResultEventType() {
            return this.eventType;
        }
    }

    public static class SelectExprInsertNativeNoWiden
    extends SelectExprInsertNativeBase {
        public SelectExprInsertNativeNoWiden(EventType eventType, EventBeanManufacturer eventManufacturer, ExprEvaluator[] exprEvaluators) {
            super(eventType, eventManufacturer, exprEvaluators);
        }

        @Override
        public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
            Object[] values = new Object[this.exprEvaluators.length];
            for (int i = 0; i < this.exprEvaluators.length; ++i) {
                Object evalResult;
                values[i] = evalResult = this.exprEvaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            }
            return this.eventManufacturer.make(values);
        }
    }

    public static class SelectExprInsertNativeWidening
    extends SelectExprInsertNativeBase {
        private final TypeWidener[] wideners;

        public SelectExprInsertNativeWidening(EventType eventType, EventBeanManufacturer eventManufacturer, ExprEvaluator[] exprEvaluators, TypeWidener[] wideners) {
            super(eventType, eventManufacturer, exprEvaluators);
            this.wideners = wideners;
        }

        @Override
        public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
            Object[] values = new Object[this.exprEvaluators.length];
            for (int i = 0; i < this.exprEvaluators.length; ++i) {
                Object evalResult = this.exprEvaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (evalResult != null && this.wideners[i] != null) {
                    evalResult = this.wideners[i].widen(evalResult);
                }
                values[i] = evalResult;
            }
            return this.eventManufacturer.make(values);
        }
    }

    public static abstract class SelectExprInsertNativeBase
    implements SelectExprProcessor {
        private final EventType eventType;
        protected final EventBeanManufacturer eventManufacturer;
        protected final ExprEvaluator[] exprEvaluators;

        protected SelectExprInsertNativeBase(EventType eventType, EventBeanManufacturer eventManufacturer, ExprEvaluator[] exprEvaluators) {
            this.eventType = eventType;
            this.eventManufacturer = eventManufacturer;
            this.exprEvaluators = exprEvaluators;
        }

        @Override
        public EventType getResultEventType() {
            return this.eventType;
        }
    }

    public static class SelectExprInsertNativeExpressionCoerceNative
    extends SelectExprInsertNativeExpressionCoerceBase {
        protected SelectExprInsertNativeExpressionCoerceNative(EventType eventType, ExprEvaluator exprEvaluator, EventAdapterService eventAdapterService) {
            super(eventType, exprEvaluator, eventAdapterService);
        }

        @Override
        public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
            Object result = this.exprEvaluator.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (result == null) {
                return null;
            }
            return this.eventAdapterService.adapterForTypedBean(result, this.eventType);
        }
    }

    public static class SelectExprInsertNativeExpressionCoerceObjectArray
    extends SelectExprInsertNativeExpressionCoerceBase {
        protected SelectExprInsertNativeExpressionCoerceObjectArray(EventType eventType, ExprEvaluator exprEvaluator, EventAdapterService eventAdapterService) {
            super(eventType, exprEvaluator, eventAdapterService);
        }

        @Override
        public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
            Object result = this.exprEvaluator.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (result == null) {
                return null;
            }
            return this.eventAdapterService.adapterForTypedObjectArray((Object[])result, this.eventType);
        }
    }

    public static class SelectExprInsertNativeExpressionCoerceMap
    extends SelectExprInsertNativeExpressionCoerceBase {
        protected SelectExprInsertNativeExpressionCoerceMap(EventType eventType, ExprEvaluator exprEvaluator, EventAdapterService eventAdapterService) {
            super(eventType, exprEvaluator, eventAdapterService);
        }

        @Override
        public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
            Object result = this.exprEvaluator.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (result == null) {
                return null;
            }
            return this.eventAdapterService.adapterForTypedMap((Map)result, this.eventType);
        }
    }

    public static abstract class SelectExprInsertNativeExpressionCoerceBase
    implements SelectExprProcessor {
        protected final EventType eventType;
        protected final ExprEvaluator exprEvaluator;
        protected final EventAdapterService eventAdapterService;

        protected SelectExprInsertNativeExpressionCoerceBase(EventType eventType, ExprEvaluator exprEvaluator, EventAdapterService eventAdapterService) {
            this.eventType = eventType;
            this.exprEvaluator = exprEvaluator;
            this.eventAdapterService = eventAdapterService;
        }

        @Override
        public EventType getResultEventType() {
            return this.eventType;
        }
    }
}

