/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.eval;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.eval.EvalSelectStreamBaseMap;
import com.espertech.esper.epl.core.eval.SelectExprContext;
import com.espertech.esper.epl.core.eval.SelectExprStreamDesc;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.event.DecoratingEventBean;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EvalSelectStreamWUnderlying
extends EvalSelectStreamBaseMap
implements SelectExprProcessor {
    private static final Log log = LogFactory.getLog(EvalSelectStreamWUnderlying.class);
    private final List<SelectExprStreamDesc> unnamedStreams;
    private final boolean singleStreamWrapper;
    private final boolean underlyingIsFragmentEvent;
    private final int underlyingStreamNumber;
    private final EventPropertyGetter underlyingPropertyEventGetter;
    private final ExprEvaluator underlyingExprEvaluator;
    private final TableMetadata tableMetadata;

    public EvalSelectStreamWUnderlying(SelectExprContext selectExprContext, EventType resultEventType, List<SelectClauseStreamCompiledSpec> namedStreams, boolean usingWildcard, List<SelectExprStreamDesc> unnamedStreams, boolean singleStreamWrapper, boolean underlyingIsFragmentEvent, int underlyingStreamNumber, EventPropertyGetter underlyingPropertyEventGetter, ExprEvaluator underlyingExprEvaluator, TableMetadata tableMetadata) {
        super(selectExprContext, resultEventType, namedStreams, usingWildcard);
        this.unnamedStreams = unnamedStreams;
        this.singleStreamWrapper = singleStreamWrapper;
        this.underlyingIsFragmentEvent = underlyingIsFragmentEvent;
        this.underlyingStreamNumber = underlyingStreamNumber;
        this.underlyingPropertyEventGetter = underlyingPropertyEventGetter;
        this.underlyingExprEvaluator = underlyingExprEvaluator;
        this.tableMetadata = tableMetadata;
    }

    @Override
    public EventBean processSpecific(Map<String, Object> props, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object value;
        DecoratingEventBean wrapper;
        if (this.singleStreamWrapper && (wrapper = (DecoratingEventBean)((Object)eventsPerStream[0])) != null) {
            Map<String, Object> map = wrapper.getDecoratingProperties();
            props.putAll(map);
        }
        EventBean theEvent = null;
        if (this.underlyingIsFragmentEvent) {
            EventBean eventBean = eventsPerStream[this.underlyingStreamNumber];
            theEvent = (EventBean)eventBean.getFragment(this.unnamedStreams.get(0).getStreamSelected().getStreamName());
        } else if (this.underlyingPropertyEventGetter != null) {
            value = this.underlyingPropertyEventGetter.get(eventsPerStream[this.underlyingStreamNumber]);
            if (value != null) {
                theEvent = super.getSelectExprContext().getEventAdapterService().adapterForBean(value);
            }
        } else if (this.underlyingExprEvaluator != null) {
            value = this.underlyingExprEvaluator.evaluate(eventsPerStream, true, exprEvaluatorContext);
            if (value != null) {
                theEvent = super.getSelectExprContext().getEventAdapterService().adapterForBean(value);
            }
        } else {
            theEvent = eventsPerStream[this.underlyingStreamNumber];
            if (this.tableMetadata != null && theEvent != null) {
                theEvent = this.tableMetadata.getEventToPublic().convert(theEvent, eventsPerStream, isNewData, exprEvaluatorContext);
            }
        }
        return super.getSelectExprContext().getEventAdapterService().adapterForTypedWrapper(theEvent, props, super.getResultEventType());
    }
}

