/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.calop;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.datetime.calop.CalendarOp;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.util.Calendar;

public class CalendarOpWithDate
implements CalendarOp {
    private ExprEvaluator year;
    private ExprEvaluator month;
    private ExprEvaluator day;

    public CalendarOpWithDate(ExprEvaluator year, ExprEvaluator month, ExprEvaluator day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    @Override
    public void evaluate(Calendar cal, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Integer yearNum = CalendarOpWithDate.getInt(this.year, eventsPerStream, isNewData, context);
        Integer monthNum = CalendarOpWithDate.getInt(this.month, eventsPerStream, isNewData, context);
        Integer dayNum = CalendarOpWithDate.getInt(this.day, eventsPerStream, isNewData, context);
        CalendarOpWithDate.action(cal, yearNum, monthNum, dayNum);
    }

    protected static Integer getInt(ExprEvaluator expr, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Object result = expr.evaluate(eventsPerStream, isNewData, context);
        if (result == null) {
            return null;
        }
        return (Integer)result;
    }

    private static void action(Calendar cal, Integer year, Integer month, Integer day) {
        if (year != null) {
            cal.set(1, year);
        }
        if (month != null) {
            cal.set(2, month);
        }
        if (day != null) {
            cal.set(5, day);
        }
    }
}

