/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.reformatop;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerFactory;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.datetime.eval.ExprDotNodeFilterAnalyzerDesc;
import com.espertech.esper.epl.datetime.reformatop.ReformatOp;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInput;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ReformatOpBetweenConstantParams
implements ReformatOp {
    private long first;
    private long second;

    public ReformatOpBetweenConstantParams(List<ExprNode> parameters) throws ExprValidationException {
        long paramFirst = this.getLongValue(parameters.get(0));
        long paramSecond = this.getLongValue(parameters.get(1));
        if (paramFirst > paramSecond) {
            this.second = paramFirst;
            this.first = paramSecond;
        } else {
            this.first = paramFirst;
            this.second = paramSecond;
        }
        if (parameters.size() > 2) {
            if (!this.getBooleanValue(parameters.get(2))) {
                ++this.first;
            }
            if (!this.getBooleanValue(parameters.get(3))) {
                --this.second;
            }
        }
    }

    private long getLongValue(ExprNode exprNode) throws ExprValidationException {
        Object value = exprNode.getExprEvaluator().evaluate(null, true, null);
        if (value == null) {
            throw new ExprValidationException("Date-time method 'between' requires non-null parameter values");
        }
        return DatetimeLongCoercerFactory.getCoercer(value.getClass()).coerce(value);
    }

    private boolean getBooleanValue(ExprNode exprNode) throws ExprValidationException {
        Object value = exprNode.getExprEvaluator().evaluate(null, true, null);
        if (value == null) {
            throw new ExprValidationException("Date-time method 'between' requires non-null parameter values");
        }
        return (Boolean)value;
    }

    @Override
    public Object evaluate(Long ts, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (ts == null) {
            return null;
        }
        return this.evaluateInternal(ts);
    }

    @Override
    public Object evaluate(Date d, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (d == null) {
            return null;
        }
        return this.evaluateInternal(d.getTime());
    }

    @Override
    public Object evaluate(Calendar cal, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (cal == null) {
            return null;
        }
        return this.evaluateInternal(cal.getTimeInMillis());
    }

    public Object evaluateInternal(long ts) {
        return this.first <= ts && ts <= this.second;
    }

    @Override
    public Class getReturnType() {
        return Boolean.class;
    }

    @Override
    public ExprDotNodeFilterAnalyzerDesc getFilterDesc(EventType[] typesPerStream, DatetimeMethodEnum currentMethod, List<ExprNode> currentParameters, ExprDotNodeFilterAnalyzerInput inputDesc) {
        return null;
    }
}

