/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.db;

import com.espertech.esper.client.EPException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.db.DatabaseConfigException;
import com.espertech.esper.epl.db.DatabaseConnectionFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ConnectionCache {
    private DatabaseConnectionFactory databaseConnectionFactory;
    private String sql;
    private static Log log = LogFactory.getLog(ConnectionCache.class);

    public abstract Pair<Connection, PreparedStatement> getConnection();

    public abstract void doneWith(Pair<Connection, PreparedStatement> var1);

    public abstract void destroy();

    protected ConnectionCache(DatabaseConnectionFactory databaseConnectionFactory, String sql) {
        this.databaseConnectionFactory = databaseConnectionFactory;
        this.sql = sql;
    }

    protected static void close(Pair<Connection, PreparedStatement> pair) {
        log.info((Object)".close Closing statement and connection");
        try {
            pair.getSecond().close();
        }
        catch (SQLException ex) {
            try {
                pair.getFirst().close();
            }
            catch (SQLException e) {
                log.error((Object)("Error closing JDBC connection:" + e.getMessage()), (Throwable)e);
            }
            throw new EPException("Error closing statement", ex);
        }
        try {
            pair.getFirst().close();
        }
        catch (SQLException ex) {
            throw new EPException("Error closing statement", ex);
        }
    }

    protected Pair<Connection, PreparedStatement> makeNew() {
        PreparedStatement preparedStatement;
        Connection connection;
        log.info((Object)".makeNew Obtaining new connection and statement");
        try {
            connection = this.databaseConnectionFactory.getConnection();
        }
        catch (DatabaseConfigException ex) {
            throw new EPException("Error obtaining connection", ex);
        }
        try {
            preparedStatement = connection.prepareStatement(this.sql);
        }
        catch (SQLException ex) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.warn((Object)("Error closing connection: " + e.getMessage()), (Throwable)e);
            }
            throw new EPException("Error preparing statement '" + this.sql + '\'', ex);
        }
        return new Pair<Connection, PreparedStatement>(connection, preparedStatement);
    }
}

