/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.db;

import com.espertech.esper.client.ConfigurationCacheReferenceType;
import com.espertech.esper.collection.apachecommons.ReferenceMap;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.EngineLevelExtensionServicesContext;
import com.espertech.esper.epl.db.DataCache;
import com.espertech.esper.epl.db.DataCacheUtil;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.schedule.SchedulingService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class DataCacheExpiringImpl
implements DataCache,
ScheduleHandleCallback {
    private final long maxAgeMSec;
    private final long purgeIntervalMSec;
    private final SchedulingService schedulingService;
    private final ScheduleSlot scheduleSlot;
    private final Map<Object, Item> cache;
    private final EPStatementAgentInstanceHandle epStatementAgentInstanceHandle;
    private boolean isScheduled;

    public DataCacheExpiringImpl(double maxAgeSec, double purgeIntervalSec, ConfigurationCacheReferenceType cacheReferenceType, SchedulingService schedulingService, ScheduleSlot scheduleSlot, EPStatementAgentInstanceHandle epStatementAgentInstanceHandle) {
        this.maxAgeMSec = (long)maxAgeSec * 1000L;
        this.purgeIntervalMSec = (long)purgeIntervalSec * 1000L;
        this.schedulingService = schedulingService;
        this.scheduleSlot = scheduleSlot;
        this.cache = cacheReferenceType == ConfigurationCacheReferenceType.HARD ? new HashMap<Object, Item>() : (cacheReferenceType == ConfigurationCacheReferenceType.SOFT ? new ReferenceMap(1, 1) : new WeakHashMap<Object, Item>());
        this.epStatementAgentInstanceHandle = epStatementAgentInstanceHandle;
    }

    @Override
    public EventTable[] getCached(Object[] lookupKeys) {
        Object key = DataCacheUtil.getLookupKey(lookupKeys);
        Item item = this.cache.get(key);
        if (item == null) {
            return null;
        }
        long now = this.schedulingService.getTime();
        if (now - item.getTime() > this.maxAgeMSec) {
            this.cache.remove(key);
            return null;
        }
        return item.getData();
    }

    @Override
    public void put(Object[] lookupKeys, EventTable[] rows) {
        Object key = DataCacheUtil.getLookupKey(lookupKeys);
        long now = this.schedulingService.getTime();
        Item item = new Item(rows, now);
        this.cache.put(key, item);
        if (!this.isScheduled) {
            EPStatementHandleCallback callback = new EPStatementHandleCallback(this.epStatementAgentInstanceHandle, this);
            this.schedulingService.add(this.purgeIntervalMSec, callback, this.scheduleSlot);
            this.isScheduled = true;
        }
    }

    protected long getMaxAgeMSec() {
        return this.maxAgeMSec;
    }

    protected long getPurgeIntervalMSec() {
        return this.purgeIntervalMSec;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    protected long getSize() {
        return this.cache.size();
    }

    @Override
    public void scheduledTrigger(EngineLevelExtensionServicesContext engineLevelExtensionServicesContext) {
        long now = this.schedulingService.getTime();
        Iterator<Object> it = this.cache.keySet().iterator();
        while (it.hasNext()) {
            Item item = this.cache.get(it.next());
            if (now - item.getTime() <= this.maxAgeMSec) continue;
            it.remove();
        }
        this.isScheduled = false;
    }

    private static class Item {
        private EventTable[] data;
        private long time;

        public Item(EventTable[] data, long time) {
            this.data = data;
            this.time = time;
        }

        public EventTable[] getData() {
            return this.data;
        }

        public long getTime() {
            return this.time;
        }
    }
}

