/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.db;

import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.IterablesArrayIterator;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.db.DataCache;
import com.espertech.esper.epl.db.PollExecStrategy;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.visitor.ExprNodeIdentifierCollectVisitor;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.UnindexedEventTableList;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.schedule.SchedulingService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.view.HistoricalEventViewable;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class DatabasePollingViewable
implements HistoricalEventViewable {
    private final int myStreamNumber;
    private final PollExecStrategy pollExecStrategy;
    private final List<String> inputParameters;
    private final DataCache dataCache;
    private final EventType eventType;
    private final ThreadLocal<DataCache> dataCacheThreadLocal = new ThreadLocal();
    private ExprEvaluator[] evaluators;
    private SortedSet<Integer> subordinateStreams;
    private ExprEvaluatorContext exprEvaluatorContext;
    private static final EventBean[][] NULL_ROWS = new EventBean[1][];
    private static final PollResultIndexingStrategy iteratorIndexingStrategy;

    public DatabasePollingViewable(int myStreamNumber, List<String> inputParameters, PollExecStrategy pollExecStrategy, DataCache dataCache, EventType eventType) {
        this.myStreamNumber = myStreamNumber;
        this.inputParameters = inputParameters;
        this.pollExecStrategy = pollExecStrategy;
        this.dataCache = dataCache;
        this.eventType = eventType;
    }

    @Override
    public void stop() {
        this.pollExecStrategy.destroy();
    }

    @Override
    public void validate(EngineImportService engineImportService, StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, TimeProvider timeProvider, VariableService variableService, TableService tableService, ExprEvaluatorContext exprEvaluatorContext, ConfigurationInformation configSnapshot, SchedulingService schedulingService, String engineURI, Map<Integer, List<ExprNode>> sqlParameters, EventAdapterService eventAdapterService, String statementName, String statementId, Annotation[] annotations) throws ExprValidationException {
        this.evaluators = new ExprEvaluator[this.inputParameters.size()];
        this.subordinateStreams = new TreeSet<Integer>();
        this.exprEvaluatorContext = exprEvaluatorContext;
        int count = 0;
        ExprValidationContext validationContext = new ExprValidationContext(streamTypeService, methodResolutionService, null, timeProvider, variableService, tableService, exprEvaluatorContext, eventAdapterService, statementName, statementId, annotations, null, false, false, true, false, null, false);
        for (String inputParam : this.inputParameters) {
            ExprNode raw = DatabasePollingViewable.findSQLExpressionNode(this.myStreamNumber, count, sqlParameters);
            if (raw == null) {
                throw new ExprValidationException("Internal error find expression for historical stream parameter " + count + " stream " + this.myStreamNumber);
            }
            ExprNode evaluator = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.DATABASEPOLL, raw, validationContext);
            this.evaluators[count++] = evaluator.getExprEvaluator();
            ExprNodeIdentifierCollectVisitor visitor = new ExprNodeIdentifierCollectVisitor();
            visitor.visit(evaluator);
            for (ExprIdentNode identNode : visitor.getExprProperties()) {
                if (identNode.getStreamId() == this.myStreamNumber) {
                    throw new ExprValidationException("Invalid expression '" + inputParam + "' resolves to the historical data itself");
                }
                this.subordinateStreams.add(identNode.getStreamId());
            }
        }
    }

    @Override
    public EventTable[][] poll(EventBean[][] lookupEventsPerStream, PollResultIndexingStrategy indexingStrategy, ExprEvaluatorContext exprEvaluatorContext) {
        DataCache localDataCache = this.dataCacheThreadLocal.get();
        boolean strategyStarted = false;
        EventTable[][] resultPerInputRow = new EventTable[lookupEventsPerStream.length][];
        for (int row = 0; row < lookupEventsPerStream.length; ++row) {
            EventTable[] multi;
            Object[] lookupValues = new Object[this.inputParameters.size()];
            for (int valueNum = 0; valueNum < this.inputParameters.size(); ++valueNum) {
                Object lookupValue;
                EventBean[] eventsPerStream = lookupEventsPerStream[row];
                lookupValues[valueNum] = lookupValue = this.evaluators[valueNum].evaluate(eventsPerStream, true, exprEvaluatorContext);
            }
            EventTable[] result = null;
            if (localDataCache != null) {
                EventTable[] tables;
                result = tables = localDataCache.getCached(lookupValues);
            }
            if (result == null && (multi = this.dataCache.getCached(lookupValues)) != null) {
                result = multi;
                if (localDataCache != null) {
                    localDataCache.put(lookupValues, multi);
                }
            }
            if (result != null) {
                resultPerInputRow[row] = result;
                continue;
            }
            try {
                if (!strategyStarted) {
                    this.pollExecStrategy.start();
                    strategyStarted = true;
                }
                List<EventBean> pollResult = this.pollExecStrategy.poll(lookupValues, exprEvaluatorContext);
                EventTable[] indexTable = indexingStrategy.index(pollResult, this.dataCache.isActive());
                resultPerInputRow[row] = indexTable;
                this.dataCache.put(lookupValues, indexTable);
                if (localDataCache == null) continue;
                localDataCache.put(lookupValues, indexTable);
                continue;
            }
            catch (EPException ex) {
                if (strategyStarted) {
                    this.pollExecStrategy.done();
                }
                throw ex;
            }
        }
        if (strategyStarted) {
            this.pollExecStrategy.done();
        }
        return resultPerInputRow;
    }

    @Override
    public View addView(View view) {
        view.setParent(this);
        return view;
    }

    @Override
    public View[] getViews() {
        return ViewSupport.EMPTY_VIEW_ARRAY;
    }

    @Override
    public boolean removeView(View view) {
        throw new UnsupportedOperationException("Subviews not supported");
    }

    @Override
    public boolean hasViews() {
        return false;
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        EventTable[][] tablesPerRow = this.poll(NULL_ROWS, iteratorIndexingStrategy, this.exprEvaluatorContext);
        return new IterablesArrayIterator(tablesPerRow);
    }

    @Override
    public SortedSet<Integer> getRequiredStreams() {
        return this.subordinateStreams;
    }

    @Override
    public boolean hasRequiredStreams() {
        return !this.subordinateStreams.isEmpty();
    }

    @Override
    public ThreadLocal<DataCache> getDataCacheThreadLocal() {
        return this.dataCacheThreadLocal;
    }

    @Override
    public void removeAllViews() {
        throw new UnsupportedOperationException("Subviews not supported");
    }

    private static ExprNode findSQLExpressionNode(int myStreamNumber, int count, Map<Integer, List<ExprNode>> sqlParameters) {
        if (sqlParameters == null || sqlParameters.isEmpty()) {
            return null;
        }
        List<ExprNode> parameters = sqlParameters.get(myStreamNumber);
        if (parameters == null || parameters.isEmpty() || parameters.size() < count + 1) {
            return null;
        }
        return parameters.get(count);
    }

    static {
        DatabasePollingViewable.NULL_ROWS[0] = new EventBean[1];
        iteratorIndexingStrategy = new PollResultIndexingStrategy(){

            @Override
            public EventTable[] index(List<EventBean> pollResult, boolean isActiveCache) {
                return new EventTable[]{new UnindexedEventTableList(pollResult, -1)};
            }

            @Override
            public String toQueryPlan() {
                return this.getClass().getSimpleName() + " unindexed";
            }
        };
    }
}

