/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.enummethod.dot;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.ExpressionResultCacheEntry;
import com.espertech.esper.core.service.ExpressionResultCacheStackEntry;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.enummethod.dot.EnumMethodEnum;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalEnumMethod;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalParam;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalParamExpr;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalParamLambda;
import com.espertech.esper.epl.enummethod.dot.ExprLambdaGoesNode;
import com.espertech.esper.epl.enummethod.eval.EnumEval;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.dot.ExprDotEvalVisitor;
import com.espertech.esper.epl.expression.visitor.ExprNodeIdentifierCollectVisitor;
import com.espertech.esper.epl.methodbase.DotMethodFP;
import com.espertech.esper.epl.methodbase.DotMethodFPInputEnum;
import com.espertech.esper.epl.methodbase.DotMethodFPParamTypeEnum;
import com.espertech.esper.epl.methodbase.DotMethodFPProvided;
import com.espertech.esper.epl.methodbase.DotMethodInputTypeMatcher;
import com.espertech.esper.epl.methodbase.DotMethodTypeEnum;
import com.espertech.esper.epl.methodbase.DotMethodUtil;
import com.espertech.esper.epl.rettype.EPType;
import com.espertech.esper.epl.rettype.EPTypeHelper;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class ExprDotEvalEnumMethodBase
implements ExprDotEvalEnumMethod,
ExpressionResultCacheStackEntry {
    private EnumMethodEnum enumMethodEnum;
    private String enumMethodUsedName;
    private int streamCountIncoming;
    private EnumEval enumEval;
    private int enumEvalNumRequiredEvents;
    private EPType typeInfo;
    private boolean cache;
    private long contextNumber = 0L;

    protected ExprDotEvalEnumMethodBase() {
    }

    public abstract EventType[] getAddStreamTypes(String var1, List<String> var2, EventType var3, Class var4, List<ExprDotEvalParam> var5, EventAdapterService var6);

    public abstract EnumEval getEnumEval(MethodResolutionService var1, EventAdapterService var2, StreamTypeService var3, String var4, String var5, List<ExprDotEvalParam> var6, EventType var7, Class var8, int var9, boolean var10) throws ExprValidationException;

    public EnumMethodEnum getEnumMethodEnum() {
        return this.enumMethodEnum;
    }

    @Override
    public void visit(ExprDotEvalVisitor visitor) {
        visitor.visitEnumeration(this.enumMethodEnum.getNameCamel());
    }

    @Override
    public void init(Integer streamOfProviderIfApplicable, EnumMethodEnum enumMethodEnum, String enumMethodUsedName, EPType typeInfo, List<ExprNode> parameters, ExprValidationContext validationContext) throws ExprValidationException {
        boolean isInner;
        final EventType eventTypeColl = EPTypeHelper.getEventTypeMultiValued(typeInfo);
        final EventType eventTypeBean = EPTypeHelper.getEventTypeSingleValued(typeInfo);
        final Class collectionComponentType = EPTypeHelper.getClassMultiValued(typeInfo);
        this.enumMethodEnum = enumMethodEnum;
        this.enumMethodUsedName = enumMethodUsedName;
        this.streamCountIncoming = validationContext.getStreamTypeService().getEventTypes().length;
        if (eventTypeColl == null && collectionComponentType == null && eventTypeBean == null) {
            throw new ExprValidationException("Invalid input for built-in enumeration method '" + enumMethodUsedName + "', expecting collection of event-type or scalar values as input, received " + EPTypeHelper.toTypeDescriptive(typeInfo));
        }
        DotMethodFPProvided footprintProvided = DotMethodUtil.getProvidedFootprint(parameters);
        DotMethodInputTypeMatcher inputTypeMatcher = new DotMethodInputTypeMatcher(){

            @Override
            public boolean matches(DotMethodFP footprint) {
                if (footprint.getInput() == DotMethodFPInputEnum.EVENTCOLL && eventTypeBean == null && eventTypeColl == null) {
                    return false;
                }
                return footprint.getInput() != DotMethodFPInputEnum.SCALAR_ANY || collectionComponentType != null;
            }
        };
        DotMethodFP footprint = DotMethodUtil.validateParametersDetermineFootprint(enumMethodEnum.getFootprints(), DotMethodTypeEnum.ENUM, enumMethodUsedName, footprintProvided, inputTypeMatcher);
        if (footprint.getInput() != DotMethodFPInputEnum.ANY) {
            String message = "Invalid input for built-in enumeration method '" + enumMethodUsedName + "' and " + footprint.getParameters().length + "-parameter footprint, expecting collection of ";
            String received = " as input, received " + EPTypeHelper.toTypeDescriptive(typeInfo);
            if (footprint.getInput() == DotMethodFPInputEnum.EVENTCOLL && eventTypeColl == null) {
                throw new ExprValidationException(message + "events" + received);
            }
            if (footprint.getInput().isScalar() && collectionComponentType == null) {
                throw new ExprValidationException(message + "values (typically scalar values)" + received);
            }
            if (footprint.getInput() == DotMethodFPInputEnum.SCALAR_NUMERIC && !JavaClassHelper.isNumeric(collectionComponentType)) {
                throw new ExprValidationException(message + "numeric values" + received);
            }
        }
        validationContext.getExprEvaluatorContext().getExpressionResultCacheService().pushStack(this);
        ArrayList<ExprDotEvalParam> bodiesAndParameters = new ArrayList<ExprDotEvalParam>();
        int count = 0;
        EventType inputEventType = eventTypeBean == null ? eventTypeColl : eventTypeBean;
        for (ExprNode node : parameters) {
            ExprDotEvalParam bodyAndParameter = this.getBodyAndParameter(enumMethodUsedName, count++, node, inputEventType, collectionComponentType, validationContext, bodiesAndParameters, footprint);
            bodiesAndParameters.add(bodyAndParameter);
        }
        this.enumEval = this.getEnumEval(validationContext.getMethodResolutionService(), validationContext.getEventAdapterService(), validationContext.getStreamTypeService(), validationContext.getStatementId(), enumMethodUsedName, bodiesAndParameters, inputEventType, collectionComponentType, this.streamCountIncoming, validationContext.isDisablePropertyExpressionEventCollCache());
        this.enumEvalNumRequiredEvents = this.enumEval.getStreamNumSize();
        HashSet<Integer> streamsRequired = new HashSet<Integer>();
        ExprNodeIdentifierCollectVisitor visitor = new ExprNodeIdentifierCollectVisitor();
        for (ExprDotEvalParam desc : bodiesAndParameters) {
            desc.getBody().accept(visitor);
            for (ExprIdentNode ident : visitor.getExprProperties()) {
                streamsRequired.add(ident.getStreamId());
            }
        }
        if (streamOfProviderIfApplicable != null) {
            streamsRequired.add(streamOfProviderIfApplicable);
        }
        boolean bl = isInner = !validationContext.getExprEvaluatorContext().getExpressionResultCacheService().popLambda();
        if (isInner) {
            Deque<ExpressionResultCacheStackEntry> parents = validationContext.getExprEvaluatorContext().getExpressionResultCacheService().getStack();
            boolean found = false;
            Iterator i$ = streamsRequired.iterator();
            while (i$.hasNext()) {
                int req = (Integer)i$.next();
                ExprDotEvalEnumMethodBase first = (ExprDotEvalEnumMethodBase)parents.getFirst();
                int parentIncoming = first.streamCountIncoming - 1;
                int selfAdded = this.streamCountIncoming;
                if (req <= parentIncoming || req >= selfAdded) continue;
                found = true;
            }
            this.cache = !found;
        }
    }

    public void setTypeInfo(EPType typeInfo) {
        this.typeInfo = typeInfo;
    }

    @Override
    public EPType getTypeInfo() {
        return this.typeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (target instanceof EventBean) {
            target = Collections.singletonList((EventBean)((Object)target));
        }
        if (this.cache) {
            ExpressionResultCacheEntry<Long[], Object> cacheValue = exprEvaluatorContext.getExpressionResultCacheService().getEnumerationMethodLastValue(this);
            if (cacheValue != null) {
                return cacheValue.getResult();
            }
            Collection coll2 = target;
            if (coll2 == null) {
                return null;
            }
            EventBean[] eventsLambda = this.allocateCopyEventLambda(eventsPerStream);
            Object result = this.enumEval.evaluateEnumMethod(eventsLambda, coll2, isNewData, exprEvaluatorContext);
            exprEvaluatorContext.getExpressionResultCacheService().saveEnumerationMethodLastValue(this, result);
            return result;
        }
        ++this.contextNumber;
        try {
            exprEvaluatorContext.getExpressionResultCacheService().pushContext(this.contextNumber);
            Collection coll = target;
            if (coll == null) {
                Object coll2 = null;
                return coll2;
            }
            EventBean[] eventsLambda = this.allocateCopyEventLambda(eventsPerStream);
            Object object = this.enumEval.evaluateEnumMethod(eventsLambda, coll, isNewData, exprEvaluatorContext);
            return object;
        }
        finally {
            exprEvaluatorContext.getExpressionResultCacheService().popContext();
        }
    }

    private EventBean[] allocateCopyEventLambda(EventBean[] eventsPerStream) {
        EventBean[] eventsLambda = new EventBean[this.enumEvalNumRequiredEvents];
        EventBeanUtility.safeArrayCopy(eventsPerStream, eventsLambda);
        return eventsLambda;
    }

    private ExprDotEvalParam getBodyAndParameter(String enumMethodUsedName, int parameterNum, ExprNode parameterNode, EventType inputEventType, Class collectionComponentType, ExprValidationContext validationContext, List<ExprDotEvalParam> priorParameters, DotMethodFP footprint) throws ExprValidationException {
        if (!(parameterNode instanceof ExprLambdaGoesNode)) {
            return new ExprDotEvalParamExpr(parameterNum, parameterNode, parameterNode.getExprEvaluator());
        }
        ExprLambdaGoesNode goesNode = (ExprLambdaGoesNode)parameterNode;
        Object[] additionalTypes = this.getAddStreamTypes(enumMethodUsedName, goesNode.getGoesToNames(), inputEventType, collectionComponentType, priorParameters, validationContext.getEventAdapterService());
        Object[] additionalStreamNames = goesNode.getGoesToNames().toArray(new String[goesNode.getGoesToNames().size()]);
        this.validateDuplicateStreamNames(validationContext.getStreamTypeService().getStreamNames(), (String[])additionalStreamNames);
        EventType[] addTypes = (EventType[])CollectionUtil.arrayExpandAddElements((Object)validationContext.getStreamTypeService().getEventTypes(), additionalTypes);
        String[] addNames = (String[])CollectionUtil.arrayExpandAddElements((Object)validationContext.getStreamTypeService().getStreamNames(), additionalStreamNames);
        StreamTypeServiceImpl types = new StreamTypeServiceImpl(addTypes, addNames, new boolean[addTypes.length], null, false);
        ExprNode filter = goesNode.getChildNodes()[0];
        try {
            ExprValidationContext filterValidationContext = new ExprValidationContext(types, validationContext);
            filter = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.DECLAREDEXPRBODY, filter, filterValidationContext);
        }
        catch (ExprValidationException ex) {
            throw new ExprValidationException("Error validating enumeration method '" + enumMethodUsedName + "' parameter " + parameterNum + ": " + ex.getMessage(), ex);
        }
        ExprEvaluator filterEvaluator = filter.getExprEvaluator();
        DotMethodFPParamTypeEnum expectedType = footprint.getParameters()[parameterNum].getType();
        DotMethodUtil.validateSpecificType(enumMethodUsedName, DotMethodTypeEnum.ENUM, expectedType, null, filterEvaluator.getType(), parameterNum, filter);
        int numStreamsIncoming = validationContext.getStreamTypeService().getEventTypes().length;
        return new ExprDotEvalParamLambda(parameterNum, filter, filterEvaluator, numStreamsIncoming, goesNode.getGoesToNames(), (EventType[])additionalTypes);
    }

    private void validateDuplicateStreamNames(String[] streamNames, String[] additionalStreamNames) throws ExprValidationException {
        for (int added = 0; added < additionalStreamNames.length; ++added) {
            for (int exist = 0; exist < streamNames.length; ++exist) {
                if (streamNames[exist] == null || !streamNames[exist].equalsIgnoreCase(additionalStreamNames[added])) continue;
                String message = "Error validating enumeration method '" + this.enumMethodUsedName + "', the lambda-parameter name '" + additionalStreamNames[added] + "' has already been declared in this context";
                throw new ExprValidationException(message);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " lambda=" + (Object)((Object)this.enumMethodEnum);
    }
}

