/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.accessagg;

import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.access.AggregationStateMinMaxByEverSpec;
import com.espertech.esper.epl.agg.access.AggregationStateSortedSpec;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.accessagg.ExprAggMultiFunctionSortedMinMaxByNode;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.util.CollectionUtil;
import java.util.Comparator;

public class SortedAggregationStateFactoryFactory {
    private final MethodResolutionService methodResolutionService;
    private final ExprEvaluator[] evaluators;
    private final boolean[] sortDescending;
    private final boolean ever;
    private final int streamNum;
    private final ExprAggMultiFunctionSortedMinMaxByNode parent;

    public SortedAggregationStateFactoryFactory(MethodResolutionService methodResolutionService, ExprEvaluator[] evaluators, boolean[] sortDescending, boolean ever, int streamNum, ExprAggMultiFunctionSortedMinMaxByNode parent) {
        this.methodResolutionService = methodResolutionService;
        this.evaluators = evaluators;
        this.sortDescending = sortDescending;
        this.ever = ever;
        this.streamNum = streamNum;
        this.parent = parent;
    }

    public AggregationStateFactory makeFactory() {
        AggregationStateFactory factory;
        boolean sortUsingCollator = this.methodResolutionService.isSortUsingCollator();
        Comparator<Object> comparator = CollectionUtil.getComparator(this.evaluators, sortUsingCollator, this.sortDescending);
        Object criteriaKeyBinding = this.methodResolutionService.getCriteriaKeyBinding(this.evaluators);
        if (this.ever) {
            final AggregationStateMinMaxByEverSpec spec = new AggregationStateMinMaxByEverSpec(this.streamNum, this.evaluators, this.parent.isMax(), comparator, criteriaKeyBinding);
            factory = new AggregationStateFactory(){

                @Override
                public AggregationState createAccess(MethodResolutionService methodResolutionService, int agentInstanceId, int groupId, int aggregationId, boolean join, Object groupKey) {
                    return methodResolutionService.makeAccessAggMinMaxEver(agentInstanceId, groupId, aggregationId, spec);
                }

                @Override
                public ExprNode getAggregationExpression() {
                    return SortedAggregationStateFactoryFactory.this.parent;
                }
            };
        } else {
            final AggregationStateSortedSpec spec = new AggregationStateSortedSpec(this.streamNum, this.evaluators, comparator, criteriaKeyBinding);
            factory = new AggregationStateFactory(){

                @Override
                public AggregationState createAccess(MethodResolutionService methodResolutionService, int agentInstanceId, int groupId, int aggregationId, boolean join, Object groupKey) {
                    if (join) {
                        return methodResolutionService.makeAccessAggSortedJoin(agentInstanceId, groupId, aggregationId, spec);
                    }
                    return methodResolutionService.makeAccessAggSortedNonJoin(agentInstanceId, groupId, aggregationId, spec);
                }

                @Override
                public ExprNode getAggregationExpression() {
                    return SortedAggregationStateFactoryFactory.this.parent;
                }
            };
        }
        return factory;
    }
}

