/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprIdentNodeEvaluator;

public class ExprIdentNodeEvaluatorImpl
implements ExprIdentNodeEvaluator {
    private final int streamNum;
    private final EventPropertyGetter propertyGetter;
    private final Class propertyType;
    private final ExprIdentNode identNode;

    public ExprIdentNodeEvaluatorImpl(int streamNum, EventPropertyGetter propertyGetter, Class propertyType, ExprIdentNode identNode) {
        this.streamNum = streamNum;
        this.propertyGetter = propertyGetter;
        this.propertyType = propertyType;
        this.identNode = identNode;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean theEvent = eventsPerStream[this.streamNum];
        if (theEvent == null) {
            return null;
        }
        return this.propertyGetter.get(theEvent);
    }

    @Override
    public Class getType() {
        return this.propertyType;
    }

    @Override
    public EventPropertyGetter getGetter() {
        return this.propertyGetter;
    }

    @Override
    public boolean evaluatePropertyExists(EventBean[] eventsPerStream, boolean isNewData) {
        EventBean theEvent = eventsPerStream[this.streamNum];
        if (theEvent == null) {
            return false;
        }
        return this.propertyGetter.isExistsProperty(theEvent);
    }

    @Override
    public int getStreamNum() {
        return this.streamNum;
    }

    @Override
    public boolean isContextEvaluated() {
        return false;
    }
}

