/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorProxy;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ExprNodeProxy
implements InvocationHandler {
    private static Method target = JavaClassHelper.getMethodByName(ExprNode.class, "getExprEvaluator");
    private String engineURI;
    private String statementName;
    private ExprNode exprNode;

    public static Object newInstance(String engineURI, String statementName, ExprNode exprNode) {
        return Proxy.newProxyInstance(exprNode.getClass().getClassLoader(), JavaClassHelper.getSuperInterfaces(exprNode.getClass()), (InvocationHandler)new ExprNodeProxy(engineURI, statementName, exprNode));
    }

    public ExprNodeProxy(String engineURI, String statementName, ExprNode exprNode) {
        this.engineURI = engineURI;
        this.statementName = statementName;
        this.exprNode = exprNode;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (!m.equals(target)) {
            return m.invoke((Object)this.exprNode, args);
        }
        String expressionToString = "undefined";
        try {
            expressionToString = ExprNodeUtility.toExpressionStringMinPrecedenceSafe(this.exprNode);
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        ExprEvaluator evaluator = (ExprEvaluator)m.invoke((Object)this.exprNode, args);
        return ExprEvaluatorProxy.newInstance(this.engineURI, this.statementName, expressionToString, evaluator);
    }
}

