/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.type.CronOperatorEnum;
import com.espertech.esper.type.CronParameter;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprNumberSetCronParam
extends ExprNodeBase
implements ExprEvaluator {
    private static final Log log = LogFactory.getLog(ExprNumberSetCronParam.class);
    private final CronOperatorEnum cronOperator;
    private transient ExprEvaluator evaluator;
    private static final long serialVersionUID = -1315999998249935318L;

    public ExprNumberSetCronParam(CronOperatorEnum cronOperator) {
        this.cronOperator = cronOperator;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    public CronOperatorEnum getCronOperator() {
        return this.cronOperator;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (this.getChildNodes().length != 0) {
            this.getChildNodes()[0].toEPL(writer, this.getPrecedence());
            writer.append(" ");
        }
        writer.append(this.cronOperator.getSyntax());
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean isConstantResult() {
        if (this.getChildNodes().length == 0) {
            return true;
        }
        return this.getChildNodes()[0].isConstantResult();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprNumberSetCronParam)) {
            return false;
        }
        ExprNumberSetCronParam other = (ExprNumberSetCronParam)node;
        return other.cronOperator.equals((Object)this.cronOperator);
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length == 0) {
            return null;
        }
        this.evaluator = this.getChildNodes()[0].getExprEvaluator();
        Class type = this.evaluator.getType();
        if (!JavaClassHelper.isNumericNonFP(type)) {
            throw new ExprValidationException("Frequency operator requires an integer-type parameter");
        }
        return null;
    }

    @Override
    public Class getType() {
        return CronParameter.class;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.getChildNodes().length == 0) {
            return new CronParameter(this.cronOperator, null);
        }
        Object value = this.evaluator.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (value == null) {
            log.warn((Object)"Null value returned for cron parameter");
            return new CronParameter(this.cronOperator, null);
        }
        int intValue = ((Number)value).intValue();
        return new CronParameter(this.cronOperator, intValue);
    }
}

