/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import java.io.StringWriter;

public class ExprStreamUnderlyingNodeImpl
extends ExprNodeBase
implements ExprEvaluator,
ExprStreamUnderlyingNode {
    private final String streamName;
    private final boolean isWildcard;
    private int streamNum = -1;
    private Class type;
    private transient EventType eventType;
    private static final long serialVersionUID = 6611578192872250478L;

    public ExprStreamUnderlyingNodeImpl(String streamName, boolean isWildcard) {
        if (streamName == null && !isWildcard) {
            throw new IllegalArgumentException("Stream name is null");
        }
        this.streamName = streamName;
        this.isWildcard = isWildcard;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public Integer getStreamReferencedIfAny() {
        return this.getStreamId();
    }

    @Override
    public String getRootPropertyNameIfAny() {
        return null;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.streamName == null && this.isWildcard) {
            if (validationContext.getStreamTypeService().getStreamNames().length > 1) {
                throw new ExprValidationException("Wildcard must be stream wildcard if specifying multiple streams, use the 'streamname.*' syntax instead");
            }
            this.streamNum = 0;
        } else {
            this.streamNum = validationContext.getStreamTypeService().getStreamNumForStreamName(this.streamName);
        }
        if (this.streamNum == -1) {
            throw new ExprValidationException("Stream by name '" + this.streamName + "' could not be found among all streams");
        }
        this.eventType = validationContext.getStreamTypeService().getEventTypes()[this.streamNum];
        this.type = this.eventType.getUnderlyingType();
        return null;
    }

    @Override
    public Class getType() {
        if (this.streamNum == -1) {
            throw new IllegalStateException("Stream underlying node has not been validated");
        }
        return this.type;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public int getStreamId() {
        if (this.streamNum == -1) {
            throw new IllegalStateException("Stream underlying node has not been validated");
        }
        return this.streamNum;
    }

    public String toString() {
        return "streamName=" + this.streamName + " streamNum=" + this.streamNum;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean theEvent = eventsPerStream[this.streamNum];
        if (theEvent == null) {
            return null;
        }
        return theEvent.getUnderlying();
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append(this.streamName);
        if (this.isWildcard) {
            writer.append(".*");
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprStreamUnderlyingNodeImpl)) {
            return false;
        }
        ExprStreamUnderlyingNodeImpl other = (ExprStreamUnderlyingNodeImpl)node;
        if (this.isWildcard != other.isWildcard) {
            return false;
        }
        if (this.isWildcard) {
            return true;
        }
        return this.streamName.equals(other.streamName);
    }
}

