/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.dot;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.dot.ExprDotEval;
import com.espertech.esper.epl.expression.dot.ExprDotEvalVisitor;
import com.espertech.esper.epl.rettype.EPType;
import com.espertech.esper.epl.rettype.EPTypeHelper;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprDotMethodEvalNoDuck
implements ExprDotEval {
    private static final Log log = LogFactory.getLog(ExprDotMethodEvalNoDuck.class);
    protected final String statementName;
    protected final FastMethod method;
    private final ExprEvaluator[] parameters;

    public ExprDotMethodEvalNoDuck(String statementName, FastMethod method, ExprEvaluator[] parameters) {
        this.statementName = statementName;
        this.method = method;
        this.parameters = parameters;
    }

    @Override
    public void visit(ExprDotEvalVisitor visitor) {
        visitor.visitMethod(this.method.getName());
    }

    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (target == null) {
            return null;
        }
        Object[] args = new Object[this.parameters.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.parameters[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        try {
            return this.method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            String message = JavaClassHelper.getMessageInvocationTarget(this.statementName, this.method.getJavaMethod(), target.getClass().getName(), args, e);
            log.error((Object)message, e.getTargetException());
            return null;
        }
    }

    @Override
    public EPType getTypeInfo() {
        return EPTypeHelper.fromMethod(this.method.getJavaMethod());
    }
}

