/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.funcs;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNamedParameterNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.funcs.ExprCastNodeConstEval;
import com.espertech.esper.epl.expression.funcs.ExprCastNodeNonConstEval;
import com.espertech.esper.pattern.observer.TimerScheduleISO8601Parser;
import com.espertech.esper.schedule.ScheduleParameterException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleTypeCaster;
import com.espertech.esper.util.SimpleTypeCasterAnyType;
import com.espertech.esper.util.SimpleTypeCasterFactory;
import com.espertech.esper.util.SimpleTypeParser;
import com.espertech.esper.util.SimpleTypeParserFactory;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

public class ExprCastNode
extends ExprNodeBase {
    private final String classIdentifier;
    private Class targetType;
    private boolean isConstant;
    private transient ExprEvaluator exprEvaluator;
    private static final long serialVersionUID = 7448449031028156455L;

    public ExprCastNode(String classIdentifier) {
        this.classIdentifier = classIdentifier;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this.exprEvaluator;
    }

    public String getClassIdentifier() {
        return this.classIdentifier;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        void var8_22;
        void var8_17;
        SimpleTypeCaster caster;
        boolean numeric;
        if (this.getChildNodes().length == 0 || this.getChildNodes().length > 2) {
            throw new ExprValidationException("Cast function node must have one or two child expressions");
        }
        ExprEvaluator valueEvaluator = this.getChildNodes()[0].getExprEvaluator();
        Class fromType = valueEvaluator.getType();
        Map<String, ExprNamedParameterNode> namedParams = ExprNodeUtility.getNamedExpressionsHandleDups(Arrays.asList(this.getChildNodes()));
        ExprNodeUtility.validateNamed(namedParams, new String[]{"dateformat"});
        ExprNamedParameterNode dateFormatParameter = namedParams.get("dateformat");
        if (dateFormatParameter != null) {
            ExprNodeUtility.validateNamedExpectType(dateFormatParameter, new Class[]{String.class});
        }
        this.targetType = JavaClassHelper.getBoxedType(JavaClassHelper.getPrimitiveClassForName(this.classIdentifier.trim()));
        Object var8_6 = null;
        if (dateFormatParameter != null) {
            if (fromType != String.class) {
                throw new ExprValidationException("Use of the '" + dateFormatParameter.getParameterName() + "' named parameter requires a string-type input");
            }
            if (this.targetType == null) {
                try {
                    this.targetType = JavaClassHelper.getClassForName(this.classIdentifier.trim());
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            String staticDateFormat = null;
            ExprEvaluator dynamicDateFormat = null;
            boolean iso8601Format = false;
            if (!dateFormatParameter.getChildNodes()[0].isConstantResult()) {
                dynamicDateFormat = dateFormatParameter.getChildNodes()[0].getExprEvaluator();
            } else {
                staticDateFormat = (String)dateFormatParameter.getChildNodes()[0].getExprEvaluator().evaluate(null, true, validationContext.getExprEvaluatorContext());
                if (staticDateFormat.toLowerCase().trim().equals("iso")) {
                    iso8601Format = true;
                } else {
                    try {
                        new SimpleDateFormat(staticDateFormat);
                    }
                    catch (RuntimeException ex) {
                        throw new ExprValidationException("Invalid date format '" + staticDateFormat + "': " + ex.getMessage(), ex);
                    }
                }
            }
            numeric = false;
            caster = null;
            if (this.targetType == Date.class || this.classIdentifier.trim().toLowerCase().equals("date".toLowerCase())) {
                this.targetType = Date.class;
                if (staticDateFormat != null) {
                    if (iso8601Format) {
                        StringToDateWStaticISOFormatComputer stringToDateWStaticISOFormatComputer = new StringToDateWStaticISOFormatComputer();
                    } else {
                        StringToDateWStaticFormatComputer stringToDateWStaticFormatComputer = new StringToDateWStaticFormatComputer(staticDateFormat);
                    }
                } else {
                    StringToDateWDynamicFormatComputer stringToDateWDynamicFormatComputer = new StringToDateWDynamicFormatComputer(dynamicDateFormat);
                }
            } else if (this.targetType == Calendar.class || this.classIdentifier.trim().toLowerCase().equals("calendar".toLowerCase())) {
                this.targetType = Calendar.class;
                if (staticDateFormat != null) {
                    if (iso8601Format) {
                        StringToCalendarWStaticISOFormatComputer stringToCalendarWStaticISOFormatComputer = new StringToCalendarWStaticISOFormatComputer();
                    } else {
                        StringToCalendarWStaticFormatComputer stringToCalendarWStaticFormatComputer = new StringToCalendarWStaticFormatComputer(staticDateFormat, validationContext.getMethodResolutionService().getEngineImportService().getTimeZone());
                    }
                } else {
                    StringToCalendarWDynamicFormatComputer stringToCalendarWDynamicFormatComputer = new StringToCalendarWDynamicFormatComputer(dynamicDateFormat, validationContext.getMethodResolutionService().getEngineImportService().getTimeZone());
                }
            } else {
                if (this.targetType != Long.class) throw new ExprValidationException("Use of the '" + dateFormatParameter.getParameterName() + "' named parameter requires a target type of calendar, date or long");
                this.targetType = Long.class;
                if (staticDateFormat != null) {
                    if (iso8601Format) {
                        StringToLongWStaticISOFormatComputer stringToLongWStaticISOFormatComputer = new StringToLongWStaticISOFormatComputer();
                    } else {
                        StringToLongWStaticFormatComputer stringToLongWStaticFormatComputer = new StringToLongWStaticFormatComputer(staticDateFormat);
                    }
                } else {
                    StringToLongWDynamicFormatComputer stringToLongWDynamicFormatComputer = new StringToLongWDynamicFormatComputer(dynamicDateFormat);
                }
            }
        } else if (this.targetType != null) {
            this.targetType = JavaClassHelper.getBoxedType(this.targetType);
            caster = SimpleTypeCasterFactory.getCaster(fromType, this.targetType);
            numeric = caster.isNumericCast();
        } else if (this.classIdentifier.trim().toLowerCase().equals("BigInteger".toLowerCase())) {
            this.targetType = BigInteger.class;
            caster = SimpleTypeCasterFactory.getCaster(fromType, this.targetType);
            numeric = true;
        } else if (this.classIdentifier.trim().toLowerCase().equals("BigDecimal".toLowerCase())) {
            this.targetType = BigDecimal.class;
            caster = SimpleTypeCasterFactory.getCaster(fromType, this.targetType);
            numeric = true;
        } else {
            try {
                this.targetType = JavaClassHelper.getClassForName(this.classIdentifier.trim());
            }
            catch (ClassNotFoundException e) {
                throw new ExprValidationException("Class as listed in cast function by name '" + this.classIdentifier + "' cannot be loaded", e);
            }
            numeric = JavaClassHelper.isNumeric(this.targetType);
            caster = numeric ? SimpleTypeCasterFactory.getCaster(fromType, this.targetType) : new SimpleTypeCasterAnyType(this.targetType);
        }
        if (var8_17 == null) {
            if (this.targetType == String.class) {
                StringXFormComputer stringXFormComputer = new StringXFormComputer();
            } else if (fromType == String.class) {
                SimpleTypeParser parser = SimpleTypeParserFactory.getParser(JavaClassHelper.getBoxedType(this.targetType));
                StringParserComputer stringParserComputer = new StringParserComputer(parser);
            } else if (numeric) {
                NumberCasterComputer numberCasterComputer = new NumberCasterComputer(caster);
            } else {
                NonnumericCasterComputer nonnumericCasterComputer = new NonnumericCasterComputer(caster);
            }
        }
        Object theConstant = null;
        if (this.getChildNodes()[0].isConstantResult()) {
            this.isConstant = var8_22.isConstantForConstInput();
            if (this.isConstant) {
                Object in = valueEvaluator.evaluate(null, true, validationContext.getExprEvaluatorContext());
                theConstant = var8_22.compute(in, null, true, validationContext.getExprEvaluatorContext());
            }
        }
        this.exprEvaluator = this.isConstant ? new ExprCastNodeConstEval(this, theConstant) : new ExprCastNodeNonConstEval(this, valueEvaluator, (CasterParserComputer)var8_22);
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return this.isConstant;
    }

    public Class getTargetType() {
        return this.targetType;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append("cast(");
        this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
        writer.append(",");
        writer.append(this.classIdentifier);
        for (int i = 1; i < this.getChildNodes().length; ++i) {
            writer.write(",");
            this.getChildNodes()[i].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
        }
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprCastNode)) {
            return false;
        }
        ExprCastNode other = (ExprCastNode)node;
        return other.classIdentifier.equals(this.classIdentifier);
    }

    public static EPException handleParseException(String formatString, String date, ParseException ex) {
        return new EPException("Exception parsing date '" + date + "' format '" + formatString + "': " + ex.getMessage(), ex);
    }

    public static EPException handleParseISOException(String date, ScheduleParameterException ex) {
        return new EPException("Exception parsing iso8601 date '" + date + "': " + ex.getMessage(), ex);
    }

    public static class StringToCalendarWDynamicFormatComputer
    extends StringToDateLongWDynamicFormat {
        private final TimeZone timeZone;

        public StringToCalendarWDynamicFormatComputer(ExprEvaluator dateFormatEval, TimeZone timeZone) {
            super(dateFormatEval);
            this.timeZone = timeZone;
        }

        @Override
        protected Object computeFromFormat(String formatString, SimpleDateFormat format, Object input) {
            return StringToCalendarWStaticFormatComputer.parse(formatString, format, input, this.timeZone);
        }
    }

    public static class StringToLongWDynamicFormatComputer
    extends StringToDateLongWDynamicFormat {
        public StringToLongWDynamicFormatComputer(ExprEvaluator dateFormatEval) {
            super(dateFormatEval);
        }

        @Override
        protected Object computeFromFormat(String dateFormat, SimpleDateFormat format, Object input) {
            return StringToLongWStaticFormatComputer.parseSafe(dateFormat, format, input);
        }
    }

    public static class StringToDateWDynamicFormatComputer
    extends StringToDateLongWDynamicFormat {
        public StringToDateWDynamicFormatComputer(ExprEvaluator dateFormatEval) {
            super(dateFormatEval);
        }

        @Override
        protected Object computeFromFormat(String formatString, SimpleDateFormat format, Object input) {
            return StringToDateWStaticFormatComputer.parseSafe(formatString, format, input);
        }
    }

    public static class StringToCalendarWStaticISOFormatComputer
    implements CasterParserComputer {
        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            try {
                return TimerScheduleISO8601Parser.parseDate(input.toString());
            }
            catch (ScheduleParameterException ex) {
                throw ExprCastNode.handleParseISOException(input.toString(), ex);
            }
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }
    }

    public static class StringToCalendarWStaticFormatComputer
    extends StringToDateLongWStaticFormat {
        private final TimeZone timeZone;

        public StringToCalendarWStaticFormatComputer(String dateFormat, TimeZone timeZone) {
            super(dateFormat);
            this.timeZone = timeZone;
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToCalendarWStaticFormatComputer.parse(this.dateFormat, (SimpleDateFormat)this.formats.get(), input, this.timeZone);
        }

        protected static Object parse(String formatString, SimpleDateFormat format, Object input, TimeZone timeZone) {
            try {
                Calendar cal = Calendar.getInstance(timeZone);
                Date date = format.parse(input.toString());
                cal.setTime(date);
                return cal;
            }
            catch (ParseException ex) {
                throw ExprCastNode.handleParseException(formatString, input.toString(), ex);
            }
        }
    }

    public static class StringToLongWStaticISOFormatComputer
    implements CasterParserComputer {
        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            try {
                return TimerScheduleISO8601Parser.parseDate(input.toString()).getTimeInMillis();
            }
            catch (ScheduleParameterException ex) {
                throw ExprCastNode.handleParseISOException(input.toString(), ex);
            }
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }
    }

    public static class StringToLongWStaticFormatComputer
    extends StringToDateLongWStaticFormat {
        public StringToLongWStaticFormatComputer(String dateFormat) {
            super(dateFormat);
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToLongWStaticFormatComputer.parseSafe(this.dateFormat, (SimpleDateFormat)this.formats.get(), input);
        }

        protected static Object parseSafe(String dateFormat, SimpleDateFormat format, Object input) {
            try {
                return format.parse(input.toString()).getTime();
            }
            catch (ParseException e) {
                throw ExprCastNode.handleParseException(dateFormat, input.toString(), e);
            }
        }
    }

    public static class StringToDateWStaticISOFormatComputer
    implements CasterParserComputer {
        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            try {
                return TimerScheduleISO8601Parser.parseDate(input.toString()).getTime();
            }
            catch (ScheduleParameterException e) {
                throw ExprCastNode.handleParseISOException(input.toString(), e);
            }
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }
    }

    public static class StringToDateWStaticFormatComputer
    extends StringToDateLongWStaticFormat {
        public StringToDateWStaticFormatComputer(String dateFormat) {
            super(dateFormat);
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return StringToDateWStaticFormatComputer.parseSafe(this.dateFormat, (SimpleDateFormat)this.formats.get(), input);
        }

        protected static Object parseSafe(String formatString, SimpleDateFormat format, Object input) {
            try {
                return format.parse(input.toString());
            }
            catch (ParseException e) {
                throw ExprCastNode.handleParseException(formatString, input.toString(), e);
            }
        }
    }

    public static abstract class StringToDateLongWDynamicFormat
    implements CasterParserComputer {
        private final ExprEvaluator dateFormatEval;

        protected StringToDateLongWDynamicFormat(ExprEvaluator dateFormatEval) {
            this.dateFormatEval = dateFormatEval;
        }

        protected abstract Object computeFromFormat(String var1, SimpleDateFormat var2, Object var3) throws ParseException;

        @Override
        public boolean isConstantForConstInput() {
            return false;
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            SimpleDateFormat dateFormat;
            Object format = this.dateFormatEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            if (format == null) {
                throw new EPException("Null date format returned by 'dateformat' expression");
            }
            try {
                dateFormat = new SimpleDateFormat(format.toString());
            }
            catch (RuntimeException ex) {
                throw new EPException("Invalid date format '" + format.toString() + "': " + ex.getMessage(), ex);
            }
            try {
                return this.computeFromFormat(format.toString(), dateFormat, input);
            }
            catch (ParseException ex) {
                throw ExprCastNode.handleParseException(format.toString(), input.toString(), ex);
            }
        }
    }

    public static abstract class StringToDateLongWStaticFormat
    implements CasterParserComputer {
        protected final String dateFormat;
        protected final ThreadLocal<SimpleDateFormat> formats = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected synchronized SimpleDateFormat initialValue() {
                return new SimpleDateFormat(StringToDateLongWStaticFormat.this.dateFormat);
            }
        };

        protected StringToDateLongWStaticFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }
    }

    public static class NonnumericCasterComputer
    implements CasterParserComputer {
        private final SimpleTypeCaster caster;

        public NonnumericCasterComputer(SimpleTypeCaster numericTypeCaster) {
            this.caster = numericTypeCaster;
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return this.caster.cast(input);
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }
    }

    public static class StringParserComputer
    implements CasterParserComputer {
        private final SimpleTypeParser parser;

        public StringParserComputer(SimpleTypeParser parser) {
            this.parser = parser;
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return this.parser.parse(input.toString());
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }
    }

    public static class NumberCasterComputer
    implements CasterParserComputer {
        private final SimpleTypeCaster numericTypeCaster;

        public NumberCasterComputer(SimpleTypeCaster numericTypeCaster) {
            this.numericTypeCaster = numericTypeCaster;
        }

        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            if (input instanceof Number) {
                return this.numericTypeCaster.cast(input);
            }
            return null;
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }
    }

    public static class StringXFormComputer
    implements CasterParserComputer {
        @Override
        public Object compute(Object input, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
            return input.toString();
        }

        @Override
        public boolean isConstantForConstInput() {
            return true;
        }
    }

    public static interface CasterParserComputer {
        public Object compute(Object var1, EventBean[] var2, boolean var3, ExprEvaluatorContext var4);

        public boolean isConstantForConstInput();
    }
}

