/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.funcs;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprFilterOptimizableNode;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.event.vaevent.VariantEvent;
import com.espertech.esper.filter.FilterSpecLookupable;
import java.io.StringWriter;
import java.util.Map;

public class ExprTypeofNode
extends ExprNodeBase
implements ExprFilterOptimizableNode {
    private static final long serialVersionUID = -612634538694877204L;
    private transient ExprEvaluator evaluator;

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this.evaluator;
    }

    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 1) {
            throw new ExprValidationException("Typeof node must have 1 child expression node supplying the expression to test");
        }
        if (this.getChildNodes()[0] instanceof ExprStreamUnderlyingNode) {
            ExprStreamUnderlyingNode stream = (ExprStreamUnderlyingNode)this.getChildNodes()[0];
            this.evaluator = new StreamEventTypeEval(stream.getStreamId());
            return null;
        }
        if (this.getChildNodes()[0] instanceof ExprIdentNode) {
            ExprIdentNode ident = (ExprIdentNode)this.getChildNodes()[0];
            int streamNum = validationContext.getStreamTypeService().getStreamNumForStreamName(ident.getFullUnresolvedName());
            if (streamNum != -1) {
                this.evaluator = new StreamEventTypeEval(streamNum);
                return null;
            }
            EventType eventType = validationContext.getStreamTypeService().getEventTypes()[ident.getStreamId()];
            if (eventType.getFragmentType(ident.getResolvedPropertyName()) != null) {
                this.evaluator = new FragmentTypeEval(ident.getStreamId(), eventType, ident.getResolvedPropertyName());
                return null;
            }
        }
        this.evaluator = new InnerEvaluator(this.getChildNodes()[0].getExprEvaluator());
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    public Class getType() {
        return String.class;
    }

    @Override
    public boolean getFilterLookupEligible() {
        return true;
    }

    @Override
    public FilterSpecLookupable getFilterLookupable() {
        EventPropertyGetter getter = new EventPropertyGetter(){

            @Override
            public Object get(EventBean eventBean) throws PropertyAccessException {
                return eventBean.getEventType().getName();
            }

            @Override
            public boolean isExistsProperty(EventBean eventBean) {
                return true;
            }

            @Override
            public Object getFragment(EventBean eventBean) throws PropertyAccessException {
                return null;
            }
        };
        return new FilterSpecLookupable(ExprNodeUtility.toExpressionStringMinPrecedenceSafe(this), getter, String.class);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append("typeof(");
        this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprTypeofNode;
    }

    private static class InnerEvaluator
    implements ExprEvaluator {
        private final ExprEvaluator evaluator;

        public InnerEvaluator(ExprEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public Class getType() {
            return String.class;
        }

        @Override
        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            Object result = this.evaluator.evaluate(eventsPerStream, isNewData, context);
            if (result == null) {
                return null;
            }
            return result.getClass().getSimpleName();
        }
    }

    public static class FragmentTypeEval
    implements ExprEvaluator {
        private final int streamId;
        private final EventPropertyGetter getter;
        private final String fragmentType;

        public FragmentTypeEval(int streamId, EventType eventType, String resolvedPropertyName) {
            this.streamId = streamId;
            this.getter = eventType.getGetter(resolvedPropertyName);
            this.fragmentType = eventType.getFragmentType(resolvedPropertyName).getFragmentType().getName();
        }

        @Override
        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            EventBean theEvent = eventsPerStream[this.streamId];
            if (theEvent == null) {
                return null;
            }
            Object fragment = this.getter.getFragment(theEvent);
            if (fragment == null) {
                return null;
            }
            if (fragment instanceof EventBean) {
                EventBean bean = (EventBean)fragment;
                return bean.getEventType().getName();
            }
            if (fragment.getClass().isArray()) {
                String type = this.fragmentType + "[]";
                return type;
            }
            return null;
        }

        @Override
        public Class getType() {
            return String.class;
        }
    }

    public static class StreamEventTypeEval
    implements ExprEvaluator {
        private final int streamNum;

        public StreamEventTypeEval(int streamNum) {
            this.streamNum = streamNum;
        }

        @Override
        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            EventBean theEvent = eventsPerStream[this.streamNum];
            if (theEvent == null) {
                return null;
            }
            if (theEvent instanceof VariantEvent) {
                String typeName = ((VariantEvent)((Object)theEvent)).getUnderlyingEventBean().getEventType().getName();
                return typeName;
            }
            return theEvent.getEventType().getName();
        }

        @Override
        public Class getType() {
            return String.class;
        }
    }
}

