/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.methodagg;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationAgent;
import com.espertech.esper.epl.agg.access.AggregationStateKey;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationMethodFactoryUtil;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.methodagg.ExprMethodAggUtil;
import com.espertech.esper.epl.expression.methodagg.ExprRateAggNode;

public class ExprRateAggNodeFactory
implements AggregationMethodFactory {
    private final ExprRateAggNode parent;
    private final boolean isEver;
    private final long intervalMSec;

    public ExprRateAggNodeFactory(ExprRateAggNode parent, boolean isEver, long intervalMSec) {
        this.parent = parent;
        this.isEver = isEver;
        this.intervalMSec = intervalMSec;
    }

    @Override
    public boolean isAccessAggregation() {
        return false;
    }

    @Override
    public Class getResultType() {
        return Double.class;
    }

    @Override
    public AggregationStateKey getAggregationStateKey(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationStateFactory getAggregationStateFactory(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationAccessor getAccessor() {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationMethod make(MethodResolutionService methodResolutionService, int agentInstanceId, int groupId, int aggregationId) {
        if (this.isEver) {
            return methodResolutionService.makeRateEverAggregator(agentInstanceId, groupId, aggregationId, this.intervalMSec);
        }
        return methodResolutionService.makeRateAggregator(agentInstanceId, groupId, aggregationId);
    }

    @Override
    public ExprAggregateNodeBase getAggregationExpression() {
        return this.parent;
    }

    @Override
    public void validateIntoTableCompatible(AggregationMethodFactory intoTableAgg) throws ExprValidationException {
        AggregationMethodFactoryUtil.validateAggregationType(this, intoTableAgg);
        ExprRateAggNodeFactory that = (ExprRateAggNodeFactory)intoTableAgg;
        if (this.intervalMSec != that.intervalMSec) {
            throw new ExprValidationException("The size is " + this.intervalMSec + " and provided is " + that.intervalMSec);
        }
        AggregationMethodFactoryUtil.validateAggregationUnbound(!this.isEver, !that.isEver);
    }

    @Override
    public AggregationAgent getAggregationStateAgent() {
        return null;
    }

    @Override
    public ExprEvaluator getMethodAggregationEvaluator(boolean join, EventType[] typesPerStream) throws ExprValidationException {
        return ExprMethodAggUtil.getDefaultEvaluator(this.parent.getPositionalParams(), join, typesPerStream);
    }
}

