/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.ops.ExprConcatNodeEvalThreadLocal;
import com.espertech.esper.epl.expression.ops.ExprConcatNodeEvalWNew;
import java.io.StringWriter;

public class ExprConcatNode
extends ExprNodeBase {
    private static final long serialVersionUID = 5811427566733004327L;
    private ExprEvaluator evaluator;

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length < 2) {
            throw new ExprValidationException("Concat node must have at least 2 parameters");
        }
        ExprEvaluator[] evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        for (int i = 0; i < evaluators.length; ++i) {
            String childTypeName;
            Class childType = evaluators[i].getType();
            String string = childTypeName = childType == null ? "null" : childType.getSimpleName();
            if (childType == String.class) continue;
            throw new ExprValidationException("Implicit conversion from datatype '" + childTypeName + "' to string is not allowed");
        }
        ConfigurationEngineDefaults.ThreadingProfile threadingProfile = validationContext.getMethodResolutionService().getEngineImportService().getThreadingProfile();
        this.evaluator = threadingProfile == ConfigurationEngineDefaults.ThreadingProfile.LARGE ? new ExprConcatNodeEvalWNew(this, evaluators) : new ExprConcatNodeEvalThreadLocal(this, evaluators);
        return null;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this.evaluator;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        String delimiter = "";
        for (ExprNode child : this.getChildNodes()) {
            writer.append(delimiter);
            child.toEPL(writer, this.getPrecedence());
            delimiter = "||";
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.CONCAT;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprConcatNode;
    }
}

