/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ExprEqualsAllAnyNode
extends ExprNodeBase
implements ExprEvaluator {
    private final boolean isNot;
    private final boolean isAll;
    private boolean mustCoerce;
    private transient SimpleNumberCoercer coercer;
    private boolean hasCollectionOrArray;
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = -2410457251623137179L;

    public ExprEqualsAllAnyNode(boolean isNotEquals, boolean isAll) {
        this.isNot = isNotEquals;
        this.isAll = isAll;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    public boolean isNot() {
        return this.isNot;
    }

    public boolean isAll() {
        return this.isAll;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        Class coercionType;
        if (this.getChildNodes().length < 1) {
            throw new IllegalStateException("Equals group node does not have 1 or more parameters");
        }
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        Class typeOne = JavaClassHelper.getBoxedType(this.evaluators[0].getType());
        if (typeOne.isArray() || JavaClassHelper.isImplementsInterface(typeOne, Collection.class) || JavaClassHelper.isImplementsInterface(typeOne, Map.class)) {
            throw new ExprValidationException("Collection or array comparison is not allowed for the IN, ANY, SOME or ALL keywords");
        }
        ArrayList<Class> comparedTypes = new ArrayList<Class>();
        comparedTypes.add(typeOne);
        this.hasCollectionOrArray = false;
        for (int i = 0; i < this.getChildNodes().length - 1; ++i) {
            Class propType = this.evaluators[i + 1].getType();
            if (propType.isArray()) {
                this.hasCollectionOrArray = true;
                if (propType.getComponentType() == Object.class) continue;
                comparedTypes.add(propType.getComponentType());
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(propType, Collection.class)) {
                this.hasCollectionOrArray = true;
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(propType, Map.class)) {
                this.hasCollectionOrArray = true;
                continue;
            }
            comparedTypes.add(propType);
        }
        try {
            coercionType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new Class[comparedTypes.size()]));
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
        this.mustCoerce = false;
        if (JavaClassHelper.isNumeric(coercionType)) {
            for (Class compareType : comparedTypes) {
                if (coercionType == JavaClassHelper.getBoxedType(compareType)) continue;
                this.mustCoerce = true;
            }
            if (this.mustCoerce) {
                this.coercer = SimpleNumberCoercerFactory.getCoercer(null, JavaClassHelper.getBoxedType(coercionType));
            }
        }
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object result = this.evaluateInternal(eventsPerStream, isNewData, exprEvaluatorContext);
        return result;
    }

    private Object evaluateInternal(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object leftResult = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (this.hasCollectionOrArray) {
            if (this.isAll) {
                return this.compareAllColl(leftResult, eventsPerStream, isNewData, exprEvaluatorContext);
            }
            return this.compareAnyColl(leftResult, eventsPerStream, isNewData, exprEvaluatorContext);
        }
        if (this.mustCoerce && leftResult != null) {
            leftResult = this.coercer.coerceBoxed((Number)leftResult);
        }
        if (this.isAll) {
            return this.compareAll(leftResult, eventsPerStream, isNewData, exprEvaluatorContext);
        }
        return this.compareAny(leftResult, eventsPerStream, isNewData, exprEvaluatorContext);
    }

    private Object compareAll(Object leftResult, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.isNot) {
            int len = this.getChildNodes().length - 1;
            if (len > 0 && leftResult == null) {
                return null;
            }
            boolean hasNonNullRow = false;
            boolean hasNullRow = false;
            for (int i = 1; i <= len; ++i) {
                Object rightResult = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (rightResult != null) {
                    Number right;
                    hasNonNullRow = true;
                    if (!(!this.mustCoerce ? leftResult.equals(rightResult) : leftResult.equals(right = this.coercer.coerceBoxed((Number)rightResult)))) continue;
                    return false;
                }
                hasNullRow = true;
            }
            if (!hasNonNullRow || hasNullRow) {
                return null;
            }
            return true;
        }
        int len = this.getChildNodes().length - 1;
        if (len > 0 && leftResult == null) {
            return null;
        }
        boolean hasNonNullRow = false;
        boolean hasNullRow = false;
        for (int i = 1; i <= len; ++i) {
            Object rightResult = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (rightResult != null) {
                Number right;
                hasNonNullRow = true;
                if (!(!this.mustCoerce ? !leftResult.equals(rightResult) : !leftResult.equals(right = this.coercer.coerceBoxed((Number)rightResult)))) continue;
                return false;
            }
            hasNullRow = true;
        }
        if (!hasNonNullRow || hasNullRow) {
            return null;
        }
        return true;
    }

    private Object compareAllColl(Object leftResult, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.isNot) {
            int len = this.getChildNodes().length - 1;
            boolean hasNonNullRow = false;
            boolean hasNullRow = false;
            for (int i = 1; i <= len; ++i) {
                Number right;
                Number left;
                Object rightResult = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (rightResult == null) {
                    hasNullRow = true;
                    continue;
                }
                if (rightResult instanceof Collection) {
                    if (leftResult == null) {
                        return null;
                    }
                    Collection coll = (Collection)rightResult;
                    if (coll.contains(leftResult)) {
                        return false;
                    }
                    hasNonNullRow = true;
                    continue;
                }
                if (rightResult instanceof Map) {
                    if (leftResult == null) {
                        return null;
                    }
                    Map coll = (Map)rightResult;
                    if (coll.containsKey(leftResult)) {
                        return false;
                    }
                    hasNonNullRow = true;
                    continue;
                }
                if (rightResult.getClass().isArray()) {
                    int arrayLength = Array.getLength(rightResult);
                    for (int index = 0; index < arrayLength; ++index) {
                        Number right2;
                        Number left2;
                        Object item = Array.get(rightResult, index);
                        if (item == null) {
                            hasNullRow = true;
                            continue;
                        }
                        if (leftResult == null) {
                            return null;
                        }
                        hasNonNullRow = true;
                        if (!(!this.mustCoerce ? leftResult.equals(item) : item instanceof Number && (left2 = this.coercer.coerceBoxed((Number)leftResult)).equals(right2 = this.coercer.coerceBoxed((Number)item)))) continue;
                        return false;
                    }
                    continue;
                }
                if (leftResult == null) {
                    return null;
                }
                if (!(!this.mustCoerce ? leftResult.equals(rightResult) : (left = this.coercer.coerceBoxed((Number)leftResult)).equals(right = this.coercer.coerceBoxed((Number)rightResult)))) continue;
                return false;
            }
            if (!hasNonNullRow || hasNullRow) {
                return null;
            }
            return true;
        }
        int len = this.getChildNodes().length - 1;
        boolean hasNonNullRow = false;
        boolean hasNullRow = false;
        for (int i = 1; i <= len; ++i) {
            Number right;
            Number left;
            Object rightResult = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (rightResult == null) {
                hasNullRow = true;
                continue;
            }
            if (rightResult instanceof Collection) {
                hasNonNullRow = true;
                if (leftResult == null) {
                    return null;
                }
                Collection coll = (Collection)rightResult;
                if (coll.contains(leftResult)) continue;
                return false;
            }
            if (rightResult instanceof Map) {
                if (leftResult == null) {
                    return null;
                }
                Map coll = (Map)rightResult;
                if (!coll.containsKey(leftResult)) {
                    return false;
                }
                hasNonNullRow = true;
                continue;
            }
            if (rightResult.getClass().isArray()) {
                int arrayLength = Array.getLength(rightResult);
                for (int index = 0; index < arrayLength; ++index) {
                    Number right3;
                    Number left3;
                    Object item = Array.get(rightResult, index);
                    if (item == null) {
                        hasNullRow = true;
                        continue;
                    }
                    if (leftResult == null) {
                        return null;
                    }
                    hasNonNullRow = true;
                    if (!(!this.mustCoerce ? !leftResult.equals(item) : item instanceof Number && !(left3 = this.coercer.coerceBoxed((Number)leftResult)).equals(right3 = this.coercer.coerceBoxed((Number)item)))) continue;
                    return false;
                }
                continue;
            }
            if (leftResult == null) {
                return null;
            }
            if (!(!this.mustCoerce ? !leftResult.equals(rightResult) : !(left = this.coercer.coerceBoxed((Number)leftResult)).equals(right = this.coercer.coerceBoxed((Number)rightResult)))) continue;
            return false;
        }
        if (!hasNonNullRow || hasNullRow) {
            return null;
        }
        return true;
    }

    private Object compareAny(Object leftResult, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.isNot) {
            boolean hasNonNullRow = false;
            boolean hasNullRow = false;
            int len = this.getChildNodes().length - 1;
            for (int i = 1; i <= len; ++i) {
                Number right;
                Object rightResult = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (leftResult == null) {
                    return null;
                }
                if (rightResult == null) {
                    hasNullRow = true;
                    continue;
                }
                hasNonNullRow = true;
                if (!(!this.mustCoerce ? !leftResult.equals(rightResult) : !leftResult.equals(right = this.coercer.coerceBoxed((Number)rightResult)))) continue;
                return true;
            }
            if (!hasNonNullRow || hasNullRow) {
                return null;
            }
            return false;
        }
        int len = this.getChildNodes().length - 1;
        if (len > 0 && leftResult == null) {
            return null;
        }
        boolean hasNonNullRow = false;
        boolean hasNullRow = false;
        for (int i = 1; i <= len; ++i) {
            Number right;
            Object rightResult = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (rightResult == null) {
                hasNullRow = true;
                continue;
            }
            hasNonNullRow = true;
            if (!(!this.mustCoerce ? leftResult.equals(rightResult) : leftResult.equals(right = this.coercer.coerceBoxed((Number)rightResult)))) continue;
            return true;
        }
        if (!hasNonNullRow || hasNullRow) {
            return null;
        }
        return false;
    }

    private Object compareAnyColl(Object leftResult, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.isNot) {
            int len = this.getChildNodes().length - 1;
            boolean hasNonNullRow = false;
            boolean hasNullRow = false;
            for (int i = 1; i <= len; ++i) {
                Number right;
                Number left;
                Object rightResult = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (rightResult == null) {
                    hasNullRow = true;
                    continue;
                }
                if (rightResult instanceof Collection) {
                    if (leftResult == null) {
                        return null;
                    }
                    Collection coll = (Collection)rightResult;
                    if (!coll.contains(leftResult)) {
                        return true;
                    }
                    hasNonNullRow = true;
                    continue;
                }
                if (rightResult instanceof Map) {
                    if (leftResult == null) {
                        return null;
                    }
                    Map coll = (Map)rightResult;
                    if (!coll.containsKey(leftResult)) {
                        return true;
                    }
                    hasNonNullRow = true;
                    continue;
                }
                if (rightResult.getClass().isArray()) {
                    int arrayLength = Array.getLength(rightResult);
                    if (arrayLength > 0 && leftResult == null) {
                        return null;
                    }
                    for (int index = 0; index < arrayLength; ++index) {
                        Number right2;
                        Number left2;
                        Object item = Array.get(rightResult, index);
                        if (item == null) {
                            hasNullRow = true;
                            continue;
                        }
                        hasNonNullRow = true;
                        if (!(!this.mustCoerce ? !leftResult.equals(item) : item instanceof Number && !(left2 = this.coercer.coerceBoxed((Number)leftResult)).equals(right2 = this.coercer.coerceBoxed((Number)item)))) continue;
                        return true;
                    }
                    continue;
                }
                if (leftResult == null) {
                    return null;
                }
                hasNonNullRow = true;
                if (!(!this.mustCoerce ? !leftResult.equals(rightResult) : !(left = this.coercer.coerceBoxed((Number)leftResult)).equals(right = this.coercer.coerceBoxed((Number)rightResult)))) continue;
                return true;
            }
            if (!hasNonNullRow || hasNullRow) {
                return null;
            }
            return false;
        }
        int len = this.getChildNodes().length - 1;
        boolean hasNonNullRow = false;
        boolean hasNullRow = false;
        for (int i = 1; i <= len; ++i) {
            Number right;
            Number left;
            Object rightResult = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (rightResult == null) {
                hasNonNullRow = true;
                continue;
            }
            if (rightResult instanceof Collection) {
                if (leftResult == null) {
                    return null;
                }
                hasNonNullRow = true;
                Collection coll = (Collection)rightResult;
                if (!coll.contains(leftResult)) continue;
                return true;
            }
            if (rightResult instanceof Map) {
                if (leftResult == null) {
                    return null;
                }
                Map coll = (Map)rightResult;
                if (coll.containsKey(leftResult)) {
                    return true;
                }
                hasNonNullRow = true;
                continue;
            }
            if (rightResult.getClass().isArray()) {
                int arrayLength = Array.getLength(rightResult);
                if (arrayLength > 0 && leftResult == null) {
                    return null;
                }
                for (int index = 0; index < arrayLength; ++index) {
                    Number right3;
                    Number left3;
                    Object item = Array.get(rightResult, index);
                    if (item == null) {
                        hasNullRow = true;
                        continue;
                    }
                    hasNonNullRow = true;
                    if (!(!this.mustCoerce ? leftResult.equals(item) : item instanceof Number && (left3 = this.coercer.coerceBoxed((Number)leftResult)).equals(right3 = this.coercer.coerceBoxed((Number)item)))) continue;
                    return true;
                }
                continue;
            }
            if (leftResult == null) {
                return null;
            }
            hasNonNullRow = true;
            if (!(!this.mustCoerce ? leftResult.equals(rightResult) : (left = this.coercer.coerceBoxed((Number)leftResult)).equals(right = this.coercer.coerceBoxed((Number)rightResult)))) continue;
            return true;
        }
        if (!hasNonNullRow || hasNullRow) {
            return null;
        }
        return false;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence());
        if (this.isAll) {
            if (this.isNot) {
                writer.append("!=all");
            } else {
                writer.append("=all");
            }
        } else if (this.isNot) {
            writer.append("!=any");
        } else {
            writer.append("=any");
        }
        writer.append("(");
        String delimiter = "";
        for (int i = 0; i < this.getChildNodes().length - 1; ++i) {
            writer.append(delimiter);
            this.getChildNodes()[i + 1].toEPL(writer, this.getPrecedence());
            delimiter = ",";
        }
        writer.append(")");
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.EQUALS;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprEqualsAllAnyNode)) {
            return false;
        }
        ExprEqualsAllAnyNode other = (ExprEqualsAllAnyNode)node;
        return other.isNot == this.isNot && other.isAll == this.isAll;
    }
}

