/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.LikeUtil;
import java.io.StringWriter;

public class ExprLikeNode
extends ExprNodeBase
implements ExprEvaluator {
    private final boolean isNot;
    private boolean isNumericValue;
    private boolean isConstantPattern;
    private transient LikeUtil likeUtil;
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = 34888860063217132L;

    public ExprLikeNode(boolean not) {
        this.isNot = not;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        ExprEvaluator escapeChildNode;
        if (this.getChildNodes().length != 2 && this.getChildNodes().length != 3) {
            throw new ExprValidationException("The 'like' operator requires 2 (no escape) or 3 (with escape) child expressions");
        }
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        Class evalChildType = this.evaluators[0].getType();
        this.isNumericValue = JavaClassHelper.isNumeric(evalChildType);
        if (evalChildType != String.class && !this.isNumericValue) {
            throw new ExprValidationException("The 'like' operator requires a String or numeric type left-hand expression");
        }
        ExprEvaluator patternChildNode = this.evaluators[1];
        Class patternChildType = patternChildNode.getType();
        if (patternChildType != String.class) {
            throw new ExprValidationException("The 'like' operator requires a String-type pattern expression");
        }
        if (this.getChildNodes()[1].isConstantResult()) {
            this.isConstantPattern = true;
        }
        if (this.getChildNodes().length == 3 && (escapeChildNode = this.evaluators[2]).getType() != String.class) {
            throw new ExprValidationException("The 'like' operator escape parameter requires a character-type value");
        }
        return null;
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        String patternVal;
        if (this.likeUtil == null) {
            patternVal = (String)this.evaluators[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (patternVal == null) {
                return null;
            }
            String escape = "\\";
            Character escapeCharacter = null;
            if (this.getChildNodes().length == 3) {
                escape = (String)this.evaluators[2].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            }
            if (escape.length() > 0) {
                escapeCharacter = Character.valueOf(escape.charAt(0));
            }
            this.likeUtil = new LikeUtil(patternVal, escapeCharacter, false);
        } else if (!this.isConstantPattern) {
            patternVal = (String)this.evaluators[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (patternVal == null) {
                return null;
            }
            this.likeUtil.resetPattern(patternVal);
        }
        Object evalValue = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (evalValue == null) {
            return null;
        }
        if (this.isNumericValue) {
            evalValue = evalValue.toString();
        }
        Boolean result = this.likeUtil.compare((String)evalValue);
        if (this.isNot) {
            return result == false;
        }
        return result;
    }

    @Override
    public boolean equalsNode(ExprNode node_) {
        if (!(node_ instanceof ExprLikeNode)) {
            return false;
        }
        ExprLikeNode other = (ExprLikeNode)node_;
        return this.isNot == other.isNot;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence());
        if (this.isNot) {
            writer.append(" not");
        }
        writer.append(" like ");
        this.getChildNodes()[1].toEPL(writer, this.getPrecedence());
        if (this.getChildNodes().length == 3) {
            writer.append(" escape ");
            this.getChildNodes()[2].toEPL(writer, this.getPrecedence());
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }

    public boolean isNot() {
        return this.isNot;
    }
}

