/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.prev;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.prev.ExprPreviousEvalStrategy;
import com.espertech.esper.view.window.IStreamRelativeAccess;
import com.espertech.esper.view.window.RandomAccessByIndex;
import com.espertech.esper.view.window.RandomAccessByIndexGetter;
import com.espertech.esper.view.window.RelativeAccessByEventNIndexMap;
import java.util.Collection;
import java.util.Collections;

public class ExprPreviousEvalStrategyPrev
implements ExprPreviousEvalStrategy {
    private final int streamNumber;
    private final ExprEvaluator indexNode;
    private final ExprEvaluator evalNode;
    private final RandomAccessByIndexGetter randomAccessGetter;
    private final RelativeAccessByEventNIndexMap relativeAccessGetter;
    private final boolean isConstantIndex;
    private final Integer constantIndexNumber;
    private final boolean isTail;

    public ExprPreviousEvalStrategyPrev(int streamNumber, ExprEvaluator indexNode, ExprEvaluator evalNode, RandomAccessByIndexGetter randomAccessGetter, RelativeAccessByEventNIndexMap relativeAccessGetter, boolean constantIndex, Integer constantIndexNumber, boolean tail) {
        this.streamNumber = streamNumber;
        this.indexNode = indexNode;
        this.evalNode = evalNode;
        this.randomAccessGetter = randomAccessGetter;
        this.relativeAccessGetter = relativeAccessGetter;
        this.isConstantIndex = constantIndex;
        this.constantIndexNumber = constantIndexNumber;
        this.isTail = tail;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean substituteEvent = this.getSubstitute(eventsPerStream, exprEvaluatorContext);
        if (substituteEvent == null) {
            return null;
        }
        EventBean originalEvent = eventsPerStream[this.streamNumber];
        eventsPerStream[this.streamNumber] = substituteEvent;
        Object evalResult = this.evalNode.evaluate(eventsPerStream, true, exprEvaluatorContext);
        eventsPerStream[this.streamNumber] = originalEvent;
        return evalResult;
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        return this.getSubstitute(eventsPerStream, context);
    }

    @Override
    public Collection<EventBean> evaluateGetCollEvents(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public Collection evaluateGetCollScalar(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        Object result = this.evaluate(eventsPerStream, context);
        if (result == null) {
            return null;
        }
        return Collections.singletonList(result);
    }

    private EventBean getSubstitute(EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean substituteEvent;
        Integer index;
        if (this.isConstantIndex) {
            index = this.constantIndexNumber;
        } else {
            Object indexResult = this.indexNode.evaluate(eventsPerStream, true, exprEvaluatorContext);
            if (indexResult == null) {
                return null;
            }
            index = ((Number)indexResult).intValue();
        }
        if (this.randomAccessGetter != null) {
            RandomAccessByIndex randomAccess = this.randomAccessGetter.getAccessor();
            substituteEvent = !this.isTail ? randomAccess.getNewData(index) : randomAccess.getNewDataTail(index);
        } else {
            EventBean evalEvent = eventsPerStream[this.streamNumber];
            IStreamRelativeAccess relativeAccess = this.relativeAccessGetter.getAccessor(evalEvent);
            if (relativeAccess == null) {
                return null;
            }
            substituteEvent = !this.isTail ? relativeAccess.getRelativeToEvent(evalEvent, index) : relativeAccess.getRelativeToEnd(evalEvent, index);
        }
        return substituteEvent;
    }
}

