/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.subquery;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.core.ExprEvaluatorTypableReturn;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.subquery.ExprSubselectStrategy;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import java.io.StringWriter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

public abstract class ExprSubselectNode
extends ExprNodeBase
implements ExprEvaluator,
ExprEvaluatorEnumeration,
ExprEvaluatorTypableReturn {
    public static final ExprSubselectNode[] EMPTY_SUBSELECT_ARRAY = new ExprSubselectNode[0];
    private static final long serialVersionUID = -2469169635913155764L;
    protected ExprNode[] selectClause;
    protected transient ExprEvaluator[] selectClauseEvaluator;
    protected String[] selectAsNames;
    protected transient ExprEvaluator filterExpr;
    protected transient EventType rawEventType;
    protected String statementName;
    private transient StreamTypeService filterSubqueryStreamTypes;
    private StatementSpecRaw statementSpecRaw;
    private transient StatementSpecCompiled statementSpecCompiled;
    private transient ExprSubselectStrategy strategy;
    private transient SubqueryAggregationType subselectAggregationType;
    protected int subselectNumber;
    private boolean filterStreamSubselect;
    protected transient AggregationService subselectAggregationService;

    public abstract Object evaluate(EventBean[] var1, boolean var2, Collection<EventBean> var3, ExprEvaluatorContext var4);

    public abstract Collection<EventBean> evaluateGetCollEvents(EventBean[] var1, boolean var2, Collection<EventBean> var3, ExprEvaluatorContext var4);

    public abstract Collection evaluateGetCollScalar(EventBean[] var1, boolean var2, Collection<EventBean> var3, ExprEvaluatorContext var4);

    public abstract EventBean evaluateGetEventBean(EventBean[] var1, boolean var2, Collection<EventBean> var3, ExprEvaluatorContext var4);

    public abstract boolean isAllowMultiColumnSelect();

    public abstract void validateSubquery(ExprValidationContext var1) throws ExprValidationException;

    public abstract LinkedHashMap<String, Object> typableGetRowProperties() throws ExprValidationException;

    public abstract Object[] evaluateTypableSingle(EventBean[] var1, boolean var2, Collection<EventBean> var3, ExprEvaluatorContext var4);

    public abstract Object[][] evaluateTypableMulti(EventBean[] var1, boolean var2, Collection<EventBean> var3, ExprEvaluatorContext var4);

    public ExprSubselectNode(StatementSpecRaw statementSpec) {
        this.statementSpecRaw = statementSpec;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.statementName = validationContext.getStatementName();
        this.validateSubquery(validationContext);
        return null;
    }

    public void setStatementSpecCompiled(StatementSpecCompiled statementSpecCompiled, int subselectNumber) {
        this.statementSpecCompiled = statementSpecCompiled;
        this.subselectNumber = subselectNumber;
    }

    public StatementSpecCompiled getStatementSpecCompiled() {
        return this.statementSpecCompiled;
    }

    public void setSelectClause(ExprNode[] selectClause) {
        this.selectClause = selectClause;
        this.selectClauseEvaluator = ExprNodeUtility.getEvaluators(selectClause);
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Collection<EventBean> matchingEvents = this.evaluateMatching(eventsPerStream, exprEvaluatorContext);
        return this.evaluate(eventsPerStream, isNewData, matchingEvents, exprEvaluatorContext);
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Collection<EventBean> matchingEvents = this.evaluateMatching(eventsPerStream, exprEvaluatorContext);
        return this.evaluateGetCollEvents(eventsPerStream, isNewData, matchingEvents, exprEvaluatorContext);
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Collection<EventBean> matchingEvents = this.evaluateMatching(eventsPerStream, exprEvaluatorContext);
        return this.evaluateGetCollScalar(eventsPerStream, isNewData, matchingEvents, exprEvaluatorContext);
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Collection<EventBean> matchingEvents = this.evaluateMatching(eventsPerStream, context);
        return this.evaluateGetEventBean(eventsPerStream, isNewData, matchingEvents, context);
    }

    private Collection<EventBean> evaluateMatching(EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        return this.strategy.evaluateMatching(eventsPerStream, exprEvaluatorContext);
    }

    @Override
    public LinkedHashMap<String, Object> getRowProperties() throws ExprValidationException {
        return this.typableGetRowProperties();
    }

    @Override
    public Boolean isMultirow() {
        return true;
    }

    @Override
    public Object[] evaluateTypableSingle(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Collection<EventBean> matching = this.strategy.evaluateMatching(eventsPerStream, context);
        return this.evaluateTypableSingle(eventsPerStream, isNewData, matching, context);
    }

    @Override
    public Object[][] evaluateTypableMulti(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Collection<EventBean> matching = this.strategy.evaluateMatching(eventsPerStream, context);
        return this.evaluateTypableMulti(eventsPerStream, isNewData, matching, context);
    }

    public StatementSpecRaw getStatementSpecRaw() {
        return this.statementSpecRaw;
    }

    public void setSelectAsNames(String[] selectAsNames) {
        this.selectAsNames = selectAsNames;
    }

    public void setFilterExpr(ExprEvaluator filterExpr) {
        this.filterExpr = filterExpr;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (this.selectAsNames != null && this.selectAsNames[0] != null) {
            writer.append(this.selectAsNames[0]);
            return;
        }
        writer.append("subselect_");
        writer.append(Integer.toString(this.subselectNumber));
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        return false;
    }

    public void setStrategy(ExprSubselectStrategy strategy) {
        this.strategy = strategy;
    }

    public void setRawEventType(EventType rawEventType) {
        this.rawEventType = rawEventType;
    }

    public ExprNode[] getSelectClause() {
        return this.selectClause;
    }

    public ExprEvaluator getFilterExpr() {
        return this.filterExpr;
    }

    public EventType getRawEventType() {
        return this.rawEventType;
    }

    public StreamTypeService getFilterSubqueryStreamTypes() {
        return this.filterSubqueryStreamTypes;
    }

    public void setFilterSubqueryStreamTypes(StreamTypeService filterSubqueryStreamTypes) {
        this.filterSubqueryStreamTypes = filterSubqueryStreamTypes;
    }

    public SubqueryAggregationType getSubselectAggregationType() {
        return this.subselectAggregationType;
    }

    public void setSubselectAggregationType(SubqueryAggregationType subselectAggregationType) {
        this.subselectAggregationType = subselectAggregationType;
    }

    public int getSubselectNumber() {
        return this.subselectNumber;
    }

    public void setFilterStreamSubselect(boolean filterStreamSubselect) {
        this.filterStreamSubselect = filterStreamSubselect;
    }

    public boolean isFilterStreamSubselect() {
        return this.filterStreamSubselect;
    }

    public static ExprSubselectNode[] toArray(List<ExprSubselectNode> subselectNodes) {
        if (subselectNodes.isEmpty()) {
            return EMPTY_SUBSELECT_ARRAY;
        }
        return subselectNodes.toArray(new ExprSubselectNode[subselectNodes.size()]);
    }

    public void setSubselectAggregationService(AggregationService subselectAggregationService) {
        this.subselectAggregationService = subselectAggregationService;
    }

    public AggregationService getSubselectAggregationService() {
        return this.subselectAggregationService;
    }

    public static enum SubqueryAggregationType {
        NONE,
        FULLY_AGGREGATED,
        AGGREGATED;

    }
}

