/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.core.ExprEvaluatorEnumerationGivenEvent;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.dot.ExprDotEnumerationSourceForProps;
import com.espertech.esper.epl.expression.dot.ExprDotNodeUtility;
import com.espertech.esper.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.epl.rettype.EPType;
import com.espertech.esper.epl.rettype.EPTypeHelper;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumn;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnAggregation;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnPlain;
import com.espertech.esper.event.EventAdapterService;
import java.io.StringWriter;
import java.util.Collection;

public class ExprTableAccessNodeSubprop
extends ExprTableAccessNode
implements ExprEvaluator,
ExprEvaluatorEnumeration {
    private static final long serialVersionUID = 1779238498208599159L;
    private final String subpropName;
    private Class bindingReturnType;
    private transient EPType optionalEnumerationType;
    private transient ExprEvaluatorEnumerationGivenEvent optionalPropertyEnumEvaluator;

    public ExprTableAccessNodeSubprop(String tableName, String subpropName) {
        super(tableName);
        this.subpropName = subpropName;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    protected void validateBindingInternal(ExprValidationContext validationContext, TableMetadata tableMetadata) throws ExprValidationException {
        this.validateGroupKeys(tableMetadata);
        TableMetadataColumn column = this.validateSubpropertyGetCol(tableMetadata, this.subpropName);
        if (column instanceof TableMetadataColumnPlain) {
            this.bindingReturnType = tableMetadata.getInternalEventType().getPropertyType(this.subpropName);
            ExprDotEnumerationSourceForProps enumerationSource = ExprDotNodeUtility.getPropertyEnumerationSource(this.subpropName, 0, tableMetadata.getInternalEventType(), true, true);
            this.optionalEnumerationType = enumerationSource.getReturnType();
            this.optionalPropertyEnumEvaluator = enumerationSource.getEnumerationGivenEvent();
        } else {
            TableMetadataColumnAggregation aggcol = (TableMetadataColumnAggregation)column;
            this.optionalEnumerationType = aggcol.getOptionalEnumerationType();
            this.bindingReturnType = aggcol.getFactory().getResultType();
        }
    }

    @Override
    public Class getType() {
        return this.bindingReturnType;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.strategy.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.toPrecedenceFreeEPLInternal(writer, this.subpropName);
    }

    public String getSubpropName() {
        return this.subpropName;
    }

    @Override
    public EventType getEventTypeCollection(EventAdapterService eventAdapterService, String statementId) throws ExprValidationException {
        return EPTypeHelper.optionalIsEventTypeColl(this.optionalEnumerationType);
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.strategy.evaluateGetROCollectionEvents(eventsPerStream, isNewData, context);
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        return EPTypeHelper.optionalIsComponentTypeColl(this.optionalEnumerationType);
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.strategy.evaluateGetROCollectionScalar(eventsPerStream, isNewData, context);
    }

    @Override
    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, String statementId) throws ExprValidationException {
        return EPTypeHelper.optionalIsEventTypeSingle(this.optionalEnumerationType);
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.strategy.evaluateGetEventBean(eventsPerStream, isNewData, context);
    }

    public ExprEvaluatorEnumerationGivenEvent getOptionalPropertyEnumEvaluator() {
        return this.optionalPropertyEnumEvaluator;
    }

    @Override
    protected boolean equalsNodeInternal(ExprTableAccessNode other) {
        ExprTableAccessNodeSubprop that = (ExprTableAccessNodeSubprop)other;
        return this.subpropName.equals(that.subpropName);
    }
}

