/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.table;

import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.util.JavaClassHelper;

public class ExprTableNodeUtil {
    public static void validateExpressions(String tableName, Class[] providedTypes, String providedName, ExprNode[] providedExpr, Class[] expectedTypes, String expectedName) throws ExprValidationException {
        if (expectedTypes.length != providedTypes.length) {
            String actual = (providedTypes.length == 0 ? "no" : "" + providedTypes.length) + " " + providedName + " expressions";
            String expected = (expectedTypes.length == 0 ? "no" : "" + expectedTypes.length) + " " + expectedName + " expressions";
            throw new ExprValidationException("Incompatible number of " + providedName + " expressions for use with table '" + tableName + "', the table expects " + expected + " and provided are " + actual);
        }
        for (int i = 0; i < expectedTypes.length; ++i) {
            Class expected;
            Class actual = JavaClassHelper.getBoxedType(providedTypes[i]);
            if (JavaClassHelper.isSubclassOrImplementsInterface(actual, expected = JavaClassHelper.getBoxedType(expectedTypes[i]))) continue;
            throw new ExprValidationException("Incompatible type returned by a " + providedName + " expression for use with table '" + tableName + "', the " + providedName + " expression '" + ExprNodeUtility.toExpressionStringMinPrecedence(providedExpr) + "' returns '" + JavaClassHelper.getClassNameFullyQualPretty(actual) + "' but the table expects '" + JavaClassHelper.getClassNameFullyQualPretty(expected) + "'");
        }
    }
}

